/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.Database;
import com.caucho.db.index.BTree;
import com.caucho.db.index.KeyCompare;
import com.caucho.db.sql.CreateQuery;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.Parser;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.store.Block;
import com.caucho.db.store.Lock;
import com.caucho.db.store.Store;
import com.caucho.db.store.Transaction;
import com.caucho.db.table.Column;
import com.caucho.db.table.Constraint;
import com.caucho.db.table.NumericColumn;
import com.caucho.db.table.Row;
import com.caucho.db.table.TableFactory;
import com.caucho.db.table.TableIterator;
import com.caucho.log.Log;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table
extends Store {
    private static final Logger log = Log.open(Table.class);
    private static final L10N L = new L10N(Table.class);
    private static final int ROOT_DATA_OFFSET = 1024;
    private static final int INDEX_ROOT_OFFSET = 1056;
    private static final int ROOT_DATA_END = 2048;
    public static final int INLINE_BLOB_SIZE = 120;
    public static final long ROW_CLOCK_MIN = 1024L;
    public static final byte ROW_VALID = 1;
    public static final byte ROW_ALLOC = 2;
    public static final byte ROW_MASK = 3;
    private static final String DB_VERSION = "Resin-DB 3.1.1";
    private static final String MIN_VERSION = "Resin-DB 3.1.1";
    private final Row _row;
    private final int _rowLength;
    private final int _rowsPerBlock;
    private final int _rowEnd;
    private final Constraint[] _constraints;
    private final Column _autoIncrementColumn;
    private long _entries;
    private final Object _rowClockLock = new Object();
    private long _rowClockAddr;
    private long _rowClockTotal;
    private long _rowClockUsed;
    private int _rowClockCount;
    private int _rowAllocCount;
    private long _autoIncrementValue = -1L;
    private Lock _allocLock;
    private Lock _insertLock;

    Table(Database database, String name, Row row, Constraint[] constraints) {
        super(database, name, null);
        this._row = row;
        this._constraints = constraints;
        this._rowLength = this._row.getLength();
        this._rowsPerBlock = 65536 / this._rowLength;
        this._rowEnd = this._rowLength * this._rowsPerBlock;
        this._rowClockAddr = 0L;
        Column[] columns = this._row.getColumns();
        Column autoIncrementColumn = null;
        for (int i = 0; i < columns.length; ++i) {
            columns[i].setTable(this);
            if (columns[i].getAutoIncrement() < 0) continue;
            autoIncrementColumn = columns[i];
        }
        this._autoIncrementColumn = autoIncrementColumn;
        this._insertLock = new Lock("table-insert:" + name);
        this._allocLock = new Lock("table-alloc:" + name);
    }

    Row getRow() {
        return this._row;
    }

    int getRowLength() {
        return this._rowLength;
    }

    int getRowEnd() {
        return this._rowEnd;
    }

    public final Column[] getColumns() {
        return this._row.getColumns();
    }

    public final Constraint[] getConstraints() {
        return this._constraints;
    }

    public Column getAutoIncrementColumn() {
        return this._autoIncrementColumn;
    }

    public Column getColumn(String name) {
        Column[] columns = this.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].getName().equals(name)) continue;
            return columns[i];
        }
        return null;
    }

    public int getColumnIndex(String name) throws SQLException {
        Column[] columns = this.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Table loadFromFile(Database db, String name) throws IOException, SQLException {
        Table table2;
        int ch;
        Path path = db.getPath().lookup(name + ".db");
        if (!path.exists()) {
            throw new IOException(L.l("table {0} does not exist", (Object)name));
        }
        String version = null;
        ReadStream is = path.openRead();
        try {
            is.skip(66560L);
            StringBuilder sb = new StringBuilder();
            while ((ch = is.read()) > 0) {
                sb.append((char)ch);
            }
            version = sb.toString();
            if (!version.startsWith("Resin-DB")) {
                throw new SQLException(L.l("table {0} is not a Resin DB.  Version '{1}'", (Object)name, (Object)version));
            }
            if (version.compareTo("Resin-DB 3.1.1") < 0) throw new SQLException(L.l("table {0} is out of date.  Old version {1}.", (Object)name, (Object)version));
            if ("Resin-DB 3.1.1".compareTo(version) < 0) {
                throw new SQLException(L.l("table {0} is out of date.  Old version {1}.", (Object)name, (Object)version));
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            is.close();
            throw throwable;
        }
        is.close();
        is = path.openRead();
        try {
            is.skip(67584L);
            StringBuilder cb = new StringBuilder();
            while ((ch = is.read()) > 0) {
                cb.append((char)ch);
            }
            String sql = cb.toString();
            if (log.isLoggable(Level.FINER)) {
                log.finer("Table[" + name + "] " + version + " loading\n" + sql);
            }
            try {
                CreateQuery query = (CreateQuery)Parser.parse(db, sql);
                TableFactory factory = query.getFactory();
                if (!factory.getName().equalsIgnoreCase(name)) {
                    throw new IOException(L.l("factory {0} does not match", (Object)name));
                }
                Table table = new Table(db, factory.getName(), factory.getRow(), factory.getConstraints());
                table.init();
                table.clearIndexes();
                table.initIndexes();
                table.rebuildIndexes();
                table2 = table;
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
                log.warning(e.toString());
                throw new SQLException(L.l("can't load table {0} in {1}.\n{2}", (Object)name, (Object)path.getNativePath(), (Object)e.toString()));
            }
            Object var13_15 = null;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            is.close();
            throw throwable;
        }
        is.close();
        return table2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create() throws IOException, SQLException {
        super.create();
        this.initIndexes();
        byte[] tempBuffer = new byte[65536];
        this.readBlock(65536L, tempBuffer, 0, 65536);
        TempStream ts = new TempStream();
        WriteStream os = new WriteStream((StreamImpl)ts);
        try {
            for (int i = 0; i < 1024; ++i) {
                os.write((int)tempBuffer[i]);
            }
            this.writeTableHeader(os);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            os.close();
            throw throwable;
        }
        os.close();
        int offset = 0;
        for (TempBuffer head = ts.getHead(); head != null; head = head.getNext()) {
            int length;
            byte[] buffer = head.getBuffer();
            System.arraycopy(buffer, 0, tempBuffer, offset, length);
            for (length = head.getLength(); length < buffer.length; ++length) {
                tempBuffer[offset + length] = 0;
            }
            offset += buffer.length;
        }
        while (offset < 65536) {
            tempBuffer[offset] = 0;
            ++offset;
        }
        this.writeBlock(65536L, tempBuffer, 0, 65536);
        this._database.addTable(this);
    }

    private void initIndexes() throws IOException, SQLException {
        Column[] columns = this._row.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            KeyCompare keyCompare;
            Column column = columns[i];
            if (!column.isUnique() || (keyCompare = column.getIndexKeyCompare()) == null) continue;
            Block rootBlock = this.allocateIndexBlock();
            long rootBlockId = rootBlock.getBlockId();
            rootBlock.free();
            BTree btree = new BTree(this, rootBlockId, column.getLength(), keyCompare);
            column.setIndex(btree);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void clearIndexes() throws IOException {
        Column[] columns = this._row.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            Object var12_10;
            BTree index = columns[i].getIndex();
            if (index == null) continue;
            long rootAddr = index.getIndexRoot();
            Block block = this.readBlock(this.addressToBlockId(rootAddr));
            try {
                byte[] blockBuffer;
                byte[] byArray = blockBuffer = block.getBuffer();
                // MONITORENTER : blockBuffer
                for (int j = 0; j < blockBuffer.length; ++j) {
                    blockBuffer[j] = 0;
                }
                block.setDirty(0, 65536);
                // MONITOREXIT : byArray
                var12_10 = null;
                block.free();
                continue;
            }
            catch (Throwable throwable) {
                var12_10 = null;
                block.free();
                throw throwable;
            }
        }
        long blockAddr = 0L;
        while ((blockAddr = this.firstBlock(blockAddr + 65536L, 4)) > 0L) {
            this.freeBlock(blockAddr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildIndexes() throws IOException, SQLException {
        Transaction xa = Transaction.create();
        xa.setAutoCommit(true);
        try {
            TableIterator iter = this.createTableIterator();
            iter.init(xa);
            Column[] columns = this._row.getColumns();
            while (iter.nextBlock()) {
                iter.initRow();
                byte[] blockBuffer = iter.getBuffer();
                while (iter.nextRow()) {
                    try {
                        long rowAddress = iter.getRowAddress();
                        int rowOffset = iter.getRowOffset();
                        for (int i = 0; i < columns.length; ++i) {
                            Column column = columns[i];
                            column.setIndex(xa, blockBuffer, rowOffset, rowAddress, null);
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.toString(), e);
                    }
                }
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            xa.commit();
            throw throwable;
        }
        xa.commit();
    }

    private void writeTableHeader(WriteStream os) throws IOException {
        int i;
        os.print("Resin-DB 3.1.1");
        os.write(0);
        while (os.getBufferOffset() < 1056) {
            os.write(0);
        }
        Column[] columns = this._row.getColumns();
        for (i = 0; i < columns.length; ++i) {
            if (!columns[i].isUnique()) continue;
            BTree index = columns[i].getIndex();
            if (index != null) {
                this.writeLong(os, index.getIndexRoot());
                continue;
            }
            this.writeLong(os, 0L);
        }
        while (os.getBufferOffset() < 2048) {
            os.write(0);
        }
        os.print("CREATE TABLE " + this.getName() + "(");
        for (i = 0; i < this._row.getColumns().length; ++i) {
            Expr defaultExpr;
            Column column = this._row.getColumns()[i];
            if (i != 0) {
                os.print(",");
            }
            os.print(column.getName());
            os.print(" ");
            switch (column.getTypeCode()) {
                case 1: {
                    os.print("VARCHAR(" + column.getDeclarationSize() + ")");
                    break;
                }
                case 8: {
                    os.print("VARBINARY(" + column.getDeclarationSize() + ")");
                    break;
                }
                case 9: {
                    os.print("SMALLINT");
                    break;
                }
                case 2: {
                    os.print("INTEGER");
                    break;
                }
                case 3: {
                    os.print("BIGINT");
                    break;
                }
                case 4: {
                    os.print("DOUBLE");
                    break;
                }
                case 5: {
                    os.print("TIMESTAMP");
                    break;
                }
                case 6: {
                    os.print("BLOB");
                    break;
                }
                case 7: {
                    NumericColumn numeric = (NumericColumn)column;
                    os.print("NUMERIC(" + numeric.getPrecision() + "," + numeric.getScale() + ")");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            if (column.isPrimaryKey()) {
                os.print(" PRIMARY KEY");
            } else if (column.isUnique()) {
                os.print(" UNIQUE");
            }
            if (column.isNotNull()) {
                os.print(" NOT NULL");
            }
            if ((defaultExpr = column.getDefault()) != null) {
                os.print(" DEFAULT (");
                os.print((Object)defaultExpr);
                os.print(")");
            }
            if (column.getAutoIncrement() < 0) continue;
            os.print(" auto_increment");
        }
        os.print(")");
    }

    public TableIterator createTableIterator() {
        this.assertStoreActive();
        return new TableIterator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextAutoIncrement(QueryContext context) throws SQLException {
        Table table = this;
        synchronized (table) {
            if (this._autoIncrementValue >= 0L) {
                return ++this._autoIncrementValue;
            }
        }
        long max = 0L;
        try {
            TableIterator iter = this.createTableIterator();
            iter.init(context);
            while (iter.next()) {
                byte[] buffer = iter.getBuffer();
                long value = this._autoIncrementColumn.getLong(buffer, iter.getRowOffset());
                if (max >= value) continue;
                max = value;
            }
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
        Table table2 = this;
        synchronized (table2) {
            if (this._autoIncrementValue < max) {
                this._autoIncrementValue = max;
            }
            return ++this._autoIncrementValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insert(QueryContext queryContext, Transaction xa, ArrayList<Column> columns, ArrayList<Expr> values) throws IOException, SQLException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("db table " + this.getName() + " insert row xa:" + xa);
        }
        Block block = null;
        try {
            int rowOffset = 0;
            boolean isLoop = false;
            boolean hasRow = false;
            int rowClockCount = 0;
            long rowClockAddr = 0L;
            long rowClockUsed = 0L;
            long rowClockTotal = 0L;
            do {
                Object var23_19;
                Lock blockLock;
                long blockId = 0L;
                if (block != null) {
                    block.free();
                    block = null;
                }
                Object object = this._rowClockLock;
                synchronized (object) {
                    blockId = this.firstRow(this._rowClockAddr);
                    if (blockId < 0L) {
                        if (!isLoop && (1024L < this._rowClockTotal && 4L * this._rowClockUsed < 3L * this._rowClockTotal || this._rowAllocCount > 8)) {
                            isLoop = true;
                            this._rowClockCount = 0;
                            this._rowClockAddr = 0L;
                            this._rowClockUsed = 0L;
                            this._rowClockTotal = 0L;
                            this._rowAllocCount = 0;
                            continue;
                        }
                        ++this._rowAllocCount;
                        block = xa.allocateRow(this);
                        blockId = block.getBlockId();
                    }
                    rowClockCount = this._rowClockCount++;
                    rowClockAddr = Table.blockIdToAddress(blockId);
                    rowClockUsed = this._rowClockUsed;
                    rowClockTotal = this._rowClockTotal;
                    this._rowClockAddr = rowClockAddr + 65536L;
                    this._rowClockUsed = rowClockUsed + (long)this._rowsPerBlock;
                    this._rowClockTotal = rowClockTotal + (long)this._rowsPerBlock;
                }
                if (block == null) {
                    block = xa.readBlock(this, blockId);
                }
                if (!xa.lockReadAndWriteNoWait(blockLock = block.getLock())) continue;
                try {
                    byte[] buffer = block.getBuffer();
                    for (rowOffset = 0; rowOffset < this._rowEnd; rowOffset += this._rowLength) {
                        if (buffer[rowOffset] != 0) continue;
                        block.setDirty(rowOffset, rowOffset + 1);
                        hasRow = true;
                        buffer[rowOffset] = 2;
                        break;
                    }
                    var23_19 = null;
                }
                catch (Throwable throwable) {
                    var23_19 = null;
                    xa.unlockReadAndWrite(blockLock);
                    throw throwable;
                }
                xa.unlockReadAndWrite(blockLock);
                {
                }
            } while (!hasRow);
            this.insertRow(queryContext, xa, columns, values, block, rowOffset);
            Object object = this._rowClockLock;
            synchronized (object) {
                if (rowClockCount < this._rowClockCount) {
                    int blocks = this._rowClockCount - rowClockCount;
                    this._rowClockCount = rowClockCount;
                    this._rowClockAddr = rowClockAddr;
                    this._rowClockUsed -= (long)(blocks * this._rowsPerBlock);
                    this._rowClockTotal -= (long)(blocks * this._rowsPerBlock);
                }
            }
            long l = Table.blockIdToAddress(block.getBlockId(), rowOffset);
            Object var26_23 = null;
            if (block != null) {
                block.free();
            }
            return l;
        }
        catch (Throwable throwable) {
            block19: {
                Object var26_24 = null;
                if (block == null) break block19;
                block.free();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insertRow(QueryContext queryContext, Transaction xa, ArrayList<Column> columns, ArrayList<Expr> values, Block block, int rowOffset) throws SQLException {
        byte[] buffer = block.getBuffer();
        long rowAddr = Table.blockIdToAddress(block.getBlockId(), rowOffset);
        TableIterator iter = this.createTableIterator();
        TableIterator[] iterSet = new TableIterator[]{iter};
        queryContext.init(xa, iterSet, true);
        iter.init(queryContext);
        boolean isOkay = false;
        queryContext.lock();
        try {
            block11: {
                Expr value;
                Column column;
                int i;
                iter.setRow(block, rowOffset);
                block.setDirty(rowOffset, rowOffset + this._rowLength);
                for (i = rowOffset + this._rowLength - 1; rowOffset < i; --i) {
                    buffer[i] = 0;
                }
                for (i = 0; i < columns.size(); ++i) {
                    column = columns.get(i);
                    value = values.get(i);
                    column.setExpr(xa, buffer, rowOffset, value, queryContext);
                }
                try {
                    this.validate(block, rowOffset, queryContext, xa);
                    buffer[rowOffset] = (byte)(buffer[rowOffset] & 0xFFFFFFFC | 1);
                    for (i = 0; i < columns.size(); ++i) {
                        column = columns.get(i);
                        value = values.get(i);
                        column.setIndex(xa, buffer, rowOffset, rowAddr, queryContext);
                    }
                    xa.addUpdateBlock(block);
                    if (this._autoIncrementColumn != null) {
                        long value2 = this._autoIncrementColumn.getLong(buffer, rowOffset);
                        Table table = this;
                        synchronized (table) {
                            if (this._autoIncrementValue < value2) {
                                this._autoIncrementValue = value2;
                            }
                        }
                    }
                    ++this._entries;
                    isOkay = true;
                    Object var18_16 = null;
                    if (isOkay) break block11;
                }
                catch (Throwable throwable) {
                    Object var18_17 = null;
                    if (isOkay) throw throwable;
                    this.delete(xa, block, buffer, rowOffset);
                    throw throwable;
                }
                this.delete(xa, block, buffer, rowOffset);
            }
            Object var20_19 = null;
        }
        catch (Throwable throwable) {
            Object var20_20 = null;
            queryContext.unlock();
            throw throwable;
        }
        queryContext.unlock();
    }

    private void validate(Block block, int rowOffset, QueryContext queryContext, Transaction xa) throws SQLException {
        TableIterator row = this.createTableIterator();
        TableIterator[] rows = new TableIterator[]{row};
        row.setRow(block, rowOffset);
        for (int i = 0; i < this._constraints.length; ++i) {
            this._constraints[i].validate(rows, queryContext, xa);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(Transaction xa, Block block, byte[] buffer, int rowOffset) throws SQLException {
        byte rowState = buffer[rowOffset];
        if ((rowState & 3) != 1) {
            return;
        }
        buffer[rowOffset] = (byte)(rowState & 0xFFFFFFFC | 2);
        Column[] columns = this._row.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            columns[i].delete(xa, buffer, rowOffset);
        }
        buffer[rowOffset] = 0;
        Object object = this._rowClockLock;
        synchronized (object) {
            long addr = Table.blockIdToAddress(block.getBlockId());
            if (addr <= this._rowClockAddr) {
                --this._rowClockUsed;
            }
        }
    }

    private void writeLong(WriteStream os, long value) throws IOException {
        os.write((int)(value >> 56));
        os.write((int)(value >> 48));
        os.write((int)(value >> 40));
        os.write((int)(value >> 32));
        os.write((int)(value >> 24));
        os.write((int)(value >> 16));
        os.write((int)(value >> 8));
        os.write((int)value);
    }

    private void setLong(byte[] buffer, int offset, long value) throws IOException {
        buffer[offset + 0] = (byte)(value >> 56);
        buffer[offset + 1] = (byte)(value >> 48);
        buffer[offset + 2] = (byte)(value >> 40);
        buffer[offset + 3] = (byte)(value >> 32);
        buffer[offset + 4] = (byte)(value >> 24);
        buffer[offset + 5] = (byte)(value >> 16);
        buffer[offset + 6] = (byte)(value >> 8);
        buffer[offset + 7] = (byte)value;
    }

    private long getLong(byte[] buffer, int offset) throws IOException {
        long value = (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
        return value;
    }

    @Override
    public String toString() {
        return "Table[" + this.getName() + ":" + this.getId() + "]";
    }
}

