/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.store.Block;
import com.caucho.db.store.Transaction;
import com.caucho.db.table.Column;
import com.caucho.db.table.Table;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.SQLException;

public class TableIterator {
    private static final L10N L = new L10N(TableIterator.class);
    private static final byte[] _nullBuffer = new byte[256];
    private Table _table;
    private Column[] _columns;
    private Transaction _xa;
    private QueryContext _queryContext;
    private long _blockId;
    private int _rowLength;
    private int _rowEnd;
    private int _rowOffset;
    private Block _block;
    private byte[] _buffer;

    public TableIterator() {
    }

    TableIterator(Table table) {
        this.init(table);
    }

    public void init(Table table) {
        this._table = table;
        if (table.getId() == 0) {
            throw new IllegalStateException(L.l("iterating with closed table."));
        }
        this._columns = table.getColumns();
        this._rowLength = table.getRowLength();
        this._rowOffset = this._rowEnd = table.getRowEnd();
        this._blockId = 0L;
    }

    public Table getTable() {
        return this._table;
    }

    public final long getBlockId() {
        return this._blockId;
    }

    public final void setBlockId(long blockId) {
        this._blockId = blockId;
    }

    public final long getRowAddress() {
        return Table.blockIdToAddress(this._blockId) + (long)this._rowOffset;
    }

    public final int getRowOffset() {
        return this._rowOffset;
    }

    public final void setRowOffset(int rowOffset) {
        this._rowOffset = rowOffset;
    }

    public final byte[] getBuffer() {
        return this._buffer;
    }

    public Transaction getTransaction() {
        return this._xa;
    }

    public QueryContext getQueryContext() {
        return this._queryContext;
    }

    public void init(QueryContext queryContext) throws SQLException {
        this.init(queryContext.getTransaction());
        this._queryContext = queryContext;
    }

    public void init(Transaction xa) throws SQLException {
        Block block = this._block;
        this._block = null;
        this._buffer = null;
        if (block != null) {
            block.free();
        }
        this._blockId = 0L;
        this._rowOffset = 0x3FFFFFFF;
        this._queryContext = null;
        this._xa = xa;
    }

    public void initRow() throws IOException {
        this._rowOffset = -this._rowLength;
    }

    public void prevRow() {
        this._rowOffset -= this._rowLength;
    }

    void setRow(Block block, int rowOffset) {
        this._block = block;
        this._buffer = block.getBuffer();
        this._blockId = block.getBlockId();
        this._rowOffset = rowOffset;
    }

    public Block getBlock() {
        return this._block;
    }

    public boolean nextRow() throws IOException {
        int rowOffset = this._rowOffset;
        int rowLength = this._rowLength;
        int rowEnd = this._rowEnd;
        byte[] buffer = this._buffer;
        rowOffset += rowLength;
        while (rowOffset < rowEnd) {
            if ((buffer[rowOffset] & 1) != 0) {
                this._rowOffset = rowOffset;
                return true;
            }
            rowOffset += rowLength;
        }
        this._rowOffset = rowOffset;
        return false;
    }

    public boolean next() throws IOException {
        do {
            if (!this.nextRow()) continue;
            return true;
        } while (this.nextBlock());
        return false;
    }

    public boolean nextBlock() throws IOException {
        byte[] buffer = this._buffer;
        Block block = this._block;
        this._block = null;
        this._buffer = null;
        if (block != null) {
            block.free();
        }
        this._blockId = this._table.firstRow(this._blockId + 65536L);
        if (this._blockId < 0L) {
            return false;
        }
        block = this._xa.readBlock(this._table, this._blockId);
        buffer = block.getBuffer();
        this._block = block;
        this._buffer = buffer;
        this._rowOffset = 0;
        return true;
    }

    public void setRow(long rowAddr) throws IOException {
        long blockId = this._table.addressToBlockId(rowAddr);
        if (blockId != this._blockId) {
            this._blockId = blockId;
            Block block = this._block;
            this._block = null;
            this._buffer = null;
            if (block != null) {
                block.free();
            }
            this._block = this._xa.readBlock(this._table, this._blockId);
            this._buffer = this._block.getBuffer();
        }
        this._rowOffset = (int)(rowAddr & 0xFFFFL);
    }

    public void initNullRow() throws IOException {
        Block block = this._block;
        this._block = null;
        this._buffer = null;
        if (block != null) {
            block.free();
        }
        this._rowOffset = 0;
        this._buffer = _nullBuffer;
    }

    public boolean isNullRow() {
        return this._buffer == _nullBuffer;
    }

    public boolean isNull(Column column) throws SQLException {
        return column.isNull(this._buffer, this._rowOffset);
    }

    public String getString(Column column) throws SQLException {
        return column.getString(this._buffer, this._rowOffset);
    }

    public int getInteger(Column column) throws SQLException {
        return column.getInteger(this._buffer, this._rowOffset);
    }

    public long getLong(Column column) throws SQLException {
        return column.getLong(this._buffer, this._rowOffset);
    }

    public double getDouble(Column column) throws SQLException {
        return column.getDouble(this._buffer, this._rowOffset);
    }

    public boolean isEqual(Column column, byte[] matchBuffer) throws SQLException {
        return column.isEqual(this._buffer, this._rowOffset, matchBuffer, 0, matchBuffer.length);
    }

    public boolean isEqual(Column column, byte[] matchBuffer, int matchLength) throws SQLException {
        return column.isEqual(this._buffer, this._rowOffset, matchBuffer, 0, matchLength);
    }

    public boolean isEqual(Column column, String string) throws SQLException {
        return column.isEqual(this._buffer, this._rowOffset, string);
    }

    public void evalToResult(Column column, SelectResult result) throws SQLException {
        column.evalToResult(this._buffer, this._rowOffset, result);
    }

    public void delete() throws SQLException {
        this.setDirty();
        this._table.delete(this._xa, this._block, this._buffer, this._rowOffset);
    }

    public void setDirty() throws SQLException {
        this._xa.addUpdateBlock(this._block);
        this._block.setDirty(this.getRowOffset(), this.getRowOffset() + this._rowLength);
    }

    public void free() {
        Block block = this._block;
        this._block = null;
        if (block != null) {
            block.free();
        }
    }
}

