/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb;

import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.xa.TransactionContext;
import com.caucho.security.SecurityContext;
import com.caucho.security.SecurityContextException;
import com.caucho.util.L10N;
import java.rmi.RemoteException;
import java.security.Identity;
import java.security.Principal;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBContext;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.RemoveException;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.transaction.UserTransaction;

public abstract class AbstractContext
implements EJBContext {
    private static final L10N L = new L10N(AbstractContext.class);
    private static final Logger log = Logger.getLogger(AbstractContext.class.getName());
    private boolean _isDead;
    private Class _invokedBusinessInterface;

    public boolean isDead() {
        return this._isDead;
    }

    public abstract AbstractServer getServer();

    public EJBMetaData getEJBMetaData() {
        return this.getServer().getEJBMetaData();
    }

    public EJBHome getEJBHome() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public EJBLocalHome getEJBLocalHome() {
        try {
            EJBLocalHome localHome = this.getServer().getEJBLocalHome();
            if (localHome == null && this.getServer().getEJBHome() == null) {
                throw new IllegalStateException("getEJBLocalHome() is only allowed through EJB 2.1 interfaces");
            }
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Handle getHandle() {
        throw new UnsupportedOperationException();
    }

    public HomeHandle getHomeHandle() {
        return this.getServer().getHomeHandle();
    }

    public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
        throw new IllegalStateException(L.l("`{0}' has no local interface.  Local beans need a local-home and a local interface.  Remote beans must be called with a remote context.", (Object)this.getServer()));
    }

    public Object lookup(String name) {
        return this.getServer().lookup(name);
    }

    public EJBObject getEJBObject() {
        EJBObject obj = this.getRemoteView();
        if (obj == null) {
            throw new IllegalStateException("getEJBObject() is only allowed through EJB 2.1 interfaces");
        }
        return obj;
    }

    public EJBObject getRemoteView() {
        return null;
    }

    public EJBHome createRemoteHomeView() {
        return null;
    }

    public EJBLocalHome createLocalHome() {
        return null;
    }

    public Object createRemoteView21() {
        return null;
    }

    public Object createRemoteView() {
        return null;
    }

    public Properties getEnvironment() {
        return new Properties();
    }

    public Identity getCallerIdentity() {
        return null;
    }

    public Principal getCallerPrincipal() {
        try {
            return SecurityContext.getUserPrincipal();
        }
        catch (SecurityContextException e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public boolean isCallerInRole(Identity role) {
        return false;
    }

    public boolean isCallerInRole(String roleName) {
        return SecurityContext.isUserInRole(roleName);
    }

    public void remove() throws RemoveException {
        EJBObject obj = null;
        try {
            obj = this.getEJBObject();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (obj != null) {
                obj.remove();
                return;
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        EJBLocalObject local = null;
        try {
            local = this.getEJBLocalObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (local != null) {
            local.remove();
            return;
        }
    }

    public UserTransaction getUserTransaction() throws IllegalStateException {
        if (this.getServer().isContainerTransaction()) {
            throw new IllegalStateException("getUserTransaction() is not allowed with container-managed transaction");
        }
        return this.getServer().getUserTransaction();
    }

    public TimerService getTimerService() throws IllegalStateException {
        return this.getServer().getTimerService();
    }

    public void setRollbackOnly() throws IllegalStateException {
        if (!this.getServer().isContainerTransaction()) {
            throw new IllegalStateException("setRollbackOnly() is only allowed with container-managed transaction");
        }
        try {
            this.getServer().getUserTransaction().setRollbackOnly();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        if (!this.getServer().isContainerTransaction()) {
            throw new IllegalStateException("getRollbackOnly() is only allowed with container-managed transaction");
        }
        TransactionContext trans = this.getServer().getTransaction();
        if (trans != null) {
            return trans.getRollbackOnly();
        }
        throw new IllegalStateException("invalid transaction");
    }

    public void destroy() throws Exception {
        this._isDead = true;
    }

    public Class getInvokedBusinessInterface() throws IllegalStateException {
        if (this._invokedBusinessInterface == null) {
            throw new IllegalStateException("SessionContext.getInvokedBusinessInterface() is only allowed through EJB 3.0 interfaces");
        }
        return this._invokedBusinessInterface;
    }

    public void __caucho_setInvokedBusinessInterface(Class invokedBusinessInterface) {
        this._invokedBusinessInterface = invokedBusinessInterface;
    }

    public void __caucho_timeout_callback(Timer timer) {
        throw new IllegalStateException(L.l("'{0}' does not have a @Timeout callback", (Object)this.getClass().getName()));
    }
}

