/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb;

import com.caucho.config.ConfigContext;
import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.config.j2ee.InjectIntrospector;
import com.caucho.config.program.ConfigProgram;
import com.caucho.ejb.AbstractContext;
import com.caucho.ejb.EJBExceptionWrapper;
import com.caucho.ejb.EJBMetaDataImpl;
import com.caucho.ejb.cfg.AroundInvokeConfig;
import com.caucho.ejb.cfg.PostConstructConfig;
import com.caucho.ejb.cfg.PreDestroyConfig;
import com.caucho.ejb.manager.EjbContainer;
import com.caucho.ejb.protocol.AbstractHandle;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.ejb.protocol.HandleEncoder;
import com.caucho.ejb.session.AbstractSessionContext;
import com.caucho.ejb.session.SessionServer;
import com.caucho.ejb.session.StatelessServer;
import com.caucho.ejb.timer.EjbTimerService;
import com.caucho.ejb.xa.EjbTransactionManager;
import com.caucho.ejb.xa.TransactionContext;
import com.caucho.jca.UserTransactionProxy;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.webbeans.component.ComponentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.FinderException;
import javax.ejb.HomeHandle;
import javax.ejb.TimerService;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServer
implements EnvironmentBean {
    private static final Logger log = Log.open(AbstractServer.class);
    private static final L10N L = new L10N(AbstractServer.class);
    protected final EjbContainer _ejbContainer;
    protected final UserTransaction _ut = UserTransactionProxy.getInstance();
    protected String _filename;
    protected int _line;
    protected String _location;
    protected String _id;
    protected String _ejbName;
    protected String _moduleName;
    protected String _handleServerId;
    protected String _mappedName;
    private Context _jndiEnv;
    private ConfigProgram _serverProgram;
    protected HashMap<String, HandleEncoder> _protocolEncoderMap;
    protected HandleEncoder _handleEncoder;
    protected DataSource _dataSource;
    protected EnvironmentClassLoader _loader;
    protected Class _ejbClass;
    protected Class _contextImplClass;
    protected Class _local21;
    protected Class _remote21;
    protected Class _remoteHomeClass;
    protected Class _remoteObjectClass;
    protected ArrayList<Class> _remoteApiList = new ArrayList();
    protected Class _primaryKeyClass;
    protected Class _localHomeClass;
    protected ArrayList<Class> _localApiList = new ArrayList();
    protected Class _remoteStubClass;
    protected Class _homeStubClass;
    protected HomeHandle _homeHandle;
    protected EJBHome _remoteHome;
    protected EJBHome _remoteHomeView;
    protected EJBLocalHome _localHome;
    protected EJBMetaDataImpl _metaData;
    protected Class _serviceEndpointClass;
    protected long _transactionTimeout;
    protected ComponentImpl _component;
    private TimerService _timerService;
    protected ConfigProgram _initProgram;
    protected ConfigProgram[] _initInject;
    protected ConfigProgram[] _destroyInject;
    private AroundInvokeConfig _aroundInvokeConfig;
    private PreDestroyConfig _preDestroyConfig;
    private PostConstructConfig _postConstructConfig;
    private boolean _isContainerTransaction = true;
    private final Lifecycle _lifecycle = new Lifecycle();

    public AbstractServer(EjbContainer container) {
        this._ejbContainer = container;
        this._loader = new EnvironmentClassLoader(container.getClassLoader());
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
        int p = id.lastIndexOf(47);
        if (p > 0) {
            this._loader.setId(this.getType() + id.substring(p + 1));
        } else {
            this._loader.setId(this.getType() + id);
        }
    }

    public void setConfigLocation(String filename, int line) {
        this._filename = filename;
        this._line = line;
    }

    public void setLocation(String location) {
        this._location = location;
    }

    protected String getType() {
        return "ejb:";
    }

    public void setAroundInvoke(AroundInvokeConfig aroundInvoke) {
        this._aroundInvokeConfig = aroundInvoke;
    }

    public void setEJBName(String ejbName) {
        this._ejbName = ejbName;
    }

    public String getEJBName() {
        return this._ejbName;
    }

    public void setModuleName(String moduleName) {
        this._moduleName = moduleName;
    }

    public String getModuleName() {
        return this._moduleName;
    }

    public void setMappedName(String mappedName) {
        if (mappedName == null) {
            this._mappedName = null;
            return;
        }
        while (mappedName.startsWith("/")) {
            mappedName = mappedName.substring(1);
        }
        while (mappedName.endsWith("/")) {
            mappedName = mappedName.substring(0, mappedName.length() - 1);
        }
        this._mappedName = mappedName;
    }

    public String getMappedName() {
        return this._mappedName == null ? this.getEJBName() : this._mappedName;
    }

    public String getProtocolId() {
        return "/" + this.getMappedName();
    }

    public String getProtocolId(Class cl) {
        if (cl == null) {
            return this.getProtocolId();
        }
        if (cl.getName().startsWith("java.")) {
            return this.getProtocolId();
        }
        String url = this.getProtocolId() + "#" + cl.getName().replace(".", "_");
        return url;
    }

    public void setEjbClass(Class cl) {
        this._ejbClass = cl;
    }

    protected Class getEjbClass() {
        return this._ejbClass;
    }

    public void setContextImplClass(Class cl) {
        this._contextImplClass = cl;
    }

    public void setRemoteHomeClass(Class cl) {
        this._remoteHomeClass = cl;
    }

    public Class getRemoteHomeClass() {
        return this._remoteHomeClass;
    }

    public Class getRemote21() {
        return this._remote21;
    }

    public void setRemoteApiList(ArrayList<Class> list) {
        this._remoteApiList = new ArrayList<Class>(list);
        if (this._remoteApiList.size() > 0) {
            this._remoteObjectClass = this._remoteApiList.get(0);
        }
    }

    public ArrayList<Class> getRemoteApiList() {
        return this._remoteApiList;
    }

    public boolean hasRemoteObject() {
        if (this._remoteApiList == null) {
            return false;
        }
        return this._remoteApiList.size() != 0;
    }

    public void setRemoteObjectClass(Class cl) {
        this._remoteObjectClass = cl;
        if (this._remoteApiList == null) {
            this._remoteApiList = new ArrayList();
            this._remoteApiList.add(cl);
        }
    }

    public Class getRemoteObjectClass() {
        return this._remoteObjectClass;
    }

    public void setLocalHomeClass(Class cl) {
        this._localHomeClass = cl;
    }

    public Class getLocalHomeClass() {
        return this._localHomeClass;
    }

    public void setServiceEndpoint(Class cl) {
        this._serviceEndpointClass = cl;
    }

    public Class getServiceEndpoint() {
        return this._serviceEndpointClass;
    }

    public void setLocalApiList(ArrayList<Class> list) {
        this._localApiList = new ArrayList<Class>(list);
    }

    public ArrayList<Class> getLocalApiList() {
        return this._localApiList;
    }

    public HandleEncoder getHandleEncoder(String protocol) {
        HandleEncoder encoder;
        if (this._protocolEncoderMap != null && (encoder = this._protocolEncoderMap.get(protocol)) != null) {
            return encoder;
        }
        try {
            Class keyClass = this.getPrimaryKeyClass();
            encoder = this._ejbContainer.getProtocolManager().createHandleEncoder(this, keyClass, protocol);
        }
        catch (Exception e) {
            throw EJBExceptionWrapper.createRuntime(e);
        }
        if (this._protocolEncoderMap == null) {
            this._protocolEncoderMap = new HashMap(8);
        }
        this._protocolEncoderMap.put(protocol, encoder);
        return encoder;
    }

    public String encodeId(Object primaryKey) {
        return String.valueOf(primaryKey);
    }

    public HandleEncoder addHandleEncoder(String protocol, String serverId) {
        HandleEncoder encoder;
        if (this._protocolEncoderMap != null && (encoder = this._protocolEncoderMap.get(protocol)) != null) {
            return encoder;
        }
        try {
            Class keyClass = this.getPrimaryKeyClass();
            encoder = new HandleEncoder(this, serverId + this._ejbName);
        }
        catch (Exception e) {
            throw EJBExceptionWrapper.createRuntime(e);
        }
        if (this._protocolEncoderMap == null) {
            this._protocolEncoderMap = new HashMap(8);
        }
        this._protocolEncoderMap.put(protocol, encoder);
        return encoder;
    }

    public HandleEncoder getHandleEncoder() {
        return this.getHandleEncoder(EjbProtocolManager.getThreadProtocol());
    }

    public void setHandleEncoder(HandleEncoder encoder) {
        if (this._homeHandle != null) {
            this._homeHandle = null;
        }
        this._handleEncoder = encoder;
    }

    public String getHandleServerId() {
        if (this._handleServerId == null) {
            this._handleServerId = this.getHandleEncoder().getServerId();
        }
        return this._handleServerId;
    }

    public Object lookup(String jndiName) {
        try {
            if (this._jndiEnv == null) {
                this._jndiEnv = (Context)new InitialContext().lookup("java:comp/env");
            }
            return this._jndiEnv.lookup(jndiName);
        }
        catch (NamingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public UserTransaction getUserTransaction() {
        return this._ut;
    }

    public EjbContainer getEjbContainer() {
        return this._ejbContainer;
    }

    public void setServerProgram(ConfigProgram serverProgram) {
        this._serverProgram = serverProgram;
    }

    public ConfigProgram getServerProgram() {
        return this._serverProgram;
    }

    public void setTransactionTimeout(long timeout) {
        this._transactionTimeout = timeout;
    }

    public long getTransactionTimeout() {
        return this._transactionTimeout;
    }

    public TimerService getTimerService() {
        if (this._timerService == null) {
            this._timerService = EjbTimerService.getLocal(this._ejbContainer.getClassLoader(), this.getContext());
        }
        return this._timerService;
    }

    public void invalidateCache() {
    }

    public Object remove(AbstractHandle handle) {
        throw new UnsupportedOperationException();
    }

    public void remove(Object primaryKey) {
    }

    @Override
    public DynamicClassLoader getClassLoader() {
        return this._loader;
    }

    public Class getBeanSkelClass() {
        return this._contextImplClass;
    }

    public Class getRemoteStubClass() {
        return this._remoteStubClass;
    }

    public Class getHomeStubClass() {
        return this._homeStubClass;
    }

    public EJBMetaData getEJBMetaData() {
        if (this._metaData == null) {
            try {
                EJBHome home = this.getEJBHome();
                this._metaData = new EJBMetaDataImpl(home, this.getRemoteHomeClass(), this.getRemoteObjectClass(), this.getPrimaryKeyClass());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EJBException(e);
            }
            if (this instanceof StatelessServer) {
                this._metaData.setSession(true);
                this._metaData.setStatelessSession(true);
            } else if (this instanceof SessionServer) {
                this._metaData.setSession(true);
            }
        }
        return this._metaData;
    }

    public HomeHandle getHomeHandle() {
        if (this._homeHandle == null) {
            this._homeHandle = this.getHandleEncoder().createHomeHandle();
        }
        return this._homeHandle;
    }

    void setEJBHome(EJBHome remoteHome) {
        this._remoteHome = remoteHome;
    }

    public EJBHome getEJBHome() {
        if (this._remoteHome != null) {
            return this._remoteHome;
        }
        EJBHome home = (EJBHome)this.getRemoteObject(this.getRemoteHomeClass(), null);
        return home;
    }

    EJBHome getClientHome() {
        return this.getEJBHome();
    }

    public AbstractSessionContext getSessionContext() {
        return null;
    }

    public EJBLocalHome getEJBLocalHome() {
        return this._localHome;
    }

    public abstract Object getRemoteObject(Class var1, String var2);

    public abstract Object getLocalObject(Class var1);

    public abstract Object getLocalProxy(Class var1);

    public Class getPrimaryKeyClass() {
        return this._primaryKeyClass;
    }

    public EJBObject getEJBObject(Object key) throws FinderException {
        return this.getContext(key).getEJBObject();
    }

    public Object getRemoteObject(Object key) throws FinderException {
        return this.getContext(key).createRemoteView();
    }

    public AbstractContext getContext() {
        return null;
    }

    public AbstractContext getContext(Object key) throws FinderException {
        return this.getContext(key, true);
    }

    public AbstractContext getContext(long key) throws FinderException {
        return this.getContext(new Long(key));
    }

    public abstract AbstractContext getContext(Object var1, boolean var2) throws FinderException;

    public EjbTransactionManager getTransactionManager() {
        return this._ejbContainer.getTransactionManager();
    }

    public TransactionContext getTransaction() {
        return this._ejbContainer.getTransactionManager().getTransactionContext();
    }

    public void setInitProgram(ConfigProgram init) {
        this._initProgram = init;
    }

    public ConfigProgram getInitProgram() {
        return this._initProgram;
    }

    public void initInstance(Object instance) {
        this.initInstance(instance, new ConfigContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initInstance(Object instance, ConfigContext env) {
        if (this._initInject != null) {
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(this._loader);
                if (env == null) {
                    env = new ConfigContext();
                }
                for (ConfigProgram inject : this._initInject) {
                    inject.inject(instance, env);
                }
                Object var10_9 = null;
                thread.setContextClassLoader(oldLoader);
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyInstance(Object instance) {
        if (this._destroyInject != null) {
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(this._loader);
                ConfigContext env = null;
                if (env == null) {
                    env = new ConfigContext();
                }
                for (ConfigProgram inject : this._destroyInject) {
                    inject.inject(instance, env);
                }
                Object var10_9 = null;
                thread.setContextClassLoader(oldLoader);
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
        }
    }

    public void init() throws Exception {
        this._loader.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() throws Exception {
        if (!this._lifecycle.toActive()) {
            return false;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._loader);
            this._loader.start();
            this.bindContext();
            if (this._serverProgram != null) {
                this._serverProgram.configure(this);
            }
            this.bindInjection();
            log.config(this + " active");
            Object var4_3 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
        return true;
    }

    protected void bindContext() {
    }

    protected void bindInjection() {
        ArrayList<ConfigProgram> injectList = new ArrayList<ConfigProgram>();
        InjectIntrospector.introspectInject(injectList, this.getEjbClass());
        if (this._initProgram != null) {
            injectList.add(this._initProgram);
        }
        InjectIntrospector.introspectInit(injectList, this.getEjbClass());
        ConfigProgram[] injectArray = new ConfigProgram[injectList.size()];
        injectList.toArray(injectArray);
        if (injectArray.length > 0) {
            this._initInject = injectArray;
        }
        injectList = new ArrayList();
        this.introspectDestroy(injectList, this.getEjbClass());
        injectArray = new ConfigProgram[injectList.size()];
        injectList.toArray(injectArray);
        if (injectArray.length > 0) {
            this._destroyInject = injectArray;
        }
    }

    protected void introspectDestroy(ArrayList<ConfigProgram> injectList, Class ejbClass) {
        InjectIntrospector.introspectDestroy(injectList, this.getEjbClass());
    }

    public boolean isContainerTransaction() {
        return this._isContainerTransaction;
    }

    public void setContainerTransaction(boolean isContainerTransaction) {
        this._isContainerTransaction = isContainerTransaction;
    }

    public boolean isLocal() {
        return this._localHome != null || this._localApiList != null && this._localApiList.size() > 0;
    }

    public boolean isRemote() {
        return this._remoteHome != null || this._remoteHomeView != null;
    }

    public boolean isDead() {
        return !this._lifecycle.isActive();
    }

    public void destroy() {
        this._lifecycle.toDestroy();
    }

    public PostConstructConfig getPostConstruct() {
        return this._postConstructConfig;
    }

    public PreDestroyConfig getPreDestroy() {
        return this._preDestroyConfig;
    }

    public void setPostConstruct(PostConstructConfig postConstruct) {
        this._postConstructConfig = postConstruct;
    }

    public void setPreDestroy(PreDestroyConfig preDestroy) {
        this._preDestroyConfig = preDestroy;
    }

    public void addClientRemoteConfig(StringBuilder sb) {
        if (this._remoteApiList != null && this._remoteApiList.size() > 0) {
            sb.append("<ejb-ref>\n");
            sb.append("<ejb-ref-name>" + this.getEJBName() + "</ejb-ref-name>\n");
            if (this._remoteHomeClass != null) {
                sb.append("<home>" + this._remoteHomeClass.getName() + "</home>\n");
            }
            sb.append("<remote>" + this._remoteApiList.get(0).getName() + "</remote>\n");
            sb.append("</ejb-ref>\n");
        }
    }

    public ConfigException error(String msg) {
        if (this._filename != null) {
            throw new LineConfigException(this._filename, this._line, msg);
        }
        throw new ConfigException(msg);
    }

    public String toString() {
        if (this.getMappedName() != null) {
            return this.getClass().getSimpleName() + "[" + this.getEJBName() + "," + this.getMappedName() + "]";
        }
        return this.getClass().getSimpleName() + "[" + this.getEJBName() + "]";
    }
}

