/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb;

import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.SimpleLoader;
import com.caucho.util.ExceptionWrapper;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.ArrayList;
import java.util.logging.Logger;

public class EJBCompiler {
    static L10N L = new L10N(EJBCompiler.class);
    protected static Logger log = Logger.getLogger(EJBCompiler.class.getName());
    private Path _classDir;
    private Path _appDir;
    private ArrayList<String> _ejbPath = new ArrayList();

    public EJBCompiler(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-app-dir")) {
                this._appDir = Vfs.lookup(args[i + 1]);
                if (this._classDir == null) {
                    this._classDir = this._appDir.lookup("WEB-INF/work");
                }
                i += 2;
                continue;
            }
            if (!args[i].equals("-class-dir")) break;
            this._classDir = Vfs.lookup(args[i + 1]);
            i += 2;
        }
        if (i == args.length) {
            EJBCompiler.printUsage();
            throw new Exception("bad args");
        }
        while (i < args.length) {
            this._ejbPath.add(args[i]);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile() throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        EnvironmentClassLoader loader = new EnvironmentClassLoader(oldLoader);
        if (this._appDir != null) {
            loader.addLoader(new SimpleLoader(this._appDir.lookup("WEB-INF/classes"), null));
        }
        Thread.currentThread().setContextClassLoader(loader);
        try {
            Object var4_3 = null;
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Thread.currentThread().setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public static void main(String[] args) throws Throwable {
        if (args.length == 0) {
            EJBCompiler.printUsage();
            System.exit(1);
        }
        EnvironmentClassLoader.initializeEnvironment();
        try {
            new EJBCompiler(args).compile();
        }
        catch (Throwable e) {
            while (e instanceof ExceptionWrapper && ((ExceptionWrapper)e).getRootCause() != null) {
                e = ((ExceptionWrapper)e).getRootCause();
            }
            throw e;
        }
    }

    private static void printUsage() {
        System.out.println("usage: com.caucho.ejb.EJBCompiler [flags] foo.ejb");
        System.out.println(" -class-dir: The directory where the classes will be generated.");
        System.out.println(" -app-dir: The source (web-app) directory.");
    }
}

