/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.burlap;

import com.caucho.burlap.client.BurlapProxyFactory;
import com.caucho.burlap.io.BurlapRemoteResolver;
import com.caucho.config.ConfigException;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.EJBExceptionWrapper;
import com.caucho.ejb.burlap.BurlapHandle;
import com.caucho.ejb.burlap.BurlapHandleEncoder;
import com.caucho.ejb.burlap.BurlapHomeHandle;
import com.caucho.ejb.burlap.MetaStub;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.ejb.protocol.HandleEncoder;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.util.Hashtable;
import javax.ejb.EJBHome;

class BurlapClientContainer
implements BurlapRemoteResolver {
    protected static L10N L = new L10N(BurlapClientContainer.class);
    private static EnvironmentLocal _burlapClient = new EnvironmentLocal("caucho.burlap.client");
    private String _serverId;
    private BurlapHandleEncoder _handleEncoder;
    private BurlapProxyFactory _proxyFactory;
    EJBHome _ejbHome;
    Class _homeClass;
    Class _remoteClass;
    Class _homeStubClass;
    Class _remoteStubClass;
    Class _primaryKeyClass;
    private String _basicAuth;

    BurlapClientContainer(String serverId) throws ConfigException {
        this._serverId = serverId;
        this._proxyFactory = new BurlapProxyFactory();
        this._proxyFactory.setOverloadEnabled(true);
    }

    static BurlapClientContainer find(String serverId) {
        try {
            Hashtable<String, BurlapClientContainer> map = (Hashtable<String, BurlapClientContainer>)_burlapClient.getLevel();
            BurlapClientContainer client = null;
            if (map != null) {
                client = (BurlapClientContainer)map.get(serverId);
            }
            if (client == null) {
                client = new BurlapClientContainer(serverId);
                if (map == null) {
                    map = new Hashtable<String, BurlapClientContainer>();
                }
                map.put(serverId, client);
                _burlapClient.set(map);
            }
            return client;
        }
        catch (Exception e) {
            throw EJBExceptionWrapper.createRuntime(e);
        }
    }

    protected EJBHome getHomeStub() throws ConfigException {
        try {
            return (EJBHome)this._proxyFactory.create(this.getHomeClass(), this._serverId);
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    protected Object createObjectStub(String url) throws ConfigException {
        try {
            return this._proxyFactory.create(this.getRemoteClass(), url);
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    BurlapHomeHandle getHomeHandle() {
        return new BurlapHomeHandle(this._ejbHome, this._serverId);
    }

    BurlapHandle createHandle(String url) {
        return new BurlapHandle(url);
    }

    public HandleEncoder getHandleEncoder() {
        try {
            if (this._handleEncoder == null) {
                this._handleEncoder = new BurlapHandleEncoder(null, this._serverId, this.getPrimaryKeyClass());
            }
            return this._handleEncoder;
        }
        catch (Exception e) {
            throw EJBExceptionWrapper.createRuntime(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class getHomeClass() throws ConfigException {
        if (this._homeClass != null) {
            return this._homeClass;
        }
        try {
            BurlapClientContainer burlapClientContainer = this;
            synchronized (burlapClientContainer) {
                if (this._homeClass != null) {
                    return this._homeClass;
                }
                String className = this.getHomeClassName();
                this._homeClass = CauchoSystem.loadClass(className, false, null);
            }
        }
        catch (ClassNotFoundException e) {
            throw ConfigException.create((Throwable)e);
        }
        return this._homeClass;
    }

    String getHomeClassName() throws ConfigException {
        AbstractServer server = EjbProtocolManager.getJVMServer(this._serverId);
        if (server != null) {
            Class cl = server.getRemoteHomeClass();
            if (cl != null) {
                return cl.getName();
            }
            throw new ConfigException(L.l("'{0}' has no remote interface.", (Object)this._serverId));
        }
        try {
            Path path = Vfs.lookup(this._serverId);
            return (String)MetaStub.call(path, "_burlap_getAttribute", "java.home.class");
        }
        catch (Throwable e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class getRemoteClass() throws ConfigException {
        if (this._remoteClass != null) {
            return this._remoteClass;
        }
        try {
            BurlapClientContainer burlapClientContainer = this;
            synchronized (burlapClientContainer) {
                if (this._remoteClass != null) {
                    return this._remoteClass;
                }
                String className = this.getRemoteClassName();
                if (className == null || className.equals("null")) {
                    return null;
                }
                this._remoteClass = CauchoSystem.loadClass(className, false, null);
            }
        }
        catch (ClassNotFoundException e) {
            throw ConfigException.create((Throwable)e);
        }
        return this._remoteClass;
    }

    String getRemoteClassName() throws ConfigException {
        AbstractServer server = EjbProtocolManager.getJVMServer(this._serverId);
        if (server != null) {
            Class cl = server.getRemoteObjectClass();
            if (cl != null) {
                return cl.getName();
            }
            throw new ConfigException(L.l("`{0}' has no remote interface.", (Object)this._serverId));
        }
        try {
            Path path = Vfs.lookup(this._serverId);
            return (String)MetaStub.call(path, "_burlap_getAttribute", "java.object.class");
        }
        catch (Throwable e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class getPrimaryKeyClass() throws ConfigException {
        if (this._primaryKeyClass != null) {
            return this._primaryKeyClass;
        }
        try {
            BurlapClientContainer burlapClientContainer = this;
            synchronized (burlapClientContainer) {
                if (this._primaryKeyClass != null) {
                    return this._primaryKeyClass;
                }
                String className = this.getPrimaryKeyClassName();
                this._primaryKeyClass = CauchoSystem.loadClass(className, false, null);
            }
        }
        catch (ClassNotFoundException e) {
            throw ConfigException.create((Throwable)e);
        }
        return this._primaryKeyClass;
    }

    String getPrimaryKeyClassName() throws ConfigException {
        AbstractServer server = EjbProtocolManager.getJVMServer(this._serverId);
        if (server != null) {
            Class cl = server.getPrimaryKeyClass();
            if (cl != null) {
                return cl.getName();
            }
            throw new ConfigException(L.l("`{0}' has no remote interface.", (Object)this._serverId));
        }
        try {
            Path path = Vfs.lookup(this._serverId);
            return (String)MetaStub.call(path, "_burlap_getAttribute", "primary-key-class");
        }
        catch (Throwable e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public Object lookup(String type, String url) throws IOException {
        try {
            Class api = CauchoSystem.loadClass(type);
            return this.create(api, url);
        }
        catch (Exception e) {
            throw new IOException(String.valueOf(e));
        }
    }

    public Object create(Class api, String url) throws Exception {
        return this._proxyFactory.create(api, url);
    }

    String getBasicAuthentication() {
        return this._basicAuth;
    }

    void setBasicAuthentication(String auth) {
        this._basicAuth = auth != null ? "Basic " + auth : auth;
    }

    public String toString() {
        return "BurlapClientContainer[" + this._serverId + "]";
    }
}

