/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.burlap;

import com.caucho.ejb.EJBExceptionWrapper;
import com.caucho.ejb.RemoteExceptionWrapper;
import com.caucho.ejb.burlap.BurlapClientContainer;
import com.caucho.ejb.protocol.AbstractHandle;
import com.caucho.ejb.protocol.HandleEncoder;
import java.rmi.RemoteException;
import javax.ejb.EJBObject;

public class BurlapHandle
extends AbstractHandle {
    private String url;
    private transient String serverId;
    private transient String objectId;
    private transient Object objectKey;
    private transient EJBObject object;

    public BurlapHandle() {
    }

    public BurlapHandle(String url) {
        this.url = url;
    }

    public BurlapHandle(String url, Object key) {
        this.url = url;
        this.objectKey = key;
    }

    public String getServerId() {
        if (this.serverId == null) {
            int p = this.url.lastIndexOf(63);
            this.serverId = this.url.substring(0, p);
        }
        return this.serverId;
    }

    public String getObjectId() {
        if (this.objectId == null) {
            int p = this.url.lastIndexOf(63);
            this.objectId = this.url.substring(p + 7);
        }
        return this.objectId;
    }

    void setEJBObject(EJBObject obj) {
        this.object = obj;
    }

    public EJBObject getEJBObject() throws RemoteException {
        if (this.object == null) {
            try {
                BurlapClientContainer client = BurlapClientContainer.find(this.getServerId());
                this.object = (EJBObject)client.createObjectStub(this.url);
            }
            catch (Exception e) {
                throw RemoteExceptionWrapper.create(e);
            }
        }
        return this.object;
    }

    public Object getObjectKey() {
        if (this.objectKey == null) {
            try {
                HandleEncoder encoder = BurlapClientContainer.find(this.getServerId()).getHandleEncoder();
                this.objectKey = encoder.objectIdToKey(this.getObjectId());
            }
            catch (Exception e) {
                throw new EJBExceptionWrapper(e);
            }
        }
        return this.objectKey;
    }

    public String getURL() {
        return this.url;
    }

    public String getURL(String protocol) {
        return this.url;
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BurlapHandle)) {
            return false;
        }
        BurlapHandle handle = (BurlapHandle)obj;
        return this.url.equals(handle.url);
    }

    public String toString() {
        return this.url;
    }
}

