/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.burlap;

import com.caucho.config.ConfigException;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.EJBExceptionWrapper;
import com.caucho.ejb.burlap.BurlapHandle;
import com.caucho.ejb.burlap.BurlapHomeHandle;
import com.caucho.ejb.protocol.AbstractHandle;
import com.caucho.ejb.protocol.AbstractHomeHandle;
import com.caucho.ejb.protocol.HandleEncoder;
import com.caucho.util.CharBuffer;
import java.lang.reflect.Field;
import javax.ejb.EJBException;

public class BurlapHandleEncoder
extends HandleEncoder {
    private static char[] serverEncode64;
    private static int[] serverHash64;
    private static char[] serverEncodeH2;
    private Class _primaryKeyClass;
    private Field[] _fields;
    private int[] fieldTypes;

    public BurlapHandleEncoder(String serverId, Class primaryKeyClass) throws ConfigException {
        super(serverId);
        this._primaryKeyClass = primaryKeyClass;
        if (this._primaryKeyClass == null || this._primaryKeyClass.isPrimitive() || this._primaryKeyClass.getName().startsWith("java.lang.")) {
            return;
        }
        this._fields = this._primaryKeyClass.getFields();
        this.fieldTypes = new int[this._fields.length];
    }

    public BurlapHandleEncoder(AbstractServer server, String serverId, Class primaryKeyClass) throws ConfigException {
        this(serverId, primaryKeyClass);
        this.setServer(server);
    }

    public AbstractHomeHandle createHomeHandle() {
        try {
            return new BurlapHomeHandle(this.getServer().getEJBHome(), this.getServerId());
        }
        catch (Throwable e) {
            return new BurlapHomeHandle(this.getServerId());
        }
    }

    public AbstractHandle createHandle(String objectId) {
        String url = this.getURL(objectId);
        try {
            return new BurlapHandle(url, this.getServer().getEJBObject(objectId));
        }
        catch (Throwable e) {
            return new BurlapHandle(url);
        }
    }

    public String createRandomStringKey() {
        String originalKey = super.createRandomStringKey();
        int srun = 0;
        int tail = this.calculateHash(originalKey) * 65521;
        CharBuffer cb = CharBuffer.allocate();
        cb.append(originalKey);
        int d1 = 64 + srun - tail & 0x3F;
        cb.append(serverEncode64[d1]);
        return cb.close();
    }

    private int calculateHash(String key) {
        int hash = 137;
        int len = key.length();
        for (int i = 0; i < len; ++i) {
            char ch = key.charAt(i);
            hash = 65521 * hash + serverHash64[ch & 0xFF];
        }
        return hash;
    }

    public Object objectIdToKey(Object objectKey) {
        String objectId = (String)objectKey;
        if (this._primaryKeyClass == null) {
            return objectId;
        }
        if (this._primaryKeyClass.equals(String.class)) {
            return objectId;
        }
        if (this._primaryKeyClass.equals(Integer.class) || this._primaryKeyClass.equals(Integer.TYPE)) {
            return new Integer(objectId);
        }
        if (this._primaryKeyClass.equals(Long.class) || this._primaryKeyClass.equals(Long.TYPE)) {
            return new Long(objectId);
        }
        if (this._primaryKeyClass.equals(Float.class) || this._primaryKeyClass.equals(Float.TYPE)) {
            return new Float(objectId);
        }
        if (this._primaryKeyClass.equals(Double.class) || this._primaryKeyClass.equals(Double.TYPE)) {
            return new Double(objectId);
        }
        if (Character.class.equals((Object)this._primaryKeyClass) || Character.TYPE.equals(this._primaryKeyClass)) {
            return objectId;
        }
        if (this._fields != null) {
            Object obj;
            try {
                obj = this._primaryKeyClass.newInstance();
                int length = objectId.length();
                int j = 0;
                CharBuffer cb = new CharBuffer();
                for (int i = 0; i < this._fields.length; ++i) {
                    cb.clear();
                    while (j < length && objectId.charAt(j) != ',') {
                        cb.append(objectId.charAt(j));
                        ++j;
                    }
                    ++j;
                    String field = cb.toString();
                    Class<?> fieldClass = this._fields[i].getType();
                    if (fieldClass.equals(String.class)) {
                        this._fields[i].set(obj, field);
                        continue;
                    }
                    if (fieldClass.equals(Integer.TYPE)) {
                        this._fields[i].setInt(obj, Integer.parseInt(field));
                        continue;
                    }
                    if (fieldClass.equals(Integer.class)) {
                        this._fields[i].set(obj, new Integer(field));
                        continue;
                    }
                    if (fieldClass.equals(Long.TYPE)) {
                        this._fields[i].setLong(obj, Long.parseLong(field));
                        continue;
                    }
                    if (fieldClass.equals(Long.class)) {
                        this._fields[i].set(obj, new Long(field));
                        continue;
                    }
                    if (fieldClass.equals(Float.TYPE)) {
                        this._fields[i].setFloat(obj, (float)Double.parseDouble(field));
                        continue;
                    }
                    if (fieldClass.equals(Float.class)) {
                        this._fields[i].set(obj, new Float(field));
                        continue;
                    }
                    if (fieldClass.equals(Double.TYPE)) {
                        this._fields[i].setDouble(obj, Double.parseDouble(field));
                        continue;
                    }
                    if (fieldClass.equals(Double.class)) {
                        this._fields[i].set(obj, new Double(field));
                        continue;
                    }
                    if (Character.TYPE.equals(fieldClass)) {
                        this._fields[i].setChar(obj, field.charAt(0));
                        continue;
                    }
                    if (Character.class.equals(fieldClass)) {
                        this._fields[i].set(obj, new Character(field.charAt(0)));
                        continue;
                    }
                    throw new RuntimeException();
                }
                ++j;
            }
            catch (Exception e) {
                throw EJBExceptionWrapper.create(e);
            }
            return obj;
        }
        throw new EJBException("bad primary key class");
    }

    static {
        int i;
        int i2;
        serverEncode64 = new char[64];
        for (i2 = 0; i2 < 26; ++i2) {
            BurlapHandleEncoder.serverEncode64[i2] = (char)(97 + i2);
            BurlapHandleEncoder.serverEncode64[i2 + 26] = (char)(65 + i2);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            BurlapHandleEncoder.serverEncode64[i2 + 52] = (char)(48 + i2);
        }
        BurlapHandleEncoder.serverEncode64[62] = 45;
        BurlapHandleEncoder.serverEncode64[63] = 95;
        serverHash64 = new int[256];
        for (i2 = 0; i2 < 26; ++i2) {
            BurlapHandleEncoder.serverHash64[97 + i2] = i2;
            BurlapHandleEncoder.serverHash64[65 + i2] = i2 + 26;
        }
        for (i2 = 0; i2 < 10; ++i2) {
            BurlapHandleEncoder.serverHash64[48 + i2] = 52 + i2;
        }
        BurlapHandleEncoder.serverHash64[45] = 62;
        BurlapHandleEncoder.serverHash64[95] = 63;
        int j = 64;
        for (i = 0; i < 256; ++i) {
            if (serverHash64[i] != 0) continue;
            BurlapHandleEncoder.serverHash64[i] = j++;
        }
        serverEncodeH2 = new char[64];
        j = 0;
        for (i = 0; i < 64; ++i) {
            BurlapHandleEncoder.serverEncodeH2[j] = serverEncode64[i];
            j = (j + 49) % 64;
        }
    }
}

