/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.burlap;

import com.caucho.burlap.io.BurlapInput;
import com.caucho.burlap.io.BurlapOutput;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.burlap.BurlapProtocol;
import com.caucho.ejb.burlap.BurlapProtocolException;
import com.caucho.ejb.burlap.BurlapReader;
import com.caucho.ejb.burlap.BurlapWriter;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.ejb.protocol.Skeleton;
import com.caucho.log.Log;
import com.caucho.services.name.NameServerRemote;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBHome;

public class NameContextSkeleton
extends Skeleton {
    protected static final Logger log = Log.open(NameContextSkeleton.class);
    private BurlapProtocol _protocol;
    private String _prefix;

    NameContextSkeleton(BurlapProtocol protocol, String prefix) {
        this._protocol = protocol;
        this._prefix = prefix;
    }

    public void _service(InputStream is, OutputStream os) throws Exception {
        BurlapReader in = new BurlapReader(is);
        BurlapWriter out = new BurlapWriter(os);
        in.startCall();
        String method = in.getMethod();
        try {
            if (method.equals("lookup") || method.equals("lookup_string") || method.equals("lookup_1")) {
                this.executeLookup(in, out);
            } else if (method.equals("list")) {
                this.executeList(in, out);
            } else {
                this.executeUnknown(method, in, out);
            }
        }
        catch (BurlapProtocolException e) {
            throw e;
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
            out.startReply();
            out.writeFault("ServiceException", e.getMessage(), e);
            out.completeReply();
        }
    }

    private void executeLookup(BurlapInput in, BurlapOutput out) throws Throwable {
        String name = in.readString();
        in.completeCall();
        EjbProtocolManager container = this._protocol.getProtocolManager();
        AbstractServer server = container.getServerByEJBName(name);
        if (server != null) {
            EJBHome home = server.getEJBHome();
            out.startReply();
            out.writeObject((Object)home);
            out.completeReply();
        } else if (container.getRemoteChildren(name) != null) {
            out.startReply();
            String serverId = this._prefix + name;
            if (serverId.startsWith("/")) {
                serverId = serverId.substring(1);
            }
            out.writeRemote(NameServerRemote.class.getName(), this._protocol.getURLPrefix() + serverId);
            out.completeReply();
        } else {
            out.startReply();
            out.writeNull();
            out.completeReply();
        }
    }

    private void executeList(BurlapInput in, BurlapOutput out) throws Throwable {
        in.completeCall();
        EjbProtocolManager container = this._protocol.getProtocolManager();
        AbstractServer server = container.getServerByEJBName(this._prefix);
        if (server != null) {
            EJBHome home = server.getEJBHome();
            out.startReply();
            out.writeNull();
            out.completeReply();
        } else {
            ArrayList<String> children = container.getRemoteChildren(this._prefix);
            if (children != null) {
                out.startReply();
                out.writeObject((Object)children.toArray(new String[children.size()]));
                out.completeReply();
            } else {
                out.startReply();
                out.writeNull();
                out.completeReply();
            }
        }
    }

    protected void executeUnknown(String method, BurlapInput in, BurlapOutput out) throws Exception {
        if (method.equals("_burlap_getAttribute")) {
            String key = in.readString();
            in.completeCall();
            out.startReply();
            if ("java.api.class".equals(key)) {
                out.writeString(NameServerRemote.class.getName());
            } else if ("java.home.class".equals(key)) {
                out.writeString(NameServerRemote.class.getName());
            } else if ("java.object.class".equals(key)) {
                out.writeString(NameServerRemote.class.getName());
            } else if ("home-class".equals(key)) {
                out.writeString(NameServerRemote.class.getName());
            } else if ("remote-class".equals(key)) {
                out.writeString(NameServerRemote.class.getName());
            } else {
                out.writeNull();
            }
            out.completeReply();
        } else {
            out.startReply();
            out.writeFault("NoMethod", "no such method: " + method, null);
            out.completeReply();
        }
    }
}

