/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ejb.EntityBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiClass {
    private static final L10N L = new L10N(ApiClass.class);
    public static final ApiClass OBJECT = new ApiClass(Object.class);
    public static final ApiClass ENTITY_BEAN = new ApiClass(EntityBean.class);
    private Class _apiClass;
    private HashMap<String, Type> _typeMap;
    private ArrayList<Type> _typeParam;
    private ArrayList<ApiMethod> _methods = new ArrayList();
    private ArrayList<ApiClass> _interfaces = new ArrayList();

    public ApiClass(Class apiClass) {
        this(apiClass, null);
    }

    public ApiClass(Class apiClass, HashMap<String, Type> parentTypeMap) {
        if (apiClass == null) {
            throw new NullPointerException();
        }
        this._apiClass = apiClass;
        this._typeMap = new HashMap();
        if (parentTypeMap != null) {
            this._typeMap.putAll(parentTypeMap);
        }
        this.introspectClass(apiClass, this._typeMap);
    }

    public ApiClass(Class apiClass, HashMap<String, Type> parentTypeMap, ArrayList<Type> param) {
        this(apiClass, parentTypeMap);
        this._typeParam = param;
    }

    public String getName() {
        return this._apiClass.getName();
    }

    public String getSimpleName() {
        return this._apiClass.getSimpleName();
    }

    public String getDeclarationName() {
        if (this._typeParam == null || this._typeParam.size() == 0) {
            return this._apiClass.getName();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this._apiClass.getName());
        sb.append("<");
        for (int i = 0; i < this._typeParam.size(); ++i) {
            Type type;
            if (i != 0) {
                sb.append(",");
            }
            if ((type = this._typeParam.get(i)) instanceof Class) {
                sb.append(((Class)type).getName());
                continue;
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                Class rawType = (Class)pType.getRawType();
                sb.append(rawType.getName());
                continue;
            }
            throw new UnsupportedOperationException();
        }
        sb.append(">");
        return sb.toString();
    }

    public HashMap<String, Type> getTypeMap() {
        return this._typeMap;
    }

    public Class getJavaClass() {
        return this._apiClass;
    }

    public boolean isPublic() {
        return Modifier.isPublic(this._apiClass.getModifiers());
    }

    public boolean isInterface() {
        return Modifier.isInterface(this._apiClass.getModifiers());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this._apiClass.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this._apiClass.getModifiers());
    }

    public boolean isPrimitive() {
        return this._apiClass.isPrimitive();
    }

    public Field[] getFields() {
        return this._apiClass.getFields();
    }

    public ArrayList<ApiClass> getInterfaces() {
        return this._interfaces;
    }

    public Constructor getConstructor(Class[] param) throws NoSuchMethodException {
        return this._apiClass.getConstructor(param);
    }

    public ArrayList<ApiMethod> getMethods() {
        return this._methods;
    }

    public ApiMethod getMethod(Method method) {
        return this.getMethod(method.getName(), method.getParameterTypes());
    }

    public ApiMethod getMethod(ApiMethod method) {
        return this.getMethod(method.getName(), method.getParameterTypes());
    }

    public boolean hasMethod(String name, Class[] args) {
        return this.getMethod(name, args) != null;
    }

    public ApiMethod getMethod(String name, Class[] param) {
        for (int i = 0; i < this._methods.size(); ++i) {
            ApiMethod method = this._methods.get(i);
            if (!method.isMatch(name, param)) continue;
            return method;
        }
        return null;
    }

    public boolean isAnnotationPresent(Class annType) {
        return this._apiClass.isAnnotationPresent(annType);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annType) {
        return this._apiClass.getAnnotation(annType);
    }

    private void introspectClass(Class cl, HashMap<String, Type> typeMap) {
        if (cl == null) {
            return;
        }
        for (Method method : cl.getDeclaredMethods()) {
            ApiMethod apiMethod = new ApiMethod(this, method, typeMap);
            if (this._methods.contains(apiMethod)) continue;
            this._methods.add(apiMethod);
        }
        this.introspectGenericClass(cl.getGenericSuperclass(), typeMap);
        for (Type subClass : cl.getGenericInterfaces()) {
            ApiClass iface = this.introspectGenericClass(subClass, typeMap);
            if (cl != this._apiClass || iface == null) continue;
            this._interfaces.add(iface);
        }
    }

    private ApiClass introspectGenericClass(Type type, HashMap<String, Type> typeMap) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            this.introspectClass((Class)type, typeMap);
            return new ApiClass((Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type[] args = pType.getActualTypeArguments();
            Class rawType = (Class)pType.getRawType();
            TypeVariable<Class<T>>[] params = rawType.getTypeParameters();
            HashMap<String, Type> subMap = new HashMap<String, Type>(typeMap);
            ArrayList<Type> paramList = new ArrayList<Type>();
            for (int i = 0; i < params.length; ++i) {
                TypeVariable argVar;
                TypeVariable param = params[i];
                Type arg = args[i];
                if (arg instanceof TypeVariable && typeMap.get((argVar = (TypeVariable)arg).getName()) != null) {
                    arg = typeMap.get(argVar.getName());
                }
                subMap.put(param.getName(), arg);
                paramList.add(arg);
            }
            this.introspectClass(rawType, subMap);
            return new ApiClass(rawType, subMap, paramList);
        }
        return null;
    }

    public String toString() {
        return "ApiClass[" + this._apiClass.getName() + "]";
    }
}

