/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.ejb.cfg.ApiClass;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiMethod {
    private static final L10N L = new L10N(ApiMethod.class);
    private ApiClass _apiClass;
    private Method _method;
    private Class _returnType;
    private Class[] _parameterTypes;
    private Class[] _exceptionTypes;

    public ApiMethod(ApiClass apiClass, Method method, HashMap<String, Type> typeMap) {
        this._apiClass = apiClass;
        this._method = method;
        this.introspect(method, typeMap);
    }

    public Method getMethod() {
        return this._method;
    }

    public String getName() {
        return this._method.getName();
    }

    public Class getDeclaringClass() {
        return this._method.getDeclaringClass();
    }

    public boolean isPublic() {
        return Modifier.isPublic(this._method.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this._method.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this._method.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this._method.getModifiers());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this._method.getModifiers());
    }

    public Class[] getParameterTypes() {
        return this._parameterTypes;
    }

    public boolean isVarArgs() {
        return this._method.isVarArgs();
    }

    public Class getReturnType() {
        return this._returnType;
    }

    public Class[] getExceptionTypes() {
        return this._exceptionTypes;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annType) {
        return this._method.getAnnotation(annType);
    }

    public boolean isAnnotationPresent(Class annotationType) {
        return this._method.isAnnotationPresent(annotationType);
    }

    public boolean isMatch(ApiMethod method) {
        return this.isMatch(method.getName(), method.getParameterTypes());
    }

    public boolean isMatch(String name, Class[] param) {
        if (!name.equals(this._method.getName())) {
            return false;
        }
        if (this._parameterTypes.length != param.length) {
            return false;
        }
        for (int i = 0; i < param.length; ++i) {
            if (param[i].equals(this._parameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    private void introspect(Method method, HashMap<String, Type> typeMap) {
        Type[] paramTypes = method.getGenericParameterTypes();
        this._parameterTypes = new Class[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            this._parameterTypes[i] = this.resolve(paramTypes[i], typeMap);
        }
        this._returnType = this.resolve(method.getGenericReturnType(), typeMap);
        Type[] exceptionTypes = method.getGenericExceptionTypes();
        this._exceptionTypes = new Class[exceptionTypes.length];
        for (int i = 0; i < exceptionTypes.length; ++i) {
            this._exceptionTypes[i] = this.resolve(exceptionTypes[i], typeMap);
        }
    }

    private Class resolve(Type type, HashMap<String, Type> typeMap) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof TypeVariable) {
            TypeVariable var = (TypeVariable)type;
            Type value = typeMap.get(var.getName());
            if (value != null && value != type) {
                return this.resolve(value, typeMap);
            }
            Type[] bounds = var.getBounds();
            if (bounds == null || bounds.length < 1) {
                return Object.class;
            }
            return this.resolve(bounds[0], typeMap);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Class compType = this.resolve(arrayType.getGenericComponentType(), typeMap);
            try {
                return Array.newInstance(compType, 0).getClass();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return (Class)pType.getRawType();
        }
        throw new UnsupportedOperationException(type.getClass().getName());
    }

    public int hashCode() {
        return this._method.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApiMethod)) {
            return false;
        }
        ApiMethod method = (ApiMethod)o;
        if (!this._method.getName().equals(method._method.getName())) {
            return false;
        }
        if (this._parameterTypes.length != method._parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < this._parameterTypes.length; ++i) {
            if (this._parameterTypes[i].equals(method._parameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    public String getFullName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._method.getDeclaringClass().getSimpleName());
        sb.append(".");
        sb.append(this._method.getName());
        sb.append("(");
        for (int i = 0; i < this._parameterTypes.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(this._parameterTypes[i].getSimpleName());
        }
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ApiMethod[");
        sb.append(this._method.getDeclaringClass().getSimpleName());
        sb.append(".");
        sb.append(this._method.getName());
        sb.append("(");
        for (int i = 0; i < this._parameterTypes.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(this._parameterTypes[i].getSimpleName());
        }
        sb.append(")");
        sb.append("]");
        return sb.toString();
    }
}

