/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.EjbMethodPattern;
import com.caucho.ejb.cfg.MethodSignature;
import com.caucho.util.L10N;
import javax.annotation.PostConstruct;

public class ContainerTransaction {
    private static final L10N L = new L10N(ContainerTransaction.class);
    private EjbConfig _config;
    private String _location;
    private MethodSignature _method;
    private String _trans;

    public ContainerTransaction(EjbConfig config) {
        this._config = config;
    }

    public void setConfigLocation(String filename, int line) {
        this._location = filename + ":" + line;
    }

    public void setDescription(String description) {
    }

    public void setMethod(MethodSignature method) {
        this._method = method;
    }

    public void setTransAttribute(String trans) throws ConfigException {
        if (!(trans.equals("Required") || trans.equals("RequiresNew") || trans.equals("Mandatory") || trans.equals("NotSupported") || trans.equals("Never") || trans.equals("Supports"))) {
            throw new ConfigException(L.l("'{0}' is an unknown transaction type.  The transaction types are:\n  Required - creates a new transaction if none is active.\n  RequiresNew - always creates a new transaction.\n  Mandatory - requires an active transaction.\n  NotSupported - suspends any active transaction.\n  Never - forbids any active transaction.\n  Supports - allows a transaction or no transaction.", (Object)trans));
        }
        this._trans = trans;
    }

    @PostConstruct
    public void init() throws ConfigException {
        EjbBean bean = this._config.getBeanConfig(this._method.getEJBName());
        if (bean == null) {
            throw new ConfigException(L.l("'{0}' is an unknown entity bean.", (Object)this._method.getEJBName()));
        }
        EjbMethodPattern method = bean.createMethod(this._method);
        method.setTransAttribute(this._trans);
        this.setInternalTransactionAttribute("ejb", bean);
        this.setInternalTransactionAttribute("ejbHome", bean);
    }

    private void setInternalTransactionAttribute(String prefix, EjbBean bean) {
        if (!this._method.getName().startsWith(prefix)) {
            MethodSignature signature = new MethodSignature();
            signature.setEJBName(this._method.getEJBName());
            String methodName = this._method.getName();
            methodName = Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
            signature.setMethodName(prefix + methodName);
            EjbMethodPattern method = bean.createMethod(signature);
            method.setTransAttribute(this._trans);
        }
    }
}

