/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.DependencyBean;
import com.caucho.config.LineConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.types.DescriptionGroupConfig;
import com.caucho.config.types.MessageDestinationRef;
import com.caucho.config.types.Period;
import com.caucho.config.types.PostConstructType;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.amber.AmberConfig;
import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.cfg.AroundInvokeConfig;
import com.caucho.ejb.cfg.EjbBaseMethod;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.EjbMethodPattern;
import com.caucho.ejb.cfg.EjbObjectView;
import com.caucho.ejb.cfg.EjbSecurityIdentity;
import com.caucho.ejb.cfg.Interceptor;
import com.caucho.ejb.cfg.InterceptorBinding;
import com.caucho.ejb.cfg.MethodSignature;
import com.caucho.ejb.cfg.RemoveMethod;
import com.caucho.ejb.cfg21.EjbHomeView;
import com.caucho.ejb.gen.BeanGenerator;
import com.caucho.ejb.gen.BusinessMethodGenerator;
import com.caucho.ejb.gen.TransactionChain;
import com.caucho.ejb.gen.View;
import com.caucho.ejb.gen21.BeanAssembler;
import com.caucho.ejb.gen21.ViewClass;
import com.caucho.ejb.manager.EjbContainer;
import com.caucho.java.gen.BaseClass;
import com.caucho.java.gen.BaseMethod;
import com.caucho.java.gen.CallChain;
import com.caucho.java.gen.GenClass;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.java.gen.MethodCallChain;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.make.ClassDependency;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import com.caucho.vfs.Vfs;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Timeout;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbBean
extends DescriptionGroupConfig
implements EnvironmentBean,
DependencyBean {
    private static Logger log = Logger.getLogger(EjbBean.class.getName());
    private static L10N L = new L10N(EjbBean.class);
    private static EnvironmentLocal<Map<Class, SoftReference<ApiMethod[]>>> _methodCache = new EnvironmentLocal();
    private final EjbConfig _ejbConfig;
    private final String _ejbModuleName;
    private ClassLoader _loader;
    protected ClassLoader _jClassLoader;
    private String _ejbName;
    private String _mappedName;
    private String _location = "";
    private String _filename;
    private int _line;
    private boolean _isInit;
    private ApiClass _ejbClass;
    protected ApiClass _remoteHome;
    protected ArrayList<ApiClass> _remoteList = new ArrayList();
    protected ApiClass _localHome;
    protected ArrayList<ApiClass> _localList = new ArrayList();
    protected BeanGenerator _bean;
    private boolean _isAllowPOJO = true;
    protected boolean _isContainerTransaction = true;
    ArrayList<PersistentDependency> _dependList = new ArrayList();
    ArrayList<PersistentDependency> _configDependList = new ArrayList();
    ArrayList<String> _beanDependList = new ArrayList();
    protected ArrayList<EjbMethodPattern> _methodList = new ArrayList();
    private HashMap<String, EjbBaseMethod> _methodMap = new HashMap();
    private ContainerProgram _initProgram;
    private ArrayList<ConfigProgram> _postConstructList = new ArrayList();
    private ContainerProgram _serverProgram;
    private ArrayList<Interceptor> _interceptors = new ArrayList();
    private String _aroundInvokeMethodName;
    private Method _aroundInvokeMethod;
    private String _timeoutMethodName;
    private long _transactionTimeout;
    private AroundInvokeConfig _aroundInvokeConfig;
    private ArrayList<RemoveMethod> _removeMethods = new ArrayList();

    public EjbBean(EjbConfig ejbConfig, String ejbModuleName) {
        this._ejbConfig = ejbConfig;
        this._ejbModuleName = ejbModuleName;
        this._loader = ejbConfig.getEjbContainer().getClassLoader();
        this.getEjbContainer().getTransactionManager().setEJB3(this.isEJB3());
    }

    public EjbConfig getConfig() {
        return this._ejbConfig;
    }

    public EjbContainer getEjbContainer() {
        return this._ejbConfig.getEjbContainer();
    }

    public String getAroundInvokeMethodName() {
        return this._aroundInvokeMethodName;
    }

    public void setAroundInvokeMethodName(String aroundInvokeMethodName) {
        this._aroundInvokeMethodName = aroundInvokeMethodName;
    }

    public void setAroundInvoke(AroundInvokeConfig aroundInvoke) {
        this._aroundInvokeConfig = aroundInvoke;
        this._aroundInvokeMethodName = aroundInvoke.getMethodName();
    }

    public RemoveMethod getRemoveMethod(Method method) {
        for (RemoveMethod removeMethod : this._removeMethods) {
            if (!removeMethod.isMatch(method)) continue;
            return removeMethod;
        }
        return null;
    }

    public ArrayList<RemoveMethod> getRemoveMethods() {
        return this._removeMethods;
    }

    public String getTimeoutMethodName() {
        return this._timeoutMethodName;
    }

    public void addRemoveMethod(RemoveMethod removeMethod) {
        this._removeMethods.add(removeMethod);
    }

    public ArrayList<Interceptor> getInterceptors() {
        return this._interceptors;
    }

    public ArrayList<Interceptor> getInvokeInterceptors(String methodName) {
        ArrayList<Interceptor> matchList = null;
        for (Interceptor interceptor : this._interceptors) {
            if (!methodName.equals(interceptor.getAroundInvokeMethodName())) continue;
            if (matchList == null) {
                matchList = new ArrayList<Interceptor>();
            }
            matchList.add(interceptor);
        }
        return matchList;
    }

    public void addInterceptor(Interceptor interceptor) {
        this._interceptors.add(interceptor);
    }

    public boolean containsInterceptor(String interceptorClassName) {
        return this.getInterceptor(interceptorClassName) != null;
    }

    public Interceptor getInterceptor(String interceptorClassName) {
        for (Interceptor interceptor : this._interceptors) {
            String className = interceptor.getInterceptorClass();
            if (!className.equals(interceptorClassName)) continue;
            return interceptor;
        }
        return null;
    }

    public String getEJBModuleName() {
        return this._ejbModuleName;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._loader;
    }

    protected Class loadClass(String className) {
        try {
            return Class.forName(className, false, this._loader);
        }
        catch (ClassNotFoundException e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public void setConfigLocation(String filename, int line) {
        if (this._filename == null) {
            this._filename = filename;
            this._line = line;
        }
        if (this._location == null) {
            this._location = filename + ":" + line + ": ";
        }
    }

    public void setLocation(String location) {
        this._location = location;
    }

    public String getLocation() {
        return this._location;
    }

    public String getFilename() {
        return this._filename;
    }

    public int getLine() {
        return this._line;
    }

    public void setAllowPOJO(boolean allowPOJO) {
        this._isAllowPOJO = allowPOJO;
    }

    public boolean isAllowPOJO() {
        return this._isAllowPOJO;
    }

    public void setEJBName(String ejbName) {
        this._ejbName = ejbName;
    }

    public String getEJBName() {
        return this._ejbName;
    }

    public void setMappedName(String mappedName) {
        this._mappedName = mappedName;
    }

    public String getMappedName() {
        return this._mappedName == null ? this.getEJBName() : this._mappedName;
    }

    public String getEJBKind() {
        return "unknown";
    }

    public void setEJBClass(Class ejbClass) throws ConfigException {
        this.setEJBClassWrapper(new ApiClass(ejbClass));
    }

    public void setEJBClassWrapper(ApiClass ejbClass) throws ConfigException {
        if (this._ejbClass != null && !this._ejbClass.getName().equals(ejbClass.getName())) {
            throw this.error(L.l("ejb-class '{0}' cannot be redefined.  Old value is '{1}'.", (Object)this._ejbClass.getName(), (Object)ejbClass.getName()));
        }
        this._ejbClass = ejbClass;
        if (!this._ejbClass.isPublic()) {
            throw this.error(L.l("'{0}' must be public.  Bean implementations must be public.", (Object)ejbClass.getName()));
        }
        if (this._ejbClass.isFinal()) {
            throw this.error(L.l("'{0}' must not be final.  Bean implementations must not be final.", (Object)ejbClass.getName()));
        }
        if (this._ejbClass.isInterface()) {
            throw this.error(L.l("'{0}' must not be an interface.  Bean implementations must be classes.", (Object)ejbClass.getName()));
        }
        Constructor constructor = null;
        try {
            constructor = ejbClass.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        if (constructor == null) {
            throw this.error(L.l("'{0}' needs a public zero-arg constructor.  Bean implementations need a public zero-argument constructor.", (Object)ejbClass.getName()));
        }
        for (Class<?> exn : constructor.getExceptionTypes()) {
            if (RuntimeException.class.isAssignableFrom(exn)) continue;
            throw this.error(L.l("{0}: constructor must not throw '{1}'.  Bean constructors must not throw checked exceptions.", (Object)ejbClass.getName(), (Object)exn.getName()));
        }
        ApiMethod method = ejbClass.getMethod("finalize", new Class[0]);
        if (method != null && !method.getDeclaringClass().equals(Object.class)) {
            throw this.error(L.l("'{0}' may not implement finalize().  Bean implementations may not implement finalize().", (Object)ejbClass.getName()));
        }
    }

    public Class getEJBClass() {
        try {
            if (this._ejbClass == null) {
                return null;
            }
            return Class.forName(this._ejbClass.getName(), false, this.getClassLoader());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public ApiClass getEJBClassWrapper() {
        return this._ejbClass;
    }

    public String getEJBFullClassName() {
        return this._ejbClass.getName();
    }

    public String getEJBClassName() {
        String s = this._ejbClass.getName();
        int p = s.lastIndexOf(46);
        if (p > 0) {
            return s.substring(p + 1);
        }
        return s;
    }

    public String getFullImplName() {
        return this.getEJBFullClassName();
    }

    public void setHome(Class homeClass) throws ConfigException {
        ApiClass home = new ApiClass(homeClass);
        this.setRemoteHomeWrapper(home);
    }

    public void setRemoteHomeWrapper(ApiClass remoteHome) throws ConfigException {
        this._remoteHome = remoteHome;
        if (!remoteHome.isPublic()) {
            throw this.error(L.l("'{0}' must be public.  <home> interfaces must be public.", (Object)remoteHome.getName()));
        }
        if (!remoteHome.isInterface()) {
            throw this.error(L.l("'{0}' must be an interface. <home> interfaces must be interfaces.", (Object)remoteHome.getName()));
        }
        if (!EJBHome.class.isAssignableFrom(remoteHome.getJavaClass()) && !this.isAllowPOJO()) {
            throw new ConfigException(L.l("'{0}' must extend EJBHome.  <home> interfaces must extend javax.ejb.EJBHome.", (Object)remoteHome.getName()));
        }
    }

    public ApiClass getRemoteHome() {
        return this._remoteHome;
    }

    public Class getRemoteHomeClass() {
        if (this._remoteHome == null) {
            return null;
        }
        try {
            return Class.forName(this._remoteHome.getName(), false, this.getClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setRemote(Class remote) throws ConfigException {
        this.setRemoteWrapper(new ApiClass(remote));
    }

    public void setRemoteWrapper(ApiClass remote) throws ConfigException {
        if (!remote.isPublic()) {
            throw this.error(L.l("'{0}' must be public.  <remote> interfaces must be public.", (Object)remote.getName()));
        }
        if (!remote.isInterface()) {
            throw this.error(L.l("'{0}' must be an interface. <remote> interfaces must be interfaces.", (Object)remote.getName()));
        }
        if (!EJBObject.class.isAssignableFrom(remote.getJavaClass()) && !this.isAllowPOJO()) {
            throw new ConfigException(L.l("'{0}' must extend EJBObject.  <remote> interfaces must extend javax.ejb.EJBObject.", (Object)remote.getName()));
        }
        if (!this._remoteList.contains(remote)) {
            this._remoteList.add(remote);
        }
    }

    public void addBusinessRemote(Class remoteClass) {
        ApiClass remote = new ApiClass(remoteClass);
        if (!remote.isPublic()) {
            throw this.error(L.l("'{0}' must be public.  <business-remote> interfaces must be public.", (Object)remote.getName()));
        }
        if (!remote.isInterface()) {
            throw this.error(L.l("'{0}' must be an interface. <business-remote> interfaces must be interfaces.", (Object)remote.getName()));
        }
        if (!this._remoteList.contains(remote)) {
            this._remoteList.add(remote);
        }
    }

    public ArrayList<ApiClass> getRemoteList() {
        return this._remoteList;
    }

    public Class getRemoteClass() {
        if (this._remoteList.size() < 1) {
            return null;
        }
        try {
            ApiClass remote = this._remoteList.get(0);
            return Class.forName(remote.getName(), false, this.getClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setLocalHome(Class localHomeClass) throws ConfigException {
        ApiClass localHome = new ApiClass(localHomeClass);
        this.setLocalHomeWrapper(localHome);
    }

    public void setLocalHomeWrapper(ApiClass localHome) throws ConfigException {
        this._localHome = localHome;
        if (!localHome.isPublic()) {
            throw this.error(L.l("'{0}' must be public.  <local-home> interfaces must be public.", (Object)localHome.getName()));
        }
        if (!localHome.isInterface()) {
            throw this.error(L.l("'{0}' must be an interface. <local-home> interfaces must be interfaces.", (Object)localHome.getName()));
        }
        if (!EJBLocalHome.class.isAssignableFrom(localHome.getJavaClass()) && !this.isAllowPOJO()) {
            throw new ConfigException(L.l("'{0}' must extend EJBLocalHome.  <local-home> interfaces must extend javax.ejb.EJBLocalHome.", (Object)localHome.getName()));
        }
    }

    public ApiClass getLocalHome() {
        return this._localHome;
    }

    public void setLocal(Class local) throws ConfigException {
        this.setLocalWrapper(new ApiClass(local));
    }

    public void setLocalWrapper(ApiClass local) throws ConfigException {
        if (!local.isPublic()) {
            throw this.error(L.l("'{0}' must be public.  <local> interfaces must be public.", (Object)local.getName()));
        }
        if (!local.isInterface()) {
            throw this.error(L.l("'{0}' must be an interface. <local> interfaces must be interfaces.", (Object)local.getName()));
        }
        if (!EJBLocalObject.class.isAssignableFrom(local.getJavaClass()) && !this.isAllowPOJO()) {
            throw new ConfigException(L.l("'{0}' must extend EJBLocalObject.  <local> interfaces must extend javax.ejb.EJBLocalObject.", (Object)local.getName()));
        }
        if (!this._localList.contains(local)) {
            this._localList.add(local);
        }
    }

    public void addBusinessLocal(Class localClass) {
        ApiClass local = new ApiClass(localClass);
        if (!local.isPublic()) {
            throw this.error(L.l("'{0}' must be public.  <local> interfaces must be public.", (Object)local.getName()));
        }
        if (!local.isInterface()) {
            throw this.error(L.l("'{0}' must be an interface. <local> interfaces must be interfaces.", (Object)local.getName()));
        }
        if (!this._localList.contains(local)) {
            this._localList.add(local);
        }
    }

    public ArrayList<ApiClass> getLocalList() {
        return this._localList;
    }

    public boolean isContainerTransaction() {
        return this._isContainerTransaction;
    }

    public void setContainerTransaction(boolean isContainerTransaction) {
        this._isContainerTransaction = isContainerTransaction;
    }

    public EjbMethodPattern createMethod(MethodSignature sig) {
        for (int i = 0; i < this._methodList.size(); ++i) {
            EjbMethodPattern method = this._methodList.get(i);
            if (!method.getSignature().equals(sig)) continue;
            return method;
        }
        EjbMethodPattern method = new EjbMethodPattern(this, sig);
        this._methodList.add(method);
        return method;
    }

    public void addMethod(EjbMethodPattern method) {
        this._methodList.add(method);
    }

    public EjbMethodPattern getMethodPattern(ApiMethod method, String intf) {
        EjbMethodPattern bestMethod = null;
        int bestCost = -1;
        for (int i = 0; i < this._methodList.size(); ++i) {
            EjbMethodPattern ejbMethod = this._methodList.get(i);
            MethodSignature sig = ejbMethod.getSignature();
            if (!sig.isMatch(method, intf) || bestCost >= sig.getCost()) continue;
            bestMethod = ejbMethod;
            bestCost = sig.getCost();
        }
        return bestMethod;
    }

    public ArrayList<EjbMethodPattern> getMethodList() {
        return this._methodList;
    }

    public void setTransactionTimeout(Period timeout) {
        this._transactionTimeout = timeout.getPeriod();
    }

    public long getTransactionTimeout() {
        return this._transactionTimeout;
    }

    public MessageDestinationRef createMessageDestinationRef() {
        return new MessageDestinationRef(Vfs.lookup(this._ejbModuleName));
    }

    public void setSecurityIdentity(EjbSecurityIdentity securityIdentity) {
    }

    public void addDependencyList(ArrayList<PersistentDependency> dependList) {
        for (int i = 0; dependList != null && i < dependList.size(); ++i) {
            this.addDependency(dependList.get(i));
        }
    }

    public void addDepend(Path path) {
        this.addDependency((PersistentDependency)new Depend(path));
    }

    @Override
    public void addDependency(PersistentDependency depend) {
        if (!this._dependList.contains(depend)) {
            this._dependList.add(depend);
        }
    }

    public void addDependency(Class cl) {
        this.addDependency(new ClassDependency(cl));
    }

    public ArrayList<PersistentDependency> getDependList() {
        return this._dependList;
    }

    public void addBeanDependency(String ejbName) {
        if (!this._beanDependList.contains(ejbName)) {
            this._beanDependList.add(ejbName);
        }
    }

    public ArrayList<String> getBeanDependList() {
        return this._beanDependList;
    }

    public void addInitProgram(ConfigProgram init) {
        if (this._initProgram == null) {
            this._initProgram = new ContainerProgram();
        }
        this._initProgram.addProgram(init);
    }

    public void addBuilderProgram(ConfigProgram init) {
        if (this._serverProgram == null) {
            this._serverProgram = new ContainerProgram();
        }
        this._serverProgram.addProgram(init);
    }

    public void setInit(ContainerProgram init) {
        if (this._initProgram == null) {
            this._initProgram = new ContainerProgram();
        }
        this._initProgram.addProgram(init);
    }

    public void addPostConstruct(PostConstructType postConstruct) {
        this._postConstructList.add(postConstruct.getProgram(this.getEJBClass()));
    }

    public ContainerProgram getInitProgram() {
        if (this._postConstructList != null) {
            if (this._initProgram == null) {
                this._initProgram = new ContainerProgram();
            }
            for (ConfigProgram program : this._postConstructList) {
                this._initProgram.addProgram(program);
            }
            this._postConstructList = null;
        }
        return this._initProgram;
    }

    public ContainerProgram getServerProgram() {
        return this._serverProgram;
    }

    @PostConstruct
    public void init() throws ConfigException {
        try {
            if (this._isInit) {
                return;
            }
            this._isInit = true;
            if (this.getEJBClassWrapper() == null) {
                throw this.error(L.l("ejb-class is not defined for '{0}'", (Object)this.getEJBName()));
            }
            this._bean = this.createBeanGenerator();
            if (this.getLocalHome() != null) {
                this._bean.setLocalHome(this.getLocalHome());
            }
            for (ApiClass localApi : this._localList) {
                this._bean.addLocal(localApi);
            }
            if (this.getRemoteHome() != null) {
                this._bean.setRemoteHome(this.getRemoteHome());
            }
            for (ApiClass remoteApi : this._remoteList) {
                this._bean.addRemote(remoteApi);
            }
            this.introspect();
            this._bean.createViews();
            InterceptorBinding interceptor = this.getConfig().getInterceptorBinding(this.getEJBName(), false);
            if (this._aroundInvokeMethodName != null) {
                ApiMethod method = this.getMethod(this._aroundInvokeMethodName, new Class[]{InvocationContext.class});
                if (method == null) {
                    throw this.error(L.l("'{0}' is an unknown around-invoke method", (Object)this._aroundInvokeMethodName));
                }
                this._bean.setAroundInvokeMethod(method.getMethod());
            }
            if (interceptor != null) {
                for (Class clazz : interceptor.getInterceptors()) {
                    this._bean.addInterceptor(clazz);
                }
            }
            for (View view : this._bean.getViews()) {
                for (BusinessMethodGenerator businessMethodGenerator : view.getMethods()) {
                    if (this.isContainerTransaction()) continue;
                    businessMethodGenerator.getXa().setContainerManaged(false);
                }
            }
            for (EjbMethodPattern ejbMethodPattern : this._methodList) {
                ejbMethodPattern.configure(this._bean);
            }
            for (RemoveMethod removeMethod : this._removeMethods) {
                removeMethod.configure(this._bean);
            }
        }
        catch (ConfigException e) {
            throw ConfigException.createLine((String)this._location, (Throwable)e);
        }
    }

    protected void introspect() {
        this._bean.introspect();
    }

    protected BeanGenerator createBeanGenerator() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void initIntrospect() throws ConfigException {
        boolean isExcludeDefault = false;
        InterceptorBinding binding = this._ejbConfig.getInterceptorBinding(this.getEJBName(), isExcludeDefault);
    }

    private Interceptor configureInterceptor(Class type) throws ConfigException {
        try {
            Interceptor interceptor = new Interceptor();
            interceptor.setInterceptorClass(type.getName());
            interceptor.init();
            return interceptor;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void configureAmber(AmberConfig config) throws ConfigException {
    }

    protected void createViews21() throws ConfigException {
    }

    protected EjbHomeView createHomeView(ApiClass homeClass, String prefix) throws ConfigException {
        return new EjbHomeView(this, homeClass, prefix);
    }

    protected EjbObjectView createObjectView(ArrayList<ApiClass> apiList, String prefix, String suffix) throws ConfigException {
        return new EjbObjectView(this, apiList, prefix, suffix, false);
    }

    protected EjbObjectView createRemoteObjectView(ArrayList<ApiClass> apiList, String prefix, String suffix) throws ConfigException {
        return new EjbObjectView(this, apiList, prefix, suffix, true);
    }

    public void generate(JavaClassGenerator javaGen, boolean isAutoCompile) throws Exception {
        String fullClassName = this._bean.getFullClassName();
        if (javaGen.preload(fullClassName) == null && isAutoCompile) {
            javaGen.generate(this._bean);
        }
    }

    public AbstractServer deployServer(EjbContainer ejbContainer, JavaClassGenerator javaGen) throws ClassNotFoundException, ConfigException {
        throw new UnsupportedOperationException();
    }

    protected void validateRemote(ApiClass objectClass) throws ConfigException {
        ApiClass beanClass = this.getEJBClassWrapper();
        String beanName = beanClass.getName();
        String objectName = objectClass.getName();
        if (!objectClass.isPublic()) {
            throw this.error(L.l("'{0}' must be public", (Object)objectName));
        }
        if (!objectClass.isInterface()) {
            throw this.error(L.l("'{0}' must be an interface", (Object)objectName));
        }
        for (ApiMethod method : objectClass.getMethods()) {
            String name = method.getName();
            Class[] param = method.getParameterTypes();
            Class retType = method.getReturnType();
            if (method.getDeclaringClass().isAssignableFrom(EJBObject.class) || method.getDeclaringClass().isAssignableFrom(EJBLocalObject.class)) continue;
            if (EJBObject.class.isAssignableFrom(objectClass.getJavaClass())) {
                this.validateException(method, RemoteException.class);
            }
            if (name.startsWith("ejb")) {
                throw this.error(L.l("'{0}' forbidden in {1}.  Local or remote interfaces may not define ejbXXX methods.", (Object)EjbBean.getFullMethodName(method), (Object)objectName));
            }
            Class returnType = method.getReturnType();
            if (EJBObject.class.isAssignableFrom(objectClass.getJavaClass()) && (EJBLocalObject.class.isAssignableFrom(returnType) || EJBLocalHome.class.isAssignableFrom(returnType))) {
                throw this.error(L.l("'{0}' must not return '{1}' in {2}.  Remote methods must not return local interfaces.", (Object)EjbBean.getFullMethodName(method), (Object)EjbBean.getShortClassName(returnType), (Object)objectClass.getName()));
            }
            ApiMethod implMethod = this.validateRemoteImplMethod(method.getName(), param, method, objectClass);
            if (!returnType.equals(implMethod.getReturnType())) {
                throw this.error(L.l("{0}: '{1}' must return {2} to match {3}.{4}.  Business methods must return the same type as the interface.", (Object)method.getDeclaringClass().getName(), (Object)EjbBean.getFullMethodName(method), (Object)implMethod.getReturnType().getName(), (Object)EjbBean.getShortClassName(implMethod.getDeclaringClass()), (Object)EjbBean.getFullMethodName(implMethod)));
            }
            this.validateExceptions(method, implMethod.getExceptionTypes());
        }
    }

    private ApiMethod validateRemoteImplMethod(String methodName, Class[] param, ApiMethod sourceMethod, ApiClass sourceClass) throws ConfigException {
        ApiMethod method = null;
        ApiClass beanClass = this.getEJBClassWrapper();
        method = EjbBean.getMethod(beanClass, methodName, param);
        if (method == null && sourceMethod != null) {
            throw this.error(L.l("{0}: '{1}' expected to match {2}.{3}", (Object)beanClass.getName(), (Object)EjbBean.getFullMethodName(methodName, param), (Object)EjbBean.getShortClassName(sourceMethod.getDeclaringClass()), (Object)EjbBean.getFullMethodName(sourceMethod)));
        }
        if (method == null) {
            throw this.error(L.l("{0}: '{1}' expected", (Object)beanClass.getName(), (Object)EjbBean.getFullMethodName(methodName, param)));
        }
        if (!method.isPublic()) {
            throw this.error(L.l("{0}: '{1}' must be public", (Object)beanClass.getName(), (Object)EjbBean.getFullMethodName(methodName, param)));
        }
        if (method.isStatic()) {
            throw this.error(L.l("{0}: '{1}' must not be static", (Object)beanClass.getName(), (Object)EjbBean.getFullMethodName(methodName, param)));
        }
        if (method.isFinal()) {
            throw this.error(L.l("{0}: '{1}' must not be final.", (Object)beanClass.getName(), (Object)EjbBean.getFullMethodName(methodName, param), (Object)beanClass.getName()));
        }
        return method;
    }

    protected ApiMethod validateNonFinalMethod(String methodName, Class[] param, boolean isOptional) throws ConfigException {
        if (isOptional && EjbBean.getMethod(this._ejbClass, methodName, param) == null) {
            return null;
        }
        return this.validateNonFinalMethod(methodName, param);
    }

    protected ApiMethod validateNonFinalMethod(String methodName, Class[] param) throws ConfigException {
        return this.validateNonFinalMethod(methodName, param, null, null);
    }

    protected ApiMethod validateNonFinalMethod(String methodName, Class[] param, ApiMethod sourceMethod, ApiClass sourceClass) throws ConfigException {
        return this.validateNonFinalMethod(methodName, param, sourceMethod, sourceClass, false);
    }

    protected ApiMethod validateNonFinalMethod(String methodName, Class[] param, ApiMethod sourceMethod, ApiClass sourceClass, boolean isOptional) throws ConfigException {
        ApiMethod method = this.validateMethod(methodName, param, sourceMethod, sourceClass, isOptional);
        if (method == null && isOptional) {
            return null;
        }
        if (method.isFinal()) {
            throw this.error(L.l("{0}: '{1}' must not be final", (Object)this._ejbClass.getName(), (Object)EjbBean.getFullMethodName(method)));
        }
        if (method.isStatic()) {
            throw this.error(L.l("{0}: '{1}' must not be static", (Object)this._ejbClass.getName(), (Object)EjbBean.getFullMethodName(method)));
        }
        return method;
    }

    protected ApiMethod validateMethod(String methodName, Class[] param) throws ConfigException {
        return this.validateMethod(methodName, param, null, null);
    }

    protected ApiMethod validateMethod(String methodName, Class[] param, ApiMethod sourceMethod, ApiClass sourceClass) throws ConfigException {
        return this.validateMethod(methodName, param, sourceMethod, sourceClass, false);
    }

    protected ApiMethod validateMethod(String methodName, Class[] param, ApiMethod sourceMethod, ApiClass sourceClass, boolean isOptional) throws ConfigException {
        ApiMethod method = null;
        method = EjbBean.getMethod(this._ejbClass, methodName, param);
        if (method == null && isOptional) {
            return null;
        }
        if (method == null && sourceMethod != null) {
            throw this.error(L.l("{0}: missing '{1}' needed to match {2}.{3}", (Object)this._ejbClass.getName(), (Object)EjbBean.getFullMethodName(methodName, param), (Object)sourceClass.getSimpleName(), (Object)EjbBean.getFullMethodName(sourceMethod)));
        }
        if (method == null) {
            throw this.error(L.l("{0}: expected '{1}'", (Object)this._ejbClass.getName(), (Object)EjbBean.getFullMethodName(methodName, param)));
        }
        Class declaringClass = method.getDeclaringClass();
        if (method.isAbstract()) {
            if (method.getDeclaringClass().getName().equals("javax.ejb.EntityBean")) {
                throw this.error(L.l("{0}: '{1}' must not be abstract.  Entity beans must implement the methods in EntityBean.", (Object)this._ejbClass.getName(), (Object)EjbBean.getFullMethodName(methodName, param)));
            }
            if (method.getDeclaringClass().getName().equals("javax.ejb.SessionBean")) {
                throw this.error(L.l("{0}: '{1}' must not be abstract.  Session beans must implement the methods in SessionBean.", (Object)this._ejbClass.getName(), (Object)EjbBean.getFullMethodName(methodName, param)));
            }
            if (sourceMethod != null) {
                throw this.error(L.l("{0}: '{1}' must not be abstract.  All methods from '{2}' must be implemented in the bean.", (Object)this._ejbClass.getName(), (Object)EjbBean.getFullMethodName(methodName, param), (Object)sourceClass.getName()));
            }
            throw this.error(L.l("{0}: '{1}' must not be abstract.  Business methods must be implemented.", (Object)this._ejbClass.getName(), (Object)EjbBean.getFullMethodName(methodName, param)));
        }
        if (!method.isPublic()) {
            throw this.error(L.l("{0}: '{1}' must be public.  Business method implementations must be public.", (Object)this._ejbClass.getName(), (Object)EjbBean.getFullMethodName(methodName, param)));
        }
        if (method.isStatic()) {
            throw this.error(L.l("{0}: '{1}' must not be static.  Business method implementations must not be static.", (Object)this._ejbClass.getName(), (Object)EjbBean.getFullMethodName(method)));
        }
        return method;
    }

    public String getSkeletonName() {
        String className = this.getEJBClass().getName();
        int p = className.lastIndexOf(46);
        if (p > 0) {
            className = className.substring(p + 1);
        }
        String ejbName = this.getEJBName();
        String fullClassName = "_ejb." + ejbName + "." + className + "__EJB";
        return JavaClassGenerator.cleanClassName(fullClassName);
    }

    public GenClass assembleGenerator(String fullClassName) throws NoSuchMethodException, ConfigException {
        BeanAssembler assembler;
        int p = fullClassName.lastIndexOf(46);
        String className = fullClassName;
        if (p > 0) {
            className = fullClassName.substring(p + 1);
        }
        if ((assembler = this.createAssembler(fullClassName)) == null) {
            return null;
        }
        this.addImports(assembler);
        assembler.addHeaderComponent(this.getEJBClassWrapper(), fullClassName, this.getFullImplName());
        this.assembleMethods(assembler, fullClassName);
        this.assembleViews(assembler, fullClassName);
        for (PersistentDependency depend : this._dependList) {
            assembler.addDependency(depend);
        }
        assembler.addDependency(new ClassDependency(this._ejbClass.getJavaClass()));
        if (this._remoteHome != null) {
            assembler.addDependency(new ClassDependency(this._remoteHome.getJavaClass()));
        }
        for (ApiClass remote : this._remoteList) {
            assembler.addDependency(new ClassDependency(remote.getJavaClass()));
        }
        if (this._localHome != null) {
            assembler.addDependency(new ClassDependency(this._localHome.getJavaClass()));
        }
        for (ApiClass local : this._localList) {
            assembler.addDependency(new ClassDependency(local.getJavaClass()));
        }
        return assembler.getAssembledGenerator();
    }

    protected void addImports(BeanAssembler assembler) {
        assembler.addImport("javax.ejb.*");
        assembler.addImport("com.caucho.vfs.*");
        assembler.addImport("com.caucho.ejb.xa.EjbTransactionManager");
        assembler.addImport("com.caucho.ejb.xa.TransactionContext");
        assembler.addImport("com.caucho.ejb.AbstractContext");
    }

    protected BeanAssembler createAssembler(String fullClassName) {
        return null;
    }

    public void assembleBeanMethods() throws ConfigException {
        if (this.getEJBClassWrapper() == null) {
            return;
        }
        for (ApiMethod method : this.getEJBClassWrapper().getMethods()) {
            EjbBaseMethod ejbMethod = null;
            String name = method.getName();
            if (name.startsWith("ejb")) {
                ejbMethod = this.introspectEJBMethod(method);
                if (ejbMethod == null) continue;
                this._methodMap.put(ejbMethod.getMethod().getFullName(), ejbMethod);
                continue;
            }
            this.validateImplMethod(method);
        }
    }

    protected void assembleMethods(BeanAssembler assembler, String fullClassName) throws ConfigException {
        for (EjbBaseMethod method : this._methodMap.values()) {
            assembler.addMethod(method.assemble(assembler, fullClassName));
        }
    }

    protected void assembleViews(BeanAssembler assembler, String fullClassName) throws ConfigException {
    }

    protected EjbBaseMethod introspectEJBMethod(ApiMethod method) throws ConfigException {
        return null;
    }

    protected void validateImplMethod(ApiMethod method) throws ConfigException {
    }

    protected void assembleMethods(BeanAssembler assembler, ViewClass view, String contextClassName, ArrayList<ApiMethod> methods, String prefix) throws NoSuchMethodException {
        for (ApiMethod method : methods) {
            String className = method.getDeclaringClass().getName();
            String methodName = method.getName();
            Class[] args = method.getParameterTypes();
            if (className.startsWith("javax.ejb.") || methodName.equals("equals") && args.length == 1 && args[0].equals(Object.class) || methodName.equals("hashCode") && args.length == 0) continue;
            ApiMethod beanMethod = null;
            ApiClass ejbClass = this.getEJBClassWrapper();
            beanMethod = ejbClass.getMethod(method.getName(), method.getParameterTypes());
            if (beanMethod == null) {
                throw new NoSuchMethodException("Can't find public method " + method.getFullName());
            }
            CallChain call = new MethodCallChain(beanMethod.getMethod());
            call = view.createPoolChain(call, null);
            call = this.getTransactionChain(call, beanMethod, method, prefix);
            call = this.getSecurityChain(call, beanMethod, prefix);
            view.addMethod(new BaseMethod(method.getMethod(), call));
        }
    }

    protected void assembleHomeMethods(BeanAssembler assembler, BaseClass baseClass, String contextClassName, ApiClass homeClass, String prefix) throws NoSuchMethodException {
        for (ApiMethod method : homeClass.getMethods()) {
            String name;
            ApiMethod beanMethod;
            String className = method.getDeclaringClass().getName();
            String methodName = method.getName();
            if (className.startsWith("javax.ejb.")) continue;
            if (methodName.startsWith("create")) {
                beanMethod = null;
                name = "ejbCreate" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
                beanMethod = this.getEJBClassWrapper().getMethod(name, method.getParameterTypes());
                continue;
            }
            if (methodName.startsWith("find")) continue;
            beanMethod = null;
            name = "ejbHome" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
            beanMethod = this.getEJBClassWrapper().getMethod(name, method.getParameterTypes());
            CallChain call = new MethodCallChain(beanMethod.getMethod());
            call = this.getTransactionChain(call, beanMethod, method, prefix);
            call = this.getSecurityChain(call, beanMethod, prefix);
            baseClass.addMethod(new BaseMethod(method.getMethod(), call));
        }
    }

    public CallChain getTransactionChain(CallChain next, ApiMethod apiMethod, ApiMethod implMethod, String prefix) {
        return TransactionChain.create(next, this.getTransactionAttribute(implMethod, prefix), apiMethod, implMethod, this.isEJB3(), this._ejbConfig.getApplicationExceptions());
    }

    public CallChain getSecurityChain(CallChain next, ApiMethod method, String prefix) {
        EjbMethodPattern ejbMethod = this.getMethodPattern(method, prefix);
        ArrayList<String> roles = null;
        if (ejbMethod != null) {
            roles = ejbMethod.getRoles();
        }
        if (roles == null && (ejbMethod = this.getMethodPattern(null, prefix)) != null) {
            roles = ejbMethod.getRoles();
        }
        if (roles == null && (ejbMethod = this.getMethodPattern(method, null)) != null) {
            roles = ejbMethod.getRoles();
        }
        if (roles == null && (ejbMethod = this.getMethodPattern(null, null)) != null) {
            roles = ejbMethod.getRoles();
        }
        return next;
    }

    protected void validatePublicMethod(ApiMethod method) throws ConfigException {
        if (!method.isPublic()) {
            throw this.error(L.l("{0}: '{1}' must be public.", (Object)this._ejbClass.getName(), (Object)EjbBean.getFullMethodName(method)));
        }
        if (method.isStatic()) {
            throw this.error(L.l("{0}: '{1}' must not be static.", (Object)this._ejbClass.getName(), (Object)EjbBean.getFullMethodName(method)));
        }
    }

    public static boolean isEquiv(ApiMethod oldMethod, ApiMethod method) {
        Class[] param;
        if (!oldMethod.getName().equals(method.getName())) {
            return false;
        }
        Class[] oldParam = oldMethod.getParameterTypes();
        if (oldParam.length != (param = method.getParameterTypes()).length) {
            return false;
        }
        for (int j = 0; j < param.length; ++j) {
            if (param[j].equals(oldParam[j])) continue;
            return false;
        }
        return true;
    }

    public TransactionAttributeType getTransactionAttribute(ApiMethod method, String intf) {
        if (!this.isContainerTransaction()) {
            return null;
        }
        TransactionAttributeType transaction = TransactionAttributeType.REQUIRED;
        EjbMethodPattern ejbMethod = this.getMethodPattern(null, null);
        if (ejbMethod != null) {
            transaction = ejbMethod.getTransactionType();
        }
        if ((ejbMethod = this.getMethodPattern(method, null)) != null) {
            transaction = ejbMethod.getTransactionType();
        }
        if ((ejbMethod = this.getMethodPattern(method, intf)) != null) {
            transaction = ejbMethod.getTransactionType();
        }
        return transaction;
    }

    public ApiMethod getMethod(String methodName, Class[] paramTypes) {
        return EjbBean.getMethod(this.getEJBClassWrapper(), methodName, paramTypes);
    }

    public static ApiMethod getMethod(ApiClass cl, ApiMethod sourceMethod) {
        return EjbBean.getMethod(cl, sourceMethod.getName(), sourceMethod.getParameterTypes());
    }

    public static ApiMethod getMethod(ArrayList<ApiClass> apiList, String name, Class[] param) {
        for (int i = 0; i < apiList.size(); ++i) {
            ApiMethod method = EjbBean.getMethod(apiList.get(i), name, param);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public static ApiMethod getMethod(ApiClass cl, String name, Class[] param) {
        return cl.getMethod(name, param);
    }

    public boolean isCMP() {
        return false;
    }

    public boolean isCMP1() {
        return false;
    }

    public boolean isEJB3() {
        return !this.isCMP() && !this.isCMP1();
    }

    public static boolean isMatch(ApiMethod methodA, ApiMethod methodB) {
        if (methodA == methodB) {
            return true;
        }
        if (methodA == null || methodB == null) {
            return false;
        }
        return EjbBean.isMatch(methodA, methodB.getName(), methodB.getParameterTypes());
    }

    public static boolean isMatch(ApiMethod method, String name, Class[] param) {
        if (!method.getName().equals(name)) {
            return false;
        }
        Class[] mparam = method.getParameterTypes();
        if (mparam.length != param.length) {
            return false;
        }
        for (int j = 0; j < param.length; ++j) {
            if (mparam[j].equals(param[j])) continue;
            return false;
        }
        return true;
    }

    public static ApiMethod findMethod(MethodSignature sig, ApiClass cl, String intf) {
        if (cl == null) {
            return null;
        }
        for (ApiMethod method : cl.getMethods()) {
            if (!sig.isMatch(method, intf)) continue;
            return method;
        }
        return null;
    }

    public static ArrayList<ApiMethod> getMethods(ArrayList<ApiClass> apiList) {
        ArrayList<ApiMethod> methodList = new ArrayList<ApiMethod>();
        for (ApiClass api : apiList) {
            for (ApiMethod method : api.getMethods()) {
                if (methodList.contains(method)) continue;
                methodList.add(method);
            }
        }
        return methodList;
    }

    public static ApiMethod findMethod(ArrayList<ApiMethod> methods, ApiMethod method) {
        for (int i = 0; i < methods.size(); ++i) {
            ApiMethod oldMethod = methods.get(i);
            if (!oldMethod.equals(method)) continue;
            return oldMethod;
        }
        return null;
    }

    public static String getClassName(Class cl) {
        if (cl == null) {
            return "null";
        }
        if (cl.isArray()) {
            return EjbBean.getClassName(cl.getComponentType()) + "[]";
        }
        if (cl.getName().startsWith("java")) {
            int p = cl.getName().lastIndexOf(46);
            return cl.getName().substring(p + 1);
        }
        return cl.getName();
    }

    public static String getShortClassName(Class cl) {
        if (cl.isArray()) {
            return EjbBean.getShortClassName(cl.getComponentType()) + "[]";
        }
        return cl.getSimpleName();
    }

    public boolean classHasMethod(ApiMethod method, ApiClass cl) {
        try {
            ApiMethod match = cl.getMethod(method.getName(), method.getParameterTypes());
            return match != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void validateException(ApiMethod method, Class e) throws ConfigException {
        this.validateExceptions(method, new Class[]{e});
    }

    public void validateExceptions(ApiMethod method, Class[] exn) throws ConfigException {
        Class[] methodExceptions = method.getExceptionTypes();
        block0: for (int i = 0; i < exn.length; ++i) {
            if (RuntimeException.class.isAssignableFrom(exn[i])) continue;
            for (int j = 0; j < methodExceptions.length; ++j) {
                if (methodExceptions[j].isAssignableFrom(exn[i])) continue block0;
            }
            throw new ConfigException(L.l("{2}: '{0}' must throw {1}.", (Object)EjbBean.getFullMethodName(method), (Object)exn[i].getName(), (Object)method.getDeclaringClass().getName()));
        }
    }

    public void validateExceptions(ApiMethod caller, ApiMethod callee) throws ConfigException {
        Class[] exn = callee.getExceptionTypes();
        Class missing = this.findMissingException(caller, exn);
        if (missing != null) {
            throw this.error(L.l("{0}: '{1}' must throw {2}.", (Object)caller.getDeclaringClass().getName(), (Object)EjbBean.getFullMethodName(caller), (Object)EjbBean.getShortClassName(missing), (Object)caller.getDeclaringClass().getName()) + L.l(" {0} must throw all {1}.{2} exceptions.", (Object)caller.getName(), (Object)EjbBean.getShortClassName(callee.getDeclaringClass()), (Object)callee.getName()));
        }
    }

    Class findMissingException(ApiMethod method, Class[] exn) throws ConfigException {
        Class[] methodExceptions = method.getExceptionTypes();
        for (int i = 0; i < exn.length; ++i) {
            if (this.hasException(method, exn[i]) || RuntimeException.class.isAssignableFrom(exn[i])) continue;
            return exn[i];
        }
        return null;
    }

    public boolean hasException(ApiMethod method, Class exn) throws ConfigException {
        Class[] methodExceptions = method.getExceptionTypes();
        for (int j = 0; j < methodExceptions.length; ++j) {
            if (!methodExceptions[j].isAssignableFrom(exn)) continue;
            return true;
        }
        return false;
    }

    protected ApiMethod findFirstCreateMethod(ApiClass cl) throws ConfigException {
        for (ApiMethod method : cl.getMethods()) {
            if (!method.getName().startsWith("create")) continue;
            return method;
        }
        return null;
    }

    protected void introspectBean(ApiClass type, String defaultName) throws ConfigException {
        try {
            TransactionAttribute xa;
            Remote remote;
            this.setEJBClassWrapper(type);
            String name = this.getEJBName();
            if (name == null || name.equals("")) {
                name = defaultName;
            }
            if (name == null || name.equals("")) {
                String className = type.getName();
                int p = className.lastIndexOf(46);
                name = p > 0 ? className.substring(p + 1) : className;
            }
            this.setEJBName(name);
            Local local = type.getAnnotation(Local.class);
            if (local != null) {
                Class[] values = local.value();
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] instanceof Class) {
                        Class localClass = values[i];
                        this.setLocalWrapper(new ApiClass(localClass));
                        continue;
                    }
                    if (!(values[i] instanceof Class)) continue;
                    this.setLocal(values[i]);
                }
            }
            if ((remote = type.getAnnotation(Remote.class)) != null) {
                Class<?>[] ifs;
                Class[] values = remote.value();
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] instanceof Class) {
                        Class remoteClass = values[i];
                        this.setRemoteWrapper(new ApiClass(remoteClass));
                        continue;
                    }
                    if (!(values[i] instanceof Class)) continue;
                    this.setRemote(values[i]);
                }
                if (values.length == 0 && (ifs = type.getJavaClass().getInterfaces()).length == 1) {
                    this.setRemoteWrapper(new ApiClass(ifs[0]));
                }
            }
            if ((xa = type.getAnnotation(TransactionAttribute.class)) != null) {
                MethodSignature sig = new MethodSignature();
                sig.setMethodName("*");
                EjbMethodPattern pattern = this.createMethod(sig);
                this.setPatternTransaction(pattern, xa);
            }
            this.configureMethods(type);
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.createLine((String)this._location, (Throwable)e);
        }
    }

    private void configureMethods(ApiClass type) throws ConfigException {
        for (ApiMethod method : type.getMethods()) {
            Timeout timeout;
            AroundInvoke aroundInvoke;
            TransactionAttribute xa = method.getAnnotation(TransactionAttribute.class);
            if (xa != null) {
                EjbMethodPattern pattern = this.createMethod(this.getSignature(method));
                this.setPatternTransaction(pattern, xa);
            }
            if ((aroundInvoke = method.getAnnotation(AroundInvoke.class)) != null) {
                this._aroundInvokeMethodName = method.getName();
            }
            if ((timeout = method.getAnnotation(Timeout.class)) == null) continue;
            this._timeoutMethodName = method.getName();
        }
    }

    private void setPatternTransaction(EjbMethodPattern pattern, TransactionAttribute xa) throws ConfigException {
        TransactionAttributeType xaType = xa.value();
        pattern.setTransaction(xaType);
    }

    private MethodSignature getSignature(ApiMethod method) throws ConfigException {
        MethodSignature sig = new MethodSignature();
        sig.setMethodName(method.getName());
        Class[] paramTypes = method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            sig.addParam(paramTypes[i].getName());
        }
        return sig;
    }

    public static String getFullMethodName(ApiMethod method) {
        return EjbBean.getFullMethodName(method.getName(), method.getParameterTypes());
    }

    public static String getFullMethodName(String methodName, Class[] params) {
        String name = methodName + "(";
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                name = name + ", ";
            }
            name = name + params[i].getSimpleName();
        }
        return name + ")";
    }

    public ConfigException error(String msg) {
        if (this._isInit && this._filename != null) {
            return new LineConfigException(this._filename, this._line, msg);
        }
        if (this._isInit && !"".equals(this._location)) {
            return new LineConfigException(this._location + msg);
        }
        return new ConfigException(msg);
    }

    public RuntimeException error(Exception e) {
        if (this._filename != null) {
            return LineConfigException.create((String)this._filename, (int)this._line, (Throwable)e);
        }
        if (this._location != null) {
            return ConfigException.createLine((String)this._location, (Throwable)e);
        }
        return ConfigException.create((Throwable)e);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._ejbName + "]";
    }
}

