/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.DependencyBean;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.util.L10N;
import com.caucho.vfs.PersistentDependency;
import java.util.ArrayList;
import javax.annotation.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbBeanConfigProxy
implements DependencyBean {
    private static final L10N L = new L10N(EjbBeanConfigProxy.class);
    private final EjbConfig _config;
    private final String _ejbModuleName;
    private String _ejbName;
    private String _filename = "";
    private String _location = "";
    private ContainerProgram _program = new ContainerProgram();
    private EjbBean _bean;
    ArrayList<PersistentDependency> _dependList = new ArrayList();

    public EjbBeanConfigProxy(EjbConfig config, String ejbModuleName) {
        this._config = config;
        this._ejbModuleName = ejbModuleName;
    }

    public EjbConfig getConfig() {
        return this._config;
    }

    public String getEJBModuleName() {
        return this._ejbModuleName;
    }

    public void setConfigLocation(String filename, int line) {
        this._filename = filename;
        this._location = filename + ":" + line + ": ";
    }

    public String getLocation() {
        return this._location;
    }

    public String getFilename() {
        return this._filename;
    }

    public void setEJBName(String ejbName) {
        this._ejbName = ejbName;
    }

    public String getEJBName() {
        return this._ejbName;
    }

    @Override
    public void addDependency(PersistentDependency depend) {
        if (!this._dependList.contains(depend)) {
            this._dependList.add(depend);
        }
    }

    public ArrayList<PersistentDependency> getDependencyList() {
        return this._dependList;
    }

    public void addBuilderProgram(ConfigProgram program) {
        this._program.addProgram(program);
    }

    public ConfigProgram getBuilderProgram() {
        return this._program;
    }

    @PostConstruct
    public void init() throws Throwable {
        this.getConfig().addProxy(this);
    }

    public EjbBean getBean() {
        return this._bean;
    }
}

