/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.config.types.FileSetType;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.amber.AmberConfig;
import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.cfg.ApplicationExceptionConfig;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbBeanConfigProxy;
import com.caucho.ejb.cfg.EjbMessageBean;
import com.caucho.ejb.cfg.EjbStatefulBean;
import com.caucho.ejb.cfg.EjbStatelessBean;
import com.caucho.ejb.cfg.FunctionSignature;
import com.caucho.ejb.cfg.Interceptor;
import com.caucho.ejb.cfg.InterceptorBinding;
import com.caucho.ejb.cfg.MessageDestination;
import com.caucho.ejb.cfg21.CmpRelation;
import com.caucho.ejb.cfg21.CmpRelationRole;
import com.caucho.ejb.cfg21.CmrManyToMany;
import com.caucho.ejb.cfg21.CmrManyToOne;
import com.caucho.ejb.cfg21.CmrMap;
import com.caucho.ejb.cfg21.CmrOneToMany;
import com.caucho.ejb.cfg21.CmrRelation;
import com.caucho.ejb.cfg21.EjbEntityBean;
import com.caucho.ejb.manager.EjbContainer;
import com.caucho.ejb.ql.FunExpr;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.ejb.MessageDriven;
import javax.ejb.Stateful;
import javax.ejb.Stateless;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbConfig {
    private static final L10N L = new L10N(EjbConfig.class);
    private static final Logger log = Log.open(EjbConfig.class);
    private final EjbContainer _ejbContainer;
    private ArrayList<FileSetType> _fileSetList = new ArrayList();
    private HashMap<String, EjbBean> _cfgBeans = new HashMap();
    private ArrayList<CmpRelation> _relations = new ArrayList();
    private ArrayList<EjbBean> _pendingBeans = new ArrayList();
    private ArrayList<EjbBean> _deployingBeans = new ArrayList();
    private ArrayList<EjbBeanConfigProxy> _proxyList = new ArrayList();
    private ArrayList<FunctionSignature> _functions = new ArrayList();
    private String _booleanTrue = "1";
    private String _booleanFalse = "0";
    private boolean _isAllowPOJO;
    private HashMap<String, MessageDestination> _messageDestinations;
    private ArrayList<Interceptor> _cfgInterceptors = new ArrayList();
    private ArrayList<InterceptorBinding> _cfgInterceptorBindings = new ArrayList();
    private ArrayList<ApplicationExceptionConfig> _cfgApplicationExceptions = new ArrayList();

    public EjbConfig(EjbContainer ejbContainer) {
        this._ejbContainer = ejbContainer;
        this._functions.addAll(FunExpr.getStandardFunctions());
    }

    public void addFileSet(FileSetType fileSet) {
        if (this._fileSetList.contains(fileSet)) {
            return;
        }
        this._fileSetList.add(fileSet);
        for (Path path : fileSet.getPaths()) {
            this.addEjbPath(path);
        }
    }

    public void addEjbPath(Path path) throws ConfigException {
        throw new UnsupportedOperationException();
    }

    public void addProxy(EjbBeanConfigProxy proxy) {
        this._proxyList.add(proxy);
    }

    public String getSchema() {
        return "com/caucho/ejb/cfg/resin-ejb.rnc";
    }

    public EjbContainer getEjbContainer() {
        return this._ejbContainer;
    }

    public void setBooleanTrue(String trueLiteral) {
        this._booleanTrue = trueLiteral;
    }

    public String getBooleanTrue() {
        return this._booleanTrue;
    }

    public void setBooleanFalse(String falseLiteral) {
        this._booleanFalse = falseLiteral;
    }

    public String getBooleanFalse() {
        return this._booleanFalse;
    }

    public EjbBean getBeanConfig(String name) {
        assert (name != null);
        return this._cfgBeans.get(name);
    }

    public void setBeanConfig(String name, EjbBean bean) {
        if (name == null || bean == null) {
            throw new NullPointerException();
        }
        EjbBean oldBean = this._cfgBeans.get(name);
        if (oldBean == bean) {
            return;
        }
        if (oldBean != null) {
            throw new IllegalStateException(L.l("{0}: duplicate bean '{1}' old ejb-class={2} new ejb-class={3}", (Object)this, (Object)name, (Object)oldBean.getEJBClass().getName(), (Object)bean.getEJBClass().getName()));
        }
        this._pendingBeans.add(bean);
        this._cfgBeans.put(name, bean);
    }

    public Interceptor getInterceptor(String className) {
        assert (className != null);
        for (Interceptor interceptor : this._cfgInterceptors) {
            if (!interceptor.getInterceptorClass().equals(className)) continue;
            return interceptor;
        }
        return null;
    }

    public void addInterceptor(Interceptor interceptor) {
        if (interceptor == null) {
            throw new NullPointerException();
        }
        this._cfgInterceptors.add(interceptor);
    }

    public InterceptorBinding getInterceptorBinding(String ejbName, boolean isExcludeDefault) {
        assert (ejbName != null);
        for (InterceptorBinding binding : this._cfgInterceptorBindings) {
            if (!binding.getEjbName().equals(ejbName)) continue;
            return binding;
        }
        for (InterceptorBinding binding : this._cfgInterceptorBindings) {
            if (!binding.getEjbName().equals("*") || isExcludeDefault) continue;
            return binding;
        }
        return null;
    }

    public void addApplicationException(ApplicationExceptionConfig applicationException) {
        this._cfgApplicationExceptions.add(applicationException);
    }

    public ArrayList<ApplicationExceptionConfig> getApplicationExceptions() {
        return this._cfgApplicationExceptions;
    }

    public void addInterceptorBinding(InterceptorBinding interceptorBinding) {
        this._cfgInterceptorBindings.add(interceptorBinding);
    }

    public void addMessageDestination(MessageDestination messageDestination) {
        if (this._messageDestinations == null) {
            this._messageDestinations = new HashMap();
        }
        String name = messageDestination.getMessageDestinationName();
        this._messageDestinations.put(name, messageDestination);
    }

    public MessageDestination getMessageDestination(String name) {
        if (this._messageDestinations == null) {
            return null;
        }
        return this._messageDestinations.get(name);
    }

    public void setAllowPOJO(boolean allowPOJO) {
        this._isAllowPOJO = allowPOJO;
    }

    public boolean isAllowPOJO() {
        return this._isAllowPOJO;
    }

    public void addIntrospectableClass(String className) {
        try {
            ClassLoader loader = this._ejbContainer.getIntrospectionClassLoader();
            Class<?> type = Class.forName(className, false, loader);
            if (this.findBeanByType(type) != null) {
                return;
            }
            if (type.isAnnotationPresent(Stateless.class)) {
                EjbStatelessBean bean = new EjbStatelessBean(this, "resin-ejb");
                bean.setEJBClass(type);
                bean.setAllowPOJO(true);
                this.setBeanConfig(bean.getEJBName(), bean);
            } else if (type.isAnnotationPresent(Stateful.class)) {
                EjbStatefulBean bean = new EjbStatefulBean(this, "resin-ejb");
                bean.setAllowPOJO(true);
                bean.setEJBClass(type);
                this.setBeanConfig(bean.getEJBName(), bean);
            } else if (type.isAnnotationPresent(MessageDriven.class)) {
                EjbMessageBean bean = new EjbMessageBean(this, "resin-ejb");
                bean.setAllowPOJO(true);
                bean.setEJBClass(type);
                this.setBeanConfig(bean.getEJBName(), bean);
            }
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public EjbEntityBean findEntityBySchema(String schemaName) {
        for (EjbBean bean : this._cfgBeans.values()) {
            EjbEntityBean entity;
            if (!(bean instanceof EjbEntityBean) || !schemaName.equals((entity = (EjbEntityBean)bean).getAbstractSchemaName())) continue;
            return entity;
        }
        return null;
    }

    public EjbBean findBeanByType(Class type) {
        for (EjbBean bean : this._cfgBeans.values()) {
            if (!type.getName().equals(bean.getEJBClass().getName())) continue;
            return bean;
        }
        return null;
    }

    public EjbEntityBean findEntityByLocal(Class cl) {
        for (EjbBean bean : this._cfgBeans.values()) {
            if (!(bean instanceof EjbEntityBean)) continue;
            EjbEntityBean entity = (EjbEntityBean)bean;
            for (ApiClass apiClass : entity.getLocalList()) {
                if (!apiClass.getJavaClass().equals(cl)) continue;
                return entity;
            }
        }
        return null;
    }

    public CmpRelation addRelation(String relationName, String sourceEJB, String sourceField) {
        CmpRelation relation = this.findRelation(relationName, sourceEJB, sourceField);
        if (relation != null) {
            return relation;
        }
        relation = new CmpRelation();
        relation.setName(relationName);
        relation.setSourceEJB(sourceEJB);
        relation.setSourceField(sourceField);
        this._relations.add(relation);
        return relation;
    }

    public CmpRelation findRelation(String relationName, String sourceEJB, String sourceField) {
        for (int i = 0; i < this._relations.size(); ++i) {
            CmpRelation relation = this._relations.get(i);
            if (relationName != null && relationName.equals(relation.getName())) {
                return relation;
            }
            if (!relation.getSourceEJB().equals(sourceEJB) || !relation.getSourceField().equals(sourceField)) continue;
            return relation;
        }
        return null;
    }

    public void addRelation(CmpRelation rel) throws ConfigException {
        CmpRelation oldRel = this.findRelation(rel.getName(), rel.getSourceEJB(), rel.getSourceField());
        if (oldRel == null) {
            this._relations.add(rel);
            return;
        }
        if (!rel.getTargetEJB().equals(oldRel.getTargetEJB())) {
            throw new ConfigException(L.l("relationship '{0}.{1}' target EJB '{2}' does not match old target EJB '{3}' from {4}", (Object)rel.getSourceEJB(), (Object)rel.getSourceField(), (Object)rel.getTargetEJB(), (Object)oldRel.getTargetEJB(), (Object)oldRel.getLocation()));
        }
        if (!(rel.getTargetField() == oldRel.getTargetField() || rel.getTargetField() != null && rel.getTargetField().equals(oldRel.getTargetField()))) {
            throw new ConfigException(L.l("relationship '{0}.{1}' target field '{2}' does not match old target field '{3}' from {4}", (Object)rel.getSourceEJB(), (Object)rel.getSourceField(), (Object)rel.getTargetEJB(), (Object)oldRel.getTargetEJB(), (Object)oldRel.getLocation()));
        }
        oldRel.merge(rel);
    }

    public CmpRelation[] getRelations() {
        return this._relations.toArray(new CmpRelation[this._relations.size()]);
    }

    public void addFunction(FunctionSignature sig, String sql) {
        this._functions.add(sig);
    }

    public ArrayList<FunctionSignature> getFunctions() {
        return this._functions;
    }

    public void configure() throws ConfigException {
        this.findConfigurationFiles();
        try {
            ArrayList<EjbBean> beanConfig = new ArrayList<EjbBean>(this._pendingBeans);
            this._pendingBeans.clear();
            this._deployingBeans.addAll(beanConfig);
            EnvironmentClassLoader parentLoader = this._ejbContainer.getClassLoader();
            Path workDir = this._ejbContainer.getWorkDir();
            JavaClassGenerator javaGen = new JavaClassGenerator();
            javaGen.setWorkDir(workDir);
            javaGen.setParentLoader(parentLoader);
            this.configureRelations();
            for (EjbBeanConfigProxy proxy : this._proxyList) {
                EjbBean bean = this._cfgBeans.get(proxy.getEJBName());
                if (bean == null) continue;
                proxy.getBuilderProgram().configure(bean);
            }
            for (EjbBean bean : beanConfig) {
                bean.init();
            }
            Collections.sort(beanConfig, new BeanComparator());
            AmberConfig amberConfig = new AmberConfig(this);
            for (EjbBean bean : beanConfig) {
                bean.configureAmber(amberConfig);
            }
            amberConfig.configureRelations();
            if (this._ejbContainer.isAutoCompile()) {
                amberConfig.generate(javaGen);
            }
            for (EjbBean bean : beanConfig) {
                bean.generate(javaGen, this._ejbContainer.isAutoCompile());
            }
            javaGen.compilePendingJava();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    private void findConfigurationFiles() throws ConfigException {
        for (FileSetType fileSet : this._fileSetList) {
            for (Path path : fileSet.getPaths()) {
                this.addEjbPath(path);
            }
        }
    }

    public void deploy() throws ConfigException {
        try {
            EnvironmentClassLoader parentLoader = this._ejbContainer.getClassLoader();
            Path workDir = this._ejbContainer.getWorkDir();
            JavaClassGenerator javaGen = new JavaClassGenerator();
            javaGen.setWorkDir(workDir);
            javaGen.setParentLoader(parentLoader);
            ArrayList<EjbBean> deployingBeans = new ArrayList<EjbBean>(this._deployingBeans);
            this._deployingBeans.clear();
            this.deployBeans(deployingBeans, javaGen);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployBeans(ArrayList<EjbBean> beanConfig, JavaClassGenerator javaGen) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._ejbContainer.getClassLoader());
            ArrayList<EjbBean> beanList = new ArrayList<EjbBean>();
            for (EjbBean bean : beanConfig) {
                if (beanList.contains(bean)) continue;
                AbstractServer server = this.initBean(bean, javaGen);
                ArrayList<String> dependList = bean.getBeanDependList();
                for (String depend : dependList) {
                    for (EjbBean b : beanConfig) {
                        if (bean == b || !depend.equals(b.getEJBName())) continue;
                        beanList.add(b);
                        AbstractServer dependServer = this.initBean(b, javaGen);
                        this.initResources(b, dependServer);
                        thread.setContextClassLoader(server.getClassLoader());
                    }
                }
                this.initResources(bean, server);
            }
            Object var16_15 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    private AbstractServer initBean(EjbBean bean, JavaClassGenerator javaGen) throws Exception {
        AbstractServer server = bean.deployServer(this._ejbContainer, javaGen);
        server.init();
        return server;
    }

    private void initResources(EjbBean bean, AbstractServer server) throws Exception {
        this._ejbContainer.addServer(server);
    }

    protected void configureRelations() throws ConfigException {
        for (CmpRelation relation : this._relations) {
            try {
                CmrRelation dstRel;
                CmrRelation dstRel2;
                CmrRelation srcRel;
                CmpRelationRole sourceRole = relation.getSourceRole();
                CmpRelationRole targetRole = relation.getTargetRole();
                String sourceEJB = sourceRole.getEJBName();
                EjbEntityBean sourceEntity = (EjbEntityBean)this._cfgBeans.get(sourceEJB);
                if (sourceEntity == null) {
                    throw new ConfigException(L.l("'{0}' is an unknown EJB bean.", (Object)sourceEJB));
                }
                String sourceField = sourceRole.getFieldName();
                ApiMethod sourceMethod = sourceEntity.getFieldGetter(sourceField);
                ApiMethod sourceMapMethod = null;
                if (sourceField != null) {
                    sourceMapMethod = this.getMapMethod(sourceEntity, sourceField);
                }
                if (sourceField != null && sourceMethod == null && sourceMapMethod == null) {
                    throw new ConfigException(L.l("{0}: relation field '{1}' does not have a corresponding getter method.  cmr-relations must define abstract getter methods returning a local interface.", (Object)sourceEntity.getEJBClass().getName(), (Object)sourceField));
                }
                String targetEJB = targetRole.getEJBName();
                EjbEntityBean targetEntity = (EjbEntityBean)this._cfgBeans.get(targetEJB);
                if (targetEntity == null) {
                    throw new ConfigException(L.l("'{0}' is an unknown EJB bean.", (Object)targetEJB));
                }
                String targetField = targetRole.getFieldName();
                ApiMethod targetMethod = targetEntity.getFieldGetter(targetField);
                ApiMethod targetMapMethod = null;
                if (targetField != null) {
                    targetMapMethod = this.getMapMethod(targetEntity, targetField);
                }
                if (targetField != null && targetMethod == null && targetMapMethod == null) {
                    throw new ConfigException(L.l("{0}: relation field '{1}' does not have a corresponding getter method.  cmr-relations must define abstract getter methods returning a local interface.", (Object)targetEntity.getEJBClass().getName(), (Object)targetField));
                }
                boolean sourceOneToMany = false;
                boolean sourceManyToOne = false;
                boolean sourceMap = false;
                if (sourceMethod != null) {
                    if (Collection.class.isAssignableFrom(sourceMethod.getReturnType())) {
                        sourceOneToMany = true;
                    } else if (Map.class.isAssignableFrom(sourceMethod.getReturnType())) {
                        sourceMap = true;
                    } else {
                        sourceManyToOne = true;
                    }
                }
                boolean targetOneToMany = false;
                boolean targetManyToOne = false;
                boolean targetMap = false;
                if (targetMapMethod != null) {
                    targetMap = true;
                }
                if (targetMethod != null) {
                    if (Collection.class.isAssignableFrom(targetMethod.getReturnType())) {
                        targetOneToMany = true;
                    } else if (Map.class.isAssignableFrom(targetMethod.getReturnType())) {
                        targetMap = true;
                    } else {
                        targetManyToOne = true;
                    }
                }
                if (sourceMap) {
                    this.createMap(targetEntity, targetField, targetRole, sourceEntity, sourceField, sourceRole, sourceMapMethod);
                    continue;
                }
                if (targetMap) {
                    this.createMap(sourceEntity, sourceField, sourceRole, targetEntity, targetField, targetRole, targetMapMethod);
                    continue;
                }
                if (sourceOneToMany && targetManyToOne) {
                    srcRel = new CmrOneToMany(sourceEntity, sourceField, targetEntity, targetField);
                    ((CmrOneToMany)srcRel).setSQLColumns(sourceRole.getSQLColumns());
                    ((CmrOneToMany)srcRel).setOrderBy(sourceRole.getOrderBy());
                    sourceEntity.addRelation(srcRel);
                    dstRel2 = new CmrManyToOne(targetEntity, targetField, sourceEntity);
                    ((CmrManyToOne)dstRel2).setSQLColumns(targetRole.getSQLColumns());
                    ((CmrManyToOne)dstRel2).setSourceCascadeDelete(targetRole.getCascadeDelete());
                    ((CmrManyToOne)dstRel2).setTargetCascadeDelete(sourceRole.getCascadeDelete());
                    targetEntity.addRelation(dstRel2);
                    srcRel.setTargetRelation(dstRel2);
                    dstRel2.setTargetRelation(srcRel);
                    continue;
                }
                if (sourceOneToMany && targetOneToMany) {
                    srcRel = new CmrManyToMany(sourceEntity, sourceField, targetEntity, targetField);
                    srcRel.setLocation(relation.getLocation());
                    srcRel.setRelationName(relation.getName());
                    ((CmrManyToMany)srcRel).setSQLTable(relation.getSQLTable());
                    ((CmrManyToMany)srcRel).setOrderBy(sourceRole.getOrderBy());
                    ((CmrManyToMany)srcRel).setKeySQLColumns(sourceRole.getSQLColumns());
                    ((CmrManyToMany)srcRel).setDstSQLColumns(targetRole.getSQLColumns());
                    sourceEntity.addRelation(srcRel);
                    dstRel2 = new CmrManyToMany(targetEntity, targetField, sourceEntity, sourceField);
                    dstRel2.setLocation(relation.getLocation());
                    dstRel2.setRelationName(relation.getName());
                    ((CmrManyToMany)dstRel2).setSQLTable(relation.getSQLTable());
                    ((CmrManyToMany)dstRel2).setOrderBy(targetRole.getOrderBy());
                    ((CmrManyToMany)dstRel2).setKeySQLColumns(targetRole.getSQLColumns());
                    ((CmrManyToMany)dstRel2).setDstSQLColumns(sourceRole.getSQLColumns());
                    targetEntity.addRelation(dstRel2);
                    continue;
                }
                if (sourceOneToMany) {
                    srcRel = new CmrManyToMany(sourceEntity, sourceField, targetEntity, targetField);
                    srcRel.setLocation(relation.getLocation());
                    if (relation.getName() != null) {
                        srcRel.setRelationName(relation.getName());
                    } else if (relation.getSQLTable() != null) {
                        srcRel.setRelationName(relation.getSQLTable());
                    } else {
                        srcRel.setRelationName(sourceField);
                    }
                    if (relation.getSQLTable() != null || relation.getName() != null) {
                        ((CmrManyToMany)srcRel).setSQLTable(relation.getSQLTable());
                    } else {
                        ((CmrManyToMany)srcRel).setSQLTable(sourceField);
                    }
                    ((CmrManyToMany)srcRel).setOrderBy(sourceRole.getOrderBy());
                    ((CmrManyToMany)srcRel).setKeySQLColumns(sourceRole.getSQLColumns());
                    ((CmrManyToMany)srcRel).setDstSQLColumns(targetRole.getSQLColumns());
                    ((CmrManyToMany)srcRel).setTargetUnique("One".equals(sourceRole.getMultiplicity()));
                    sourceEntity.addRelation(srcRel);
                    continue;
                }
                if (sourceManyToOne && targetManyToOne) {
                    if (relation.getSQLTable() != null) {
                        throw new ConfigException(L.l("cmr-field '{0}' may not have a sql-table '{1}'.  one-to-one relations do not have association tables.", (Object)sourceField, (Object)relation.getSQLTable()));
                    }
                    srcRel = new CmrManyToOne(sourceEntity, sourceField, targetEntity);
                    srcRel.setLocation(relation.getLocation());
                    ((CmrManyToOne)srcRel).setSQLColumns(sourceRole.getSQLColumns());
                    ((CmrManyToOne)srcRel).setSourceCascadeDelete(sourceRole.getCascadeDelete());
                    ((CmrManyToOne)srcRel).setTargetCascadeDelete(targetRole.getCascadeDelete());
                    sourceEntity.addRelation(srcRel);
                    dstRel2 = new CmrManyToOne(targetEntity, targetField, sourceEntity);
                    dstRel2.setLocation(relation.getLocation());
                    ((CmrManyToOne)dstRel2).setSQLColumns(targetRole.getSQLColumns());
                    targetEntity.addRelation(dstRel2);
                    if ((sourceRole.getSQLColumns() == null || sourceRole.getSQLColumns().length == 0) && targetRole.getSQLColumns() != null && targetRole.getSQLColumns().length > 0) {
                        ((CmrManyToOne)srcRel).setDependent(true);
                        ((CmrManyToOne)dstRel2).setSourceCascadeDelete(targetRole.getCascadeDelete());
                        ((CmrManyToOne)dstRel2).setTargetCascadeDelete(sourceRole.getCascadeDelete());
                    }
                    if (targetRole.getSQLColumns() == null || targetRole.getSQLColumns().length == 0) {
                        ((CmrManyToOne)dstRel2).setDependent(true);
                        ((CmrManyToOne)srcRel).setSourceCascadeDelete(sourceRole.getCascadeDelete());
                        ((CmrManyToOne)srcRel).setTargetCascadeDelete(targetRole.getCascadeDelete());
                    }
                    srcRel.setTargetRelation(dstRel2);
                    dstRel2.setTargetRelation(srcRel);
                    continue;
                }
                if (sourceManyToOne && targetOneToMany) {
                    srcRel = new CmrManyToOne(sourceEntity, sourceField, targetEntity);
                    srcRel.setLocation(relation.getLocation());
                    ((CmrManyToOne)srcRel).setSQLColumns(sourceRole.getSQLColumns());
                    sourceEntity.addRelation(srcRel);
                    dstRel2 = new CmrOneToMany(targetEntity, targetField, sourceEntity, sourceField);
                    dstRel2.setLocation(relation.getLocation());
                    ((CmrOneToMany)dstRel2).setSQLColumns(sourceRole.getSQLColumns());
                    ((CmrOneToMany)dstRel2).setOrderBy(targetRole.getOrderBy());
                    targetEntity.addRelation(dstRel2);
                    srcRel.setTargetRelation(dstRel2);
                    dstRel2.setTargetRelation(srcRel);
                    if (!targetRole.getCascadeDelete() || !"Many".equals(sourceRole.getMultiplicity())) continue;
                    throw new ConfigException(L.l("'{0}' may not set cascade-delete because '{1}' has multiplicity 'Many'", (Object)targetField, (Object)sourceField));
                }
                if (sourceManyToOne) {
                    srcRel = new CmrManyToOne(sourceEntity, sourceField, targetEntity);
                    ((CmrManyToOne)srcRel).setSQLColumns(sourceRole.getSQLColumns());
                    ((CmrManyToOne)srcRel).setSourceCascadeDelete(sourceRole.getCascadeDelete());
                    ((CmrManyToOne)srcRel).setTargetCascadeDelete(targetRole.getCascadeDelete());
                    sourceEntity.addRelation(srcRel);
                    continue;
                }
                if (targetManyToOne) {
                    dstRel = new CmrManyToOne(targetEntity, targetField, sourceEntity);
                    ((CmrManyToOne)dstRel).setSQLColumns(targetRole.getSQLColumns());
                    ((CmrManyToOne)dstRel).setSourceCascadeDelete(targetRole.getCascadeDelete());
                    ((CmrManyToOne)dstRel).setTargetCascadeDelete(sourceRole.getCascadeDelete());
                    targetEntity.addRelation(dstRel);
                    continue;
                }
                if (targetOneToMany) {
                    dstRel = new CmrOneToMany(targetEntity, targetField, sourceEntity, sourceField);
                    ((CmrOneToMany)dstRel).setSQLColumns(targetRole.getSQLColumns());
                    ((CmrOneToMany)dstRel).setOrderBy(targetRole.getOrderBy());
                    targetEntity.addRelation(dstRel);
                    continue;
                }
                throw new ConfigException(L.l("unsupported relation"));
            }
            catch (LineConfigException e) {
                throw e;
            }
            catch (ConfigException e) {
                throw new LineConfigException(relation.getLocation() + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void createMap(EjbEntityBean sourceEntity, String idField, CmpRelationRole sourceRole, EjbEntityBean targetEntity, String targetField, CmpRelationRole targetRole, ApiMethod targetMapMethod) throws ConfigException {
        CmrManyToOne srcRel = new CmrManyToOne(sourceEntity, idField, targetEntity);
        srcRel.setSQLColumns(sourceRole.getSQLColumns());
        sourceEntity.addRelation(srcRel);
        CmrMap map = new CmrMap(targetEntity, targetField, sourceEntity, srcRel);
        map.setMapMethod(targetMapMethod);
        targetEntity.addRelation(map);
    }

    public ApiMethod getMapMethod(EjbEntityBean entityBean, String field) {
        String methodName = "get" + Character.toUpperCase(field.charAt(0)) + field.substring(1);
        for (ApiMethod method : entityBean.getEJBClassWrapper().getMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != 1 || "void".equals(method.getReturnType().getName()) || !method.isAbstract()) continue;
            return method;
        }
        return null;
    }

    public String toString() {
        String id = this._ejbContainer.getClassLoader().getId();
        return this.getClass().getSimpleName() + "[" + id + "]";
    }

    static class BeanComparator
    implements Comparator {
        BeanComparator() {
        }

        public int compare(Object a, Object b) {
            if (a == b) {
                return 0;
            }
            EjbBean beanA = (EjbBean)a;
            EjbBean beanB = (EjbBean)b;
            if (!(a instanceof EjbEntityBean) && !(b instanceof EjbEntityBean)) {
                return beanA.getEJBName().compareTo(beanB.getEJBName());
            }
            if (!(a instanceof EjbEntityBean)) {
                return 1;
            }
            if (!(b instanceof EjbEntityBean)) {
                return -1;
            }
            EjbEntityBean entityB = (EjbEntityBean)b;
            EjbEntityBean entityA = (EjbEntityBean)a;
            if (entityB.dependsOn(entityA)) {
                return -1;
            }
            if (entityA.dependsOn(entityB)) {
                return 1;
            }
            return entityA.getEJBName().compareTo(entityB.getEJBName());
        }
    }
}

