/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.EjbJar;
import com.caucho.ejb.cfg.EjbRootConfig;
import com.caucho.ejb.manager.EjbContainer;
import com.caucho.loader.Environment;
import com.caucho.util.L10N;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EjbConfigManager
extends EjbConfig {
    private static final L10N L = new L10N(EjbConfigManager.class);
    private static final Logger log = Logger.getLogger(EjbConfigManager.class.getName());
    private HashMap<Path, EjbRootConfig> _rootConfigMap = new HashMap();
    private ArrayList<EjbRootConfig> _rootPendingList = new ArrayList();
    private ArrayList<Path> _pathPendingList = new ArrayList();

    public EjbConfigManager(EjbContainer ejbContainer) {
        super(ejbContainer);
    }

    public EjbRootConfig createRootConfig(Path root) {
        EjbRootConfig rootConfig = this._rootConfigMap.get(root);
        if (rootConfig == null) {
            rootConfig = new EjbRootConfig(root);
            this._rootConfigMap.put(root, rootConfig);
            this._rootPendingList.add(rootConfig);
            Path ejbJar = root.lookup("META-INF/ejb-jar.xml");
            if (ejbJar.canRead()) {
                this.addEjbPath(ejbJar);
            }
        }
        return rootConfig;
    }

    public void start() {
        ArrayList<EjbRootConfig> pendingList = new ArrayList<EjbRootConfig>(this._rootPendingList);
        this._rootPendingList.clear();
        for (EjbRootConfig rootConfig : pendingList) {
            for (String className : rootConfig.getClassNameList()) {
                this.addIntrospectableClass(className);
            }
        }
        this.configurePaths();
        this.configure();
        this.deploy();
    }

    public void addEjbPath(Path path) {
        if (this._pathPendingList.contains(path)) {
            return;
        }
        this._pathPendingList.add(path);
    }

    private void configurePaths() {
        ArrayList<Path> pathList = new ArrayList<Path>(this._pathPendingList);
        this._pathPendingList.clear();
        for (Path path : pathList) {
            if (path.getScheme().equals("jar")) {
                path.setUserPath(path.getURL());
            }
            Environment.addDependency(path);
            String ejbModuleName = path instanceof JarPath ? ((JarPath)path).getContainer().getPath() : path.getPath();
            EjbJar ejbJar = new EjbJar(this, ejbModuleName);
            try {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this + " reading " + path.getURL());
                }
                new Config().configure((Object)ejbJar, path, this.getSchema());
            }
            catch (ConfigException e) {
                throw e;
            }
            catch (Exception e) {
                throw ConfigException.create((Throwable)e);
            }
        }
    }
}

