/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.types.DescriptionGroupConfig;
import com.caucho.config.types.Signature;
import com.caucho.ejb.cfg.AssemblyDescriptor;
import com.caucho.ejb.cfg.BooleanLiteral;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.EjbEnterpriseBeans;
import com.caucho.ejb.cfg.EjbMethodPattern;
import com.caucho.ejb.cfg.FunctionSignature;
import com.caucho.ejb.cfg.Interceptors;
import com.caucho.ejb.cfg.MethodSignature;
import com.caucho.ejb.cfg21.CmpRelation;
import com.caucho.util.L10N;
import java.util.ArrayList;
import javax.annotation.PostConstruct;

public class EjbJar
extends DescriptionGroupConfig {
    private static final L10N L = new L10N(EjbJar.class);
    private final EjbConfig _config;
    private final String _ejbModuleName;
    private boolean _isMetadataComplete;

    public EjbJar(EjbConfig config, String ejbModuleName) {
        this._config = config;
        this._ejbModuleName = ejbModuleName;
    }

    public void setVersion(String version) {
    }

    public void setSchemaLocation(String value) {
    }

    public void setMetadataComplete(boolean isMetadataComplete) {
        this._isMetadataComplete = isMetadataComplete;
    }

    public EjbEnterpriseBeans createEnterpriseBeans() throws ConfigException {
        return new EjbEnterpriseBeans(this._config, this._ejbModuleName);
    }

    public Interceptors createInterceptors() throws ConfigException {
        return new Interceptors(this._config);
    }

    public Relationships createRelationships() throws ConfigException {
        return new Relationships(this._config);
    }

    public AssemblyDescriptor createAssemblyDescriptor() throws ConfigException {
        return new AssemblyDescriptor(this._config);
    }

    public void addQueryFunction(QueryFunction fun) {
        this._config.addFunction(fun.getSignature(), null);
    }

    public void setBooleanLiteral(BooleanLiteral literal) {
        this._config.setBooleanTrue(literal.getTrue());
        this._config.setBooleanFalse(literal.getFalse());
    }

    public static class Relationships {
        EjbConfig _config;

        Relationships(EjbConfig config) {
            this._config = config;
        }

        public CmpRelation createEjbRelation() {
            return new CmpRelation(this._config);
        }

        public void addEjbRelation(CmpRelation rel) throws ConfigException {
            this._config.addRelation(rel);
        }
    }

    public static class QueryFunction {
        FunctionSignature _sig;
        String _sql;

        public void setSignature(Signature sig) throws ConfigException {
            this._sig = new FunctionSignature(sig.getSignature());
        }

        public FunctionSignature getSignature() {
            return this._sig;
        }

        public void setSQL(String sql) throws ConfigException {
            this._sql = sql;
        }

        public String getSQL() {
            return this._sql;
        }

        @PostConstruct
        public void init() {
            this._sig.setSQL(this._sql);
        }
    }

    public static class MethodPermission {
        EjbConfig _config;
        MethodSignature _method;
        ArrayList<String> _roles;

        MethodPermission(EjbConfig config) {
            this._config = config;
        }

        public void setDescription(String description) {
        }

        public void setUnchecked(boolean unchecked) {
        }

        public void setRoleName(String roleName) {
            if (this._roles == null) {
                this._roles = new ArrayList();
            }
            this._roles.add(roleName);
        }

        public void setMethod(MethodSignature method) {
            this._method = method;
        }

        @PostConstruct
        public void init() throws ConfigException {
            EjbBean bean = this._config.getBeanConfig(this._method.getEJBName());
            if (bean == null) {
                throw new ConfigException(L.l("'{0}' is an unknown bean.", (Object)this._method.getEJBName()));
            }
            EjbMethodPattern method = bean.createMethod(this._method);
            if (this._roles != null) {
                method.setRoles(this._roles);
            }
        }
    }
}

