/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.types.JndiBuilder;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.MessageDestination;
import com.caucho.ejb.cfg.SecurityIdentity;
import com.caucho.ejb.gen.BeanGenerator;
import com.caucho.ejb.gen.MessageGenerator;
import com.caucho.ejb.manager.EjbContainer;
import com.caucho.ejb.message.JmsActivationSpec;
import com.caucho.ejb.message.JmsResourceAdapter;
import com.caucho.ejb.message.MessageServer;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.jca.ResourceArchive;
import com.caucho.jca.ResourceArchiveManager;
import com.caucho.jca.cfg.MessageListenerConfig;
import com.caucho.util.L10N;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.interceptor.AroundInvoke;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.MessageListener;
import javax.naming.NamingException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import javax.webbeans.ComponentFactory;

public class EjbMessageBean
extends EjbBean {
    private static final Logger log = Logger.getLogger(EjbMessageBean.class.getName());
    private static final L10N L = new L10N(EjbMessageBean.class);
    private ConnectionFactory _connectionFactory;
    private ActivationSpec _activationSpec;
    private Destination _destination;
    private String _messageSelector;
    private int _acknowledgeMode = 1;
    private String _selector;
    private String _subscriptionName;
    private int _consumerMax = -1;
    private String _messageDestinationLink;
    private Class _messagingType;
    private MessageGenerator _messageBean;

    public EjbMessageBean(EjbConfig config, String ejbModuleName) {
        super(config, ejbModuleName);
    }

    public String getEJBKind() {
        return "message";
    }

    public void setEJBClass(Class ejbClass) throws ConfigException {
        super.setEJBClass(ejbClass);
        if (Modifier.isAbstract(ejbClass.getModifiers())) {
            throw this.error(L.l("'{0}' must not be abstract.  Every message-driven bean must be a fully-implemented class.", (Object)ejbClass.getName()));
        }
        if (this.getEJBName() == null) {
            this.setEJBName(ejbClass.getSimpleName());
        }
    }

    public MessageDrivenDestination createMessageDrivenDestination() {
        return new MessageDrivenDestination();
    }

    public void setActivationSpec(ActivationSpec activationSpec) {
        this._activationSpec = activationSpec;
    }

    public void setDestination(Destination destination) throws ConfigException {
        this._destination = destination;
    }

    public void setDestinationValue(Destination destination) {
        this._destination = destination;
    }

    public void setMessagingType(Class messagingType) {
        if (messagingType != Object.class) {
            this._messagingType = messagingType;
        }
    }

    public Destination getDestination() {
        return this._destination;
    }

    public void setMappedName(String mappedName) throws ConfigException {
    }

    public void setMessageDestinationType(String type) throws ConfigException, NamingException {
    }

    public void setMessageDestinationLink(String messageDestinationLink) throws ConfigException, NamingException {
        this._messageDestinationLink = messageDestinationLink;
    }

    public void setConnectionFactory(JndiBuilder factory) throws ConfigException, NamingException {
        if (!(factory.getObject() instanceof ConnectionFactory)) {
            throw new ConfigException(L.l("'{0}' needs to implement javax.jms.ConnectionFactory.", factory.getObject()));
        }
        this._connectionFactory = (ConnectionFactory)factory.getObject();
    }

    public void setConnectionFactoryValue(ConnectionFactory factory) {
        this._connectionFactory = factory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this._connectionFactory;
    }

    public int getAcknowledgeMode() {
        return this._acknowledgeMode;
    }

    public void setAcknowledgeMode(int acknowledgeMode) {
        this._acknowledgeMode = acknowledgeMode;
    }

    public String getSelector() {
        return this._selector;
    }

    public void setSelector(String selector) {
        this._selector = selector;
    }

    public String getSubscriptionName() {
        return this._subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this._subscriptionName = subscriptionName;
    }

    public void setTransactionType(String type) throws ConfigException {
        if (type.equals("Container")) {
            this.setContainerTransaction(true);
        } else if (type.equals("Bean")) {
            this.setContainerTransaction(false);
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown transaction-type.  transaction-type must be 'Bean' or 'Container'.", (Object)type));
        }
    }

    public void setSecurityIdentity(SecurityIdentity identity) {
    }

    public ActivationConfig createActivationConfig() {
        return new ActivationConfig();
    }

    public void setResourceAdapter(String name) {
        ResourceArchive ra = ResourceArchiveManager.findResourceArchive(name);
        if (ra == null) {
            throw new ConfigException(L.l("'{0}' is an unknown resource-adapter"));
        }
    }

    private void addActivationConfigProperty(String name, Object value) {
        if ("destination".equals(name)) {
            if (value instanceof Destination) {
                this.setDestination((Destination)value);
            } else {
                WebBeansContainer webBeans = WebBeansContainer.create();
                Destination dest = webBeans.getObject(Destination.class, String.valueOf(value));
                this.setDestination(dest);
            }
        } else if ("messageSelector".equals(name)) {
            this._messageSelector = (String)value;
        } else {
            log.log(Level.FINE, L.l("activation-config-property '{0}' is unknown, ignored", (Object)name));
        }
    }

    public void setMessageConsumerMax(int consumerMax) throws ConfigException {
        this._consumerMax = consumerMax;
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (this._messagingType == null) {
            if (this._activationSpec != null) {
                String specName = this._activationSpec.getClass().getName();
                ResourceArchive ra = ResourceArchiveManager.findResourceArchive(specName);
                if (ra == null) {
                    throw new ConfigException(L.l("'{0}' is an unknown activation-spec.  Make sure the JCA adapter is deployed in a .rar file", (Object)specName));
                }
                try {
                    this._activationSpec.validate();
                }
                catch (Exception e) {
                    throw this.error(e);
                }
                MessageListenerConfig listener = ra.getMessageListener(specName);
                this._messagingType = listener.getMessageListenerType();
            } else if (MessageListener.class.isAssignableFrom(this.getEJBClass())) {
                this._messagingType = MessageListener.class;
            } else {
                throw this.error(L.l("'{0}' must implement javax.jms.MessageListener or specify {1}.", (Object)this.getEJBClass().getName(), (Object)(this.isAllowPOJO() ? "messaging-type" : "messageListenerInterface")));
            }
        }
        super.init();
        ApiMethod ejbCreate = this.getEJBClassWrapper().getMethod("ejbCreate", new Class[0]);
        if (ejbCreate != null && !ejbCreate.isPublic() && !ejbCreate.isProtected()) {
            throw this.error(L.l("{0}: ejbCreate method must be public or protected.", (Object)this.getEJBClass().getName()));
        }
    }

    protected void introspect() {
        this._messageBean.setApi(new ApiClass(this._messagingType));
        super.introspect();
        MessageDriven messageDriven = this.getEJBClass().getAnnotation(MessageDriven.class);
        if (messageDriven != null) {
            Class type;
            ActivationConfigProperty[] activationConfig = messageDriven.activationConfig();
            if (activationConfig != null) {
                for (ActivationConfigProperty prop : activationConfig) {
                    this.addActivationConfigProperty(prop.propertyName(), prop.propertyValue());
                }
            }
            if ((type = messageDriven.messageListenerInterface()) != null && !Object.class.equals((Object)type)) {
                this._messagingType = type;
            }
        }
    }

    protected BeanGenerator createBeanGenerator() {
        this._messageBean = new MessageGenerator(this.getEJBName(), this.getEJBClassWrapper());
        return this._messageBean;
    }

    public void initIntrospect() throws ConfigException {
        super.initIntrospect();
        ApiClass type = this.getEJBClassWrapper();
        if (!(type.isAnnotationPresent(MessageDriven.class) || type.isAnnotationPresent(MessageDriven.class) || this.isAllowPOJO())) {
            return;
        }
        MessageDriven messageDriven = type.getAnnotation(MessageDriven.class);
        if (messageDriven != null) {
            TransactionManagement transaction;
            Class messageListenerInterface;
            ActivationConfigProperty[] properties = messageDriven.activationConfig();
            if (properties != null) {
                for (ActivationConfigProperty property : properties) {
                    this.addActivationConfigProperty(property.propertyName(), property.propertyValue());
                }
            }
            if ((messageListenerInterface = messageDriven.messageListenerInterface()) != null) {
                this.setMessagingType(messageListenerInterface);
            }
            if ((transaction = type.getAnnotation(TransactionManagement.class)) == null) {
                this.setTransactionType("Container");
            } else if (TransactionManagementType.BEAN.equals((Object)transaction.value())) {
                this.setTransactionType("Bean");
            } else {
                this.setTransactionType("Container");
            }
            this.configureMethods(type);
        }
    }

    private void configureMethods(ApiClass type) throws ConfigException {
        for (ApiMethod method : type.getMethods()) {
            AroundInvoke aroundInvoke = method.getAnnotation(AroundInvoke.class);
            if (aroundInvoke == null) continue;
            this.setAroundInvokeMethodName(method.getName());
            break;
        }
    }

    public AbstractServer deployServer(EjbContainer ejbManager, JavaClassGenerator javaGen) throws ClassNotFoundException {
        if (this._activationSpec != null) {
            return this.deployActivationSpecServer(ejbManager, javaGen);
        }
        return this.deployJmsServer(ejbManager, javaGen);
    }

    private AbstractServer deployJmsServer(EjbContainer ejbManager, JavaClassGenerator javaGen) throws ClassNotFoundException {
        MessageDestination dest;
        Destination destination = null;
        ConnectionFactory factory = this._connectionFactory != null ? this._connectionFactory : this.getEjbContainer().getJmsConnectionFactory();
        if (factory == null) {
            WebBeansContainer webBeans = WebBeansContainer.create();
            factory = webBeans.getObject(ConnectionFactory.class, new Annotation[0]);
        }
        if (this._destination != null) {
            destination = this._destination;
        } else if (this._messageDestinationLink != null && (dest = this.getConfig().getMessageDestination(this._messageDestinationLink)) != null) {
            destination = dest.getResolvedDestination();
        }
        if (destination == null) {
            throw new ConfigException(L.l("ejb-message-bean '{0}' does not have a configured JMS destination or activation-spec", (Object)this.getEJBName()));
        }
        if (factory == null) {
            throw new ConfigException(L.l("ejb-message-bean '{0}' does not have a configured JMS connection factory", (Object)this.getEJBName()));
        }
        JmsResourceAdapter ra = new JmsResourceAdapter(this.getEJBName(), factory, destination);
        JmsActivationSpec spec = new JmsActivationSpec();
        ra.setAcknowledgeMode(this._acknowledgeMode);
        ra.setMessageSelector(this._messageSelector);
        ra.setSubscriptionName(this._subscriptionName);
        if (this._consumerMax > 0) {
            ra.setConsumerMax(this._consumerMax);
        } else {
            ra.setConsumerMax(this.getEjbContainer().getMessageConsumerMax());
        }
        return this.deployMessageServer(ejbManager, javaGen, ra, spec);
    }

    public AbstractServer deployActivationSpecServer(EjbContainer ejbManager, JavaClassGenerator javaGen) throws ClassNotFoundException {
        if (this._activationSpec == null) {
            throw new ConfigException(L.l("ActivationSpec is required for ActivationSpecServer"));
        }
        String specType = this._activationSpec.getClass().getName();
        ResourceArchive raCfg = ResourceArchiveManager.findResourceArchive(specType);
        if (raCfg == null) {
            throw this.error(L.l("'{0}' is an unknown activation-spec.  Make sure the .rar file for the driver is properly installed.", (Object)specType));
        }
        Class raClass = raCfg.getResourceAdapterClass();
        if (raClass == null) {
            throw this.error(L.l("resource-adapter class does not exist for activation-spec '{0}'.  Make sure the .rar file for the driver is properly installed.", (Object)raClass.getName()));
        }
        WebBeansContainer webBeans = WebBeansContainer.create();
        ComponentFactory raFactory = webBeans.resolveByType(raClass, new Annotation[0]);
        if (raFactory == null) {
            throw this.error(L.l("resource-adapter '{0}' must be configured in a <connector> tag.", (Object)raClass.getName()));
        }
        ResourceAdapter ra = (ResourceAdapter)raFactory.get();
        if (ra == null) {
            throw new NullPointerException();
        }
        return this.deployMessageServer(ejbManager, javaGen, ra, this._activationSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractServer deployMessageServer(EjbContainer ejbManager, JavaClassGenerator javaGen, ResourceAdapter ra, ActivationSpec spec) throws ClassNotFoundException {
        MessageServer server;
        try {
            if (spec == null) {
                throw new ConfigException(L.l("ActivationSpec is required for MessageServer"));
            }
            if (ra == null) {
                throw new ConfigException(L.l("ResourceAdapter is required for ActivationSpecServer"));
            }
            server = new MessageServer(ejbManager);
            server.setConfigLocation(this.getFilename(), this.getLine());
            server.setModuleName(this.getEJBModuleName());
            server.setEJBName(this.getEJBName());
            server.setMappedName(this.getMappedName());
            server.setId(this.getEJBModuleName() + "#" + this.getMappedName());
            server.setContainerTransaction(this.isContainerTransaction());
            server.setEjbClass(this.getEJBClass());
            Class contextImplClass = javaGen.loadClass(this.getSkeletonName());
            server.setContextImplClass(contextImplClass);
            server.setActivationSpec(spec);
            server.setResourceAdapter(ra);
            Class beanClass = javaGen.loadClass(this.getEJBClass().getName());
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(server.getClassLoader());
                ContainerProgram initContainer = this.getInitProgram();
                server.setInitProgram(initContainer);
                if (this.getServerProgram() != null) {
                    this.getServerProgram().configure(server);
                }
                Object var12_12 = null;
                thread.setContextClassLoader(oldLoader);
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
        }
        catch (Exception e) {
            throw this.error(e);
        }
        return server;
    }

    public class MessageDrivenDestination {
        public void setDestinationType(String value) throws ConfigException, NamingException {
            EjbMessageBean.this.setMessageDestinationType(value);
        }

        public void setSubscriptionDurability(String durability) {
        }

        public void setJndiName(JndiBuilder destination) throws ConfigException, NamingException {
            EjbMessageBean.this.setDestination((Destination)destination.getObject());
        }
    }

    public static class ActivationConfigPropertyConfig {
        String _name;
        String _value;

        public void setActivationConfigPropertyName(String name) {
            this._name = name;
        }

        public String getActivationConfigPropertyName() {
            return this._name;
        }

        public void setActivationConfigPropertyValue(String value) {
            this._value = value;
        }

        public String getActivationConfigPropertyValue() {
            return this._value;
        }
    }

    public class ActivationConfig {
        public void addActivationConfigProperty(ActivationConfigPropertyConfig prop) throws NamingException {
            String name = prop.getActivationConfigPropertyName();
            String value = prop.getActivationConfigPropertyValue();
            EjbMessageBean.this.addActivationConfigProperty(name, value);
        }
    }
}

