/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.config.program.ContainerProgram;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.EjbSessionHomeView;
import com.caucho.ejb.cfg.EjbStatelessHomeView;
import com.caucho.ejb.cfg21.EjbHomeView;
import com.caucho.ejb.gen.BeanGenerator;
import com.caucho.ejb.gen.SessionGenerator;
import com.caucho.ejb.gen.StatefulGenerator;
import com.caucho.ejb.gen.StatelessGenerator;
import com.caucho.ejb.gen21.BeanAssembler;
import com.caucho.ejb.manager.EjbContainer;
import com.caucho.ejb.session.SessionServer;
import com.caucho.ejb.session.StatefulServer;
import com.caucho.ejb.session.StatelessServer;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.util.L10N;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.Local;
import javax.ejb.LocalHome;
import javax.ejb.RemoteHome;
import javax.ejb.SessionSynchronization;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;

public class EjbSessionBean
extends EjbBean {
    private static final L10N L = new L10N(EjbSessionBean.class);
    private boolean _isStateless;
    private boolean _isContainerTransaction = true;
    private SessionGenerator _sessionBean;

    public EjbSessionBean(EjbConfig ejbConfig, String ejbModuleName) {
        super(ejbConfig, ejbModuleName);
    }

    public String getEJBKind() {
        return "session";
    }

    public void setEJBClass(Class type) throws ConfigException {
        super.setEJBClass(type);
        ApiClass ejbClass = this.getEJBClassWrapper();
        if (ejbClass.isAbstract()) {
            throw this.error(L.l("'{0}' must not be abstract.  Session bean implementations must be fully implemented.", (Object)ejbClass.getName()));
        }
        if (type.isAnnotationPresent(Stateless.class)) {
            Stateless stateless = type.getAnnotation(Stateless.class);
            if (this.getEJBName() == null && !"".equals(stateless.name())) {
                this.setEJBName(stateless.name());
            }
            this._isStateless = true;
        } else if (ejbClass.isAnnotationPresent(Stateful.class)) {
            Stateful stateful = type.getAnnotation(Stateful.class);
            if (this.getEJBName() == null && !"".equals(stateful.name())) {
                this.setEJBName(stateful.name());
            }
            this._isStateless = false;
        }
        if (this.getEJBName() == null) {
            this.setEJBName(ejbClass.getSimpleName());
        }
    }

    public boolean isStateless() {
        return this._isStateless;
    }

    public void setSessionType(String type) throws ConfigException {
        if (type.equals("Stateful")) {
            this._isStateless = false;
        } else if (type.equals("Stateless")) {
            this._isStateless = true;
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown session-type.  session-type must be 'Stateless' or 'Stateful'.", (Object)type));
        }
    }

    public boolean isContainerTransaction() {
        return this._isContainerTransaction;
    }

    public void setTransactionType(String type) throws ConfigException {
        if (type.equals("Container")) {
            this._isContainerTransaction = true;
        } else if (type.equals("Bean")) {
            this._isContainerTransaction = false;
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown transaction-type.  transaction-type must be 'Container' or 'Bean'.", (Object)type));
        }
    }

    @PostConstruct
    public void init() throws ConfigException {
        super.init();
        try {
            if (this.getRemoteHome() != null) {
                this.validateHome(this.getRemoteHome(), this.getRemoteList().get(0));
            }
            if (this.getLocalHome() != null) {
                this.validateHome(this.getLocalHome(), this.getLocalList().get(0));
            }
            for (ApiClass remoteApi : this.getRemoteList()) {
                this.validateRemote(remoteApi);
            }
            for (ApiClass localApi : this.getLocalList()) {
                this.validateRemote(localApi);
            }
            if (this.getEJBClass() == null) {
                throw this.error(L.l("'{0}' does not have a defined ejb-class.  Session beans must have an ejb-class.", (Object)this.getEJBName()));
            }
            if (SessionSynchronization.class.isAssignableFrom(this.getEJBClassWrapper().getJavaClass())) {
                if (this.isStateless()) {
                    throw this.error(L.l("'{0}' must not implement SessionSynchronization.  Stateless session beans must not implement SessionSynchronization.", (Object)this.getEJBClass().getName()));
                }
                if (!this._isContainerTransaction) {
                    throw this.error(L.l("'{0}' must not implement SessionSynchronization.  Session beans with Bean-managed transactions may not use SessionSynchronization.", (Object)this.getEJBClass().getName()));
                }
            }
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (ConfigException e) {
            throw new LineConfigException(this.getLocation() + e.getMessage(), (Throwable)e);
        }
    }

    protected BeanGenerator createBeanGenerator() {
        this._sessionBean = this._isStateless ? new StatelessGenerator(this.getEJBName(), this.getEJBClassWrapper()) : new StatefulGenerator(this.getEJBName(), this.getEJBClassWrapper());
        return this._sessionBean;
    }

    public void initIntrospect() throws ConfigException {
        RemoteHome remoteHomeAnn;
        ApiClass ejbClass;
        LocalHome localHomeAnn;
        super.initIntrospect();
        ApiClass type = this.getEJBClassWrapper();
        if (type == null) {
            return;
        }
        if (!(type.isAnnotationPresent(Stateful.class) || type.isAnnotationPresent(Stateless.class) || this.isAllowPOJO())) {
            return;
        }
        ArrayList<ApiClass> interfaceList = new ArrayList<ApiClass>();
        for (ApiClass localApi : type.getInterfaces()) {
            Class javaApi = localApi.getJavaClass();
            Local local = javaApi.getAnnotation(Local.class);
            if (local != null) {
                this.setLocalWrapper(localApi);
                continue;
            }
            javax.ejb.Remote remote = javaApi.getAnnotation(javax.ejb.Remote.class);
            if (remote != null || Remote.class.isAssignableFrom(javaApi)) {
                this.setRemoteWrapper(localApi);
                continue;
            }
            if (javaApi.getName().equals("java.io.Serializable") || javaApi.getName().equals("java.io.Externalizable") || javaApi.getName().startsWith("javax.ejb") || javaApi.getName().equals("java.rmi.Remote") || interfaceList.contains(localApi)) continue;
            interfaceList.add(localApi);
        }
        if (this._localHome == null && this._localList.size() == 0 && this._remoteHome == null && this._remoteList.size() == 0) {
            if (interfaceList.size() == 0) {
                throw new ConfigException(L.l("'{0}' has no interfaces.  Can't currently generate.", (Object)type.getName()));
            }
            if (interfaceList.size() != 1) {
                throw new ConfigException(L.l("'{0}' has multiple interfaces, but none are marked as @Local or @Remote.\n{1}", (Object)type.getName(), (Object)interfaceList.toString()));
            }
            this.setLocalWrapper((ApiClass)interfaceList.get(0));
        }
        if ((localHomeAnn = (ejbClass = this.getEJBClassWrapper()).getAnnotation(LocalHome.class)) != null) {
            Class localHome = localHomeAnn.value();
            this.setLocalHome(localHome);
        }
        if ((remoteHomeAnn = ejbClass.getAnnotation(RemoteHome.class)) != null) {
            Class home = remoteHomeAnn.value();
            this.setHome(home);
        }
    }

    protected BeanAssembler createAssembler(String fullClassName) {
        throw new IllegalStateException(this.getClass().getName());
    }

    protected void addImports(BeanAssembler assembler) {
        super.addImports(assembler);
        if (this.isStateless()) {
            assembler.addImport("com.caucho.ejb.session.StatelessServer");
            assembler.addImport("com.caucho.ejb.session.AbstractStatelessContext");
            assembler.addImport("com.caucho.ejb.session.StatelessHome");
            assembler.addImport("com.caucho.ejb.session.StatelessObject21");
            assembler.addImport("com.caucho.ejb.session.StatelessObject");
        } else {
            assembler.addImport("com.caucho.ejb.session.SessionServer");
            assembler.addImport("com.caucho.ejb.session.AbstractSessionContext");
            assembler.addImport("com.caucho.ejb.session.SessionHome");
            assembler.addImport("com.caucho.ejb.session.SessionObject21");
            assembler.addImport("com.caucho.ejb.session.SessionObject");
        }
    }

    protected EjbHomeView createHomeView(ApiClass homeClass, String prefix) throws ConfigException {
        if (this.isStateless()) {
            return new EjbStatelessHomeView(this, homeClass, prefix);
        }
        return new EjbSessionHomeView(this, homeClass, prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractServer deployServer(EjbContainer ejbContainer, JavaClassGenerator javaGen) throws ClassNotFoundException, ConfigException {
        ArrayList<ApiClass> localList;
        ApiClass localHome;
        ArrayList<ApiClass> remoteList;
        SessionServer server = this.isStateless() ? new StatelessServer(ejbContainer) : new StatefulServer(ejbContainer);
        server.setModuleName(this.getEJBModuleName());
        server.setEJBName(this.getEJBName());
        server.setMappedName(this.getMappedName());
        server.setId(this.getEJBModuleName() + "#" + this.getEJBName());
        server.setContainerTransaction(this._isContainerTransaction);
        server.setEjbClass(this.loadClass(this.getEJBClass().getName()));
        ApiClass remoteHome = this.getRemoteHome();
        if (remoteHome != null) {
            server.setRemoteHomeClass(this.loadClass(remoteHome.getName()));
        }
        if ((remoteList = this._sessionBean.getRemoteApi()).size() > 0) {
            ArrayList<Class> classList = new ArrayList<Class>();
            for (ApiClass apiClass : remoteList) {
                classList.add(this.loadClass(apiClass.getName()));
            }
            server.setRemoteApiList(classList);
        }
        if ((localHome = this.getLocalHome()) != null) {
            server.setLocalHomeClass(this.loadClass(localHome.getName()));
        }
        if ((localList = this._sessionBean.getLocalApi()).size() > 0) {
            ArrayList<Class> classList = new ArrayList<Class>();
            for (ApiClass apiClass : localList) {
                classList.add(this.loadClass(apiClass.getName()));
            }
            server.setLocalApiList(classList);
        }
        Class contextImplClass = javaGen.loadClass(this.getSkeletonName());
        server.setContextImplClass(contextImplClass);
        Class beanClass = javaGen.loadClass(this.getEJBClass().getName());
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(server.getClassLoader());
            ContainerProgram initContainer = this.getInitProgram();
            server.setInitProgram(initContainer);
            try {
                if (this.getServerProgram() != null) {
                    this.getServerProgram().configure(server);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw ConfigException.create((Throwable)e);
            }
            Object var15_15 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
        return server;
    }

    private void introspectSession() throws ConfigException {
        ApiClass ejbClass = this.getEJBClassWrapper();
        if (ejbClass.isAnnotationPresent(Stateless.class)) {
            this.introspectStateless(ejbClass);
        } else if (ejbClass.isAnnotationPresent(Stateful.class)) {
            this.introspectStateful(ejbClass);
        }
    }

    private void introspectStateless(ApiClass type) throws ConfigException {
        String className = type.getName();
        Stateless stateless = type.getAnnotation(Stateless.class);
        this.setAllowPOJO(true);
        this.setSessionType("Stateless");
        this.setTransactionType(type);
        String name = stateless != null ? stateless.name() : className;
        this.introspectBean(type, name);
    }

    private void introspectStateful(ApiClass type) throws ConfigException {
        String className = type.getName();
        Stateful stateful = type.getAnnotation(Stateful.class);
        this.setAllowPOJO(true);
        this.setSessionType("Stateful");
        this.setTransactionType(type);
        String name = stateful != null ? stateful.name() : className;
        this.introspectBean(type, name);
    }

    private void setTransactionType(ApiClass type) {
        TransactionManagement transaction = type.getAnnotation(TransactionManagement.class);
        if (transaction == null) {
            this.setTransactionType("Container");
        } else if (TransactionManagementType.BEAN.equals((Object)transaction.value())) {
            this.setTransactionType("Bean");
        } else {
            this.setTransactionType("Container");
        }
    }

    private void validateMethods() throws ConfigException {
    }

    private void validateHome(ApiClass homeClass, ApiClass objectClass) throws ConfigException {
        ApiClass beanClass = this.getEJBClassWrapper();
        String beanName = beanClass.getName();
        if (homeClass == null) {
            return;
        }
        String homeName = homeClass.getName();
        String objectName = objectClass.getName();
        boolean hasFindByPrimaryKey = false;
        if (!homeClass.isPublic()) {
            throw this.error(L.l("'{0}' must be public", (Object)homeName));
        }
        if (beanClass.isFinal()) {
            throw this.error(L.l("'{0}' must not be final", (Object)beanName));
        }
        if (beanClass.isAbstract()) {
            throw this.error(L.l("'{0}' must not be abstract", (Object)beanName));
        }
        if (!homeClass.isInterface()) {
            throw this.error(L.l("'{0}' must be an interface", (Object)homeName));
        }
        boolean hasCreate = false;
        for (ApiMethod method : homeClass.getMethods()) {
            String name = method.getName();
            Class[] param = method.getParameterTypes();
            Class retType = method.getReturnType();
            if (method.getDeclaringClass().isAssignableFrom(EJBHome.class) || method.getDeclaringClass().isAssignableFrom(EJBLocalHome.class)) continue;
            if (EJBHome.class.isAssignableFrom(homeClass.getJavaClass())) {
                this.validateException(method, RemoteException.class);
            }
            if (name.startsWith("create")) {
                String createName;
                ApiMethod implMethod;
                hasCreate = true;
                if (this.isStateless() && name.equals("create")) continue;
                if (this.isStateless() && (!name.equals("create") || method.getParameterTypes().length != 0)) {
                    throw this.error(L.l("{0}: '{1}' forbidden in stateless session home.  The create() method for a stateless session bean must have zero arguments.", (Object)method.getFullName(), (Object)homeName));
                }
                if (!this.isAllowPOJO()) {
                    this.validateException(method, CreateException.class);
                }
                if ((implMethod = this.validateNonFinalMethod(createName = "ejbC" + name.substring(1), param, method, homeClass, this.isAllowPOJO())) == null) continue;
                if (!implMethod.getReturnType().getName().equals("void")) {
                    throw this.error(L.l("'{0}' must return {1} in {2}", (Object)EjbSessionBean.getFullMethodName(createName, param), (Object)"void", (Object)beanName));
                }
                this.validateExceptions(method, implMethod.getExceptionTypes());
                continue;
            }
            if (!name.startsWith("ejb") && !name.startsWith("remove")) continue;
            throw this.error(L.l("'{0}' forbidden in {1}", (Object)method.getFullName(), (Object)homeClass.getName()));
        }
        if (!hasCreate) {
            throw this.error(L.l("'{0}' needs at least one create method.  Session beans need a create method.", (Object)homeClass.getName()));
        }
    }
}

