/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JClassLoader;
import com.caucho.bytecode.JClassLoaderWrapper;
import com.caucho.bytecode.JMethod;
import com.caucho.ejb.cfg.AroundInvokeConfig;
import com.caucho.ejb.cfg.PostActivateConfig;
import com.caucho.ejb.cfg.PostConstructConfig;
import com.caucho.ejb.cfg.PreDestroyConfig;
import com.caucho.ejb.cfg.PrePassivateConfig;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.vfs.PersistentDependency;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;

public class Interceptor {
    private static Logger log = Log.open(Interceptor.class);
    private static final L10N L = new L10N(Interceptor.class);
    private String _interceptorClass;
    private String _aroundInvokeMethodName;
    private AroundInvokeConfig _aroundInvokeConfig;
    private PreDestroyConfig _preDestroyConfig;
    private PostConstructConfig _postConstructConfig;
    private PrePassivateConfig _prePassivateConfig;
    private PostActivateConfig _postActivateConfig;
    private String _postConstructMethodName;
    private ClassLoader _loader;
    protected JClassLoader _jClassLoader;
    private JClass _interceptorJClass;
    ArrayList<PersistentDependency> _dependList = new ArrayList();

    public Interceptor() {
        this._loader = Thread.currentThread().getContextClassLoader();
        this._jClassLoader = JClassLoaderWrapper.create(this._loader);
    }

    public JClass getInterceptorJClass() {
        return this._interceptorJClass;
    }

    public String getInterceptorClass() {
        return this._interceptorClass;
    }

    public void setInterceptorClass(String interceptorClass) {
        this._interceptorClass = interceptorClass;
    }

    public void init() {
        if (this._aroundInvokeConfig != null) {
            this._aroundInvokeMethodName = this._aroundInvokeConfig.getMethodName();
        }
        if (this._postConstructConfig != null) {
            this._postConstructMethodName = this._postConstructConfig.getLifecycleCallbackMethod();
        }
        if (this._aroundInvokeMethodName == null || this._postConstructMethodName == null) {
            JClass cl = this._interceptorJClass = this._jClassLoader.forName(this._interceptorClass);
            do {
                for (JMethod method : this._interceptorJClass.getDeclaredMethods()) {
                    if (method.isAnnotationPresent(AroundInvoke.class)) {
                        if (this._aroundInvokeMethodName == null) {
                            this._aroundInvokeMethodName = method.getName();
                        } else if (cl == this._interceptorJClass) {
                            // empty if block
                        }
                    }
                    if (!method.isAnnotationPresent(PostConstruct.class)) continue;
                    if (this._postConstructMethodName == null) {
                        this._postConstructMethodName = method.getName();
                        continue;
                    }
                    if (cl != this._interceptorJClass) continue;
                }
            } while ((cl = cl.getSuperClass()) != null);
        }
    }

    public static void makeAccessible(final Method method) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    method.setAccessible(true);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e.getException());
        }
    }

    public Method getAroundInvokeMethod() {
        return Interceptor.getAroundInvokeMethod(this._interceptorJClass.getJavaClass(), this._aroundInvokeMethodName);
    }

    public static Method getAroundInvokeMethod(Class cl, String methodName) {
        for (Method method : cl.getDeclaredMethods()) {
            Class<?>[] paramTypes;
            if (!method.getName().equals(methodName) || (paramTypes = method.getParameterTypes()).length != 1 || !paramTypes[0].equals(InvocationContext.class)) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    public String getAroundInvokeMethodName() {
        return this._aroundInvokeMethodName;
    }

    public String getPostConstructMethodName() {
        return this._postConstructMethodName;
    }

    public PostActivateConfig getPostActivate() {
        return this._postActivateConfig;
    }

    public PostConstructConfig getPostConstruct() {
        return this._postConstructConfig;
    }

    public PreDestroyConfig getPreDestroy() {
        return this._preDestroyConfig;
    }

    public PrePassivateConfig getPrePassivate() {
        return this._prePassivateConfig;
    }

    public void setAroundInvoke(AroundInvokeConfig aroundInvoke) {
        this._aroundInvokeConfig = aroundInvoke;
    }

    public void setPostActivate(PostActivateConfig postActivate) {
        this._postActivateConfig = postActivate;
    }

    public void setPostConstruct(PostConstructConfig postConstruct) {
        this._postConstructConfig = postConstruct;
    }

    public void setPreDestroy(PreDestroyConfig preDestroy) {
        this._preDestroyConfig = preDestroy;
    }

    public void setPrePassivate(PrePassivateConfig prePassivate) {
        this._prePassivateConfig = prePassivate;
    }

    public String toString() {
        return "Interceptor[" + this._interceptorClass + "]";
    }
}

