/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.EjbConfigManager;
import com.caucho.ejb.cfg.EjbMessageBean;
import com.caucho.ejb.manager.EjbContainer;
import com.caucho.util.L10N;
import com.caucho.webbeans.cfg.AbstractBeanConfig;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.resource.spi.ActivationSpec;

public class MessageBeanConfig
extends AbstractBeanConfig {
    private static final L10N L = new L10N(MessageBeanConfig.class);
    private static final Logger log = Logger.getLogger(MessageBeanConfig.class.getName());
    private ActivationSpec _activationSpec;
    private Class _destinationType;
    private String _destinationName;
    private Object _destination;
    private int _messageConsumerMax;

    public void setActivationSpec(ActivationSpec spec) {
        this._activationSpec = spec;
    }

    public void setDestinationType(Class type) {
        this._destinationType = type;
    }

    public void setDestinationName(String name) {
        this._destinationName = name;
    }

    public void setDestination(Object destination) {
        this._destination = destination;
        if (destination == null) {
            throw new NullPointerException();
        }
    }

    public void setMessageConsumerMax(int messageConsumerMax) {
        this._messageConsumerMax = messageConsumerMax;
    }

    @PostConstruct
    public void init() {
        if (this.getInstanceClass() == null) {
            throw new ConfigException(L.l("ejb-message-bean requires a 'class' attribute"));
        }
        EjbContainer ejbContainer = EjbContainer.create();
        EjbConfigManager configManager = ejbContainer.getConfigManager();
        EjbMessageBean bean = new EjbMessageBean(configManager, "config");
        bean.setConfigLocation(this.getFilename(), this.getLine());
        bean.setEJBClass(this.getInstanceClass());
        String name = this.getName();
        if (name == null) {
            name = this.getJndiName();
        }
        if (name == null) {
            name = this.getInstanceClass().getSimpleName();
        }
        bean.setEJBName(name);
        if (this.getInit() != null) {
            bean.setInit(this.getInit());
        }
        String loc = this.getInstanceClass().getName() + ": ";
        WebBeansContainer webBeans = WebBeansContainer.create();
        bean.setMessageConsumerMax(this._messageConsumerMax);
        if (this._destination != null) {
            bean.setDestinationValue((Destination)this._destination);
        } else if (this._activationSpec != null) {
            bean.setActivationSpec(this._activationSpec);
        } else {
            ComponentImpl destComp;
            Class<Destination> destinationType = this._destinationType;
            if (this._destinationType == null) {
                destinationType = Destination.class;
            }
            if ((destComp = this._destinationName != null ? webBeans.bind(loc, (Type)((Object)destinationType), this._destinationName) : webBeans.bind(loc, (Type)((Object)destinationType))) == null) {
                throw new ConfigException(L.l("'{0}' is an unknown destination type '{1}'", (Object)this._destinationName, (Object)this._destinationType.getName()));
            }
            bean.setDestinationValue((Destination)destComp.get());
            ComponentImpl comp = webBeans.bind(loc, (Type)((Object)ConnectionFactory.class));
            if (comp == null) {
                throw new ConfigException(L.l("ejb-message-bean requires a configured JMS ConnectionFactory"));
            }
            bean.setConnectionFactoryValue((ConnectionFactory)comp.get());
        }
        bean.init();
        configManager.setBeanConfig(name, bean);
    }
}

