/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.types.DescriptionGroupConfig;
import com.caucho.util.L10N;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;

public class MessageDestination
extends DescriptionGroupConfig {
    private final L10N L = new L10N(MessageDestination.class);
    private Logger log = Logger.getLogger(MessageDestination.class.getName());
    private String _messageDestinationName;
    private String _mappedName;
    private Destination _destination;

    public void setMessageDestinationName(String messageDestinationName) {
        this._messageDestinationName = messageDestinationName;
    }

    public String getMessageDestinationName() {
        return this._messageDestinationName;
    }

    public void setMappedName(String mappedName) {
        this._mappedName = mappedName;
    }

    public Destination getResolvedDestination() {
        if (this._destination == null) {
            this.resolve();
        }
        return this._destination;
    }

    private void resolve() {
        Destination destination = null;
        WebBeansContainer webBeans = WebBeansContainer.create();
        String name = this._mappedName;
        if (name == null) {
            name = this._messageDestinationName;
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(this.L.l("resolving <message-destination> '{0}'", (Object)name));
        }
        if ((destination = (Destination)webBeans.getObjectByName(name)) == null) {
            throw new ConfigException(this.L.l("<message-destination> '{0}' could not be resolved", (Object)name));
        }
        this._destination = destination;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this._messageDestinationName + "]";
    }
}

