/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.EjbConfigManager;
import com.caucho.ejb.cfg.EjbStatelessBean;
import com.caucho.ejb.manager.EjbContainer;
import com.caucho.util.L10N;
import com.caucho.webbeans.cfg.AbstractBeanConfig;
import com.caucho.webbeans.cfg.WbComponentConfig;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

public class StatelessBeanConfig
extends AbstractBeanConfig {
    private static final L10N L = new L10N(StatelessBeanConfig.class);
    private static final Logger log = Logger.getLogger(StatelessBeanConfig.class.getName());

    public StatelessBeanConfig() {
    }

    public StatelessBeanConfig(WbComponentConfig beanConfig) {
        this.setClass(beanConfig.getClassType());
        if (beanConfig.getName() != null) {
            this.setName(beanConfig.getName());
        }
        if (beanConfig.getInit() != null) {
            this.setInit(beanConfig.getInit());
        }
    }

    @PostConstruct
    public void init() {
        if (this.getInstanceClass() == null) {
            throw new ConfigException(L.l("ejb-stateless-bean requires a 'class' attribute"));
        }
        EjbContainer ejbContainer = EjbContainer.create();
        EjbConfigManager configManager = ejbContainer.getConfigManager();
        EjbStatelessBean bean = new EjbStatelessBean(configManager, "config");
        bean.setEJBClass(this.getInstanceClass());
        String name = this.getName();
        if (name == null) {
            name = this.getJndiName();
        }
        if (name == null) {
            name = this.getInstanceClass().getSimpleName();
        }
        bean.setEJBName(name);
        if (this.getInit() != null) {
            bean.setInit(this.getInit());
        }
        configManager.setBeanConfig(name, bean);
    }
}

