/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg21;

import com.caucho.amber.field.IdField;
import com.caucho.amber.field.KeyPropertyField;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.table.Column;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.bytecode.JClassWrapper;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.cfg21.CmpProperty;
import com.caucho.ejb.cfg21.EjbEntityBean;
import com.caucho.jdbc.JdbcMetaData;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import javax.annotation.PostConstruct;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;

public class CmpField
extends CmpProperty {
    private static final L10N L = new L10N(CmpProperty.class);
    private String _sqlColumn;
    private String _abstractSQLType;
    private String _sqlType;
    private boolean _isAutoGenerate = true;
    private Class _javaType = String.class;

    public CmpField(EjbEntityBean entity) {
        super(entity);
    }

    public String getSQLColumn() {
        return this._sqlColumn;
    }

    public void setSQLColumn(String sqlColumn) {
        this._sqlColumn = sqlColumn;
    }

    public String getSQLType() {
        return this._sqlType;
    }

    public void setSQLType(String sqlType) {
        this._sqlType = sqlType;
    }

    public String getAbstractSQLType() {
        return this._abstractSQLType;
    }

    public void setAbstractSQLType(String sqlType) {
        this._abstractSQLType = sqlType;
    }

    public void setJavaType(Class javaType) {
        if (javaType.getName().equals("java.util.Map")) {
            Thread.dumpStack();
        }
        this._javaType = javaType;
    }

    public Class getJavaType() {
        return this._javaType;
    }

    public void setAutoGenerate(boolean isAutoGenerate) {
        this._isAutoGenerate = isAutoGenerate;
    }

    public boolean isAutoGenerate() {
        return this._isAutoGenerate;
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (this.getEntity().isCMP1()) {
            return;
        }
        String name = this.getName();
        String getterName = "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        this.getEntity();
        ApiMethod getter = EjbEntityBean.getMethod(this.getEntity().getEJBClassWrapper(), getterName, new Class[0]);
        if (getter == null) {
            throw new ConfigException(L.l("{0}: '{1}' is an unknown cmp-field.  cmp-fields must have matching getter methods.", (Object)this.getEntity().getEJBClass().getName(), (Object)name));
        }
        if (!getter.isPublic()) {
            throw new ConfigException(L.l("{0}: '{1}' must be public.  cmp-fields getters must be public.", (Object)this.getEntity().getEJBClass().getName(), (Object)getter.getFullName()));
        }
        if (!getter.isAbstract() && !this.getEntity().isAllowPOJO()) {
            throw new ConfigException(L.l("{0}: '{1}' must be abstract.  cmp-fields getters must be abstract.", (Object)this.getEntity().getEJBClass().getName(), (Object)getter.getFullName()));
        }
        if (getter.getExceptionTypes().length != 0) {
            throw new ConfigException(L.l("{0}: '{1}' must not throw {2}.  Container managed fields and relations must not throw exceptions.", (Object)this.getEntity().getEJBClass().getName(), (Object)getter.getFullName(), (Object)getter.getExceptionTypes()[0].getName()));
        }
        this._javaType = getter.getReturnType();
        if ("void".equals(this._javaType.getName())) {
            throw new ConfigException(L.l("{0}: '{1}' must not return void.  CMP fields must not return void.", (Object)this.getEntity().getEJBClass().getName(), (Object)this.getName()));
        }
        if (EJBLocalObject.class.isAssignableFrom(this._javaType)) {
            throw new ConfigException(L.l("{0}: '{1}' must not return an EJB interface.  CMP fields must return concrete values.", (Object)this.getEntity().getEJBClass().getName(), (Object)this.getName()));
        }
        if (EJBObject.class.isAssignableFrom(this._javaType)) {
            throw new ConfigException(L.l("{0}: '{1}' must not return an EJB interface.  CMP fields must return concrete values.", (Object)this.getEntity().getEJBClass().getName(), (Object)this.getName()));
        }
        String setterName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        this.getEntity();
        ApiMethod setter = EjbEntityBean.getMethod(this.getEntity().getEJBClassWrapper(), setterName, new Class[]{getter.getReturnType()});
        if (setter != null) {
            if (!setter.isPublic()) {
                throw new ConfigException(L.l("{0}: '{1}' must be public.  cmp-fields setters must be public.", (Object)this.getEntity().getEJBClass().getName(), (Object)setter.getFullName()));
            }
            if (!"void".equals(setter.getReturnType().getName())) {
                throw new ConfigException(L.l("{0}: '{1}' must return void.  cmp-fields setters must return void.", (Object)this.getEntity().getEJBClass().getName(), (Object)setter.getFullName()));
            }
            if (!setter.isAbstract() && !this.getEntity().isAllowPOJO()) {
                throw new ConfigException(L.l("{0}: '{1}' must be abstract.  cmp-fields setters must be abstract.", (Object)this.getEntity().getEJBClass().getName(), (Object)setter.getFullName()));
            }
            if (setter.getExceptionTypes().length != 0) {
                throw new ConfigException(L.l("{0}: '{1}' must not throw {2}.  Container managed fields and relations must not throw exceptions.", (Object)this.getEntity().getEJBClass().getName(), (Object)setter.getFullName(), (Object)setter.getExceptionTypes()[0].getName()));
            }
        }
        if (this._sqlColumn == null) {
            this._sqlColumn = CmpField.toSqlName(this.getName());
        }
    }

    public IdField createId(AmberPersistenceUnit amberPersistenceUnit, EntityType type) throws ConfigException {
        Class dataType;
        String fieldName = this.getName();
        String sqlName = this.getSQLColumn();
        if (sqlName == null) {
            sqlName = CmpField.toSqlName(fieldName);
        }
        if ((dataType = this.getJavaType()) == null) {
            throw new NullPointerException(L.l("'{0}' is an unknown field", (Object)fieldName));
        }
        Type amberType = amberPersistenceUnit.createType(JClassWrapper.create(dataType));
        Column column = type.getTable().createColumn(sqlName, amberType);
        KeyPropertyField idField = new KeyPropertyField(type, fieldName, column);
        if (this.isAutoGenerate() && ("int".equals(dataType.getName()) || "long".equals(dataType.getName()) || "java.lang.Integer".equals(dataType.getName()) || "java.lang.Long".equals(dataType.getName()))) {
            JdbcMetaData metaData = amberPersistenceUnit.getMetaData();
            if (metaData.supportsIdentity()) {
                idField.setGenerator("identity");
                column.setGeneratorType("identity");
            } else if (metaData.supportsSequences()) {
                idField.setGenerator("sequence");
                column.setGeneratorType("sequence");
                String name = type.getTable().getName() + "_cseq";
                type.setGenerator(idField.getName(), amberPersistenceUnit.createSequenceGenerator(name, 10));
            }
        }
        return idField;
    }

    static String toSqlName(String name) {
        CharBuffer cb = new CharBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!Character.isUpperCase(ch)) {
                cb.append(ch);
                continue;
            }
            if (i > 0 && !Character.isUpperCase(name.charAt(i - 1))) {
                cb.append("_");
                cb.append(Character.toLowerCase(ch));
                continue;
            }
            if (i + 1 < name.length() && !Character.isUpperCase(name.charAt(i + 1))) {
                cb.append("_");
                cb.append(Character.toLowerCase(ch));
                continue;
            }
            cb.append(Character.toLowerCase(ch));
        }
        return cb.toString();
    }

    public String toString() {
        return "CmpField[" + this.getName() + "]";
    }
}

