/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg21;

import com.caucho.amber.field.IdField;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.cfg21.EjbEntityBean;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;

public class CmpProperty {
    private static final L10N L = new L10N(CmpProperty.class);
    private EjbEntityBean _entity;
    private String _location;
    private String _name;
    private String _description;
    private boolean _isId;

    public CmpProperty(EjbEntityBean entity) {
        this._entity = entity;
    }

    public EjbEntityBean getEntity() {
        return this._entity;
    }

    public EjbEntityBean getBean() {
        return this._entity;
    }

    public void setConfigLocation(String filename, int line) {
        this._location = filename + ":" + line + ": ";
    }

    public void setLocation(String location) {
        if (location != null) {
            this._location = location;
        }
    }

    public String getLocation() {
        if (this._location != null) {
            return this._location;
        }
        return this._entity.getLocation();
    }

    public void setFieldName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setId(boolean id) {
        this._isId = id;
    }

    public boolean isId() {
        return this._isId;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public ApiMethod getGetter() {
        String methodName = "get" + Character.toUpperCase(this._name.charAt(0)) + this._name.substring(1);
        return this._entity.getMethod(methodName, new Class[0]);
    }

    public ApiMethod getSetter() {
        String methodName = "set" + Character.toUpperCase(this._name.charAt(0)) + this._name.substring(1);
        ApiMethod getter = this.getGetter();
        if (getter != null) {
            return this._entity.getMethod(methodName, new Class[]{getter.getReturnType()});
        }
        return null;
    }

    public IdField createId(AmberPersistenceUnit amberPersistenceUnit, EntityType type) throws ConfigException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    static String toSqlName(String name) {
        CharBuffer cb = new CharBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!Character.isUpperCase(ch)) {
                cb.append(ch);
                continue;
            }
            if (i > 0 && !Character.isUpperCase(name.charAt(i - 1))) {
                cb.append("_");
                cb.append(Character.toLowerCase(ch));
                continue;
            }
            if (i + 1 < name.length() && !Character.isUpperCase(name.charAt(i + 1))) {
                cb.append("_");
                cb.append(Character.toLowerCase(ch));
                continue;
            }
            cb.append(Character.toLowerCase(ch));
        }
        return cb.toString();
    }

    public String toString() {
        return "CmpProperty[" + this._name + "]";
    }
}

