/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg21;

import com.caucho.amber.field.AbstractField;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg21.CmpRelation;
import com.caucho.ejb.cfg21.SqlRelation;
import com.caucho.util.L10N;
import java.util.Collection;
import javax.annotation.PostConstruct;

public class CmpRelationRole {
    private static L10N L = new L10N(CmpRelationRole.class);
    private CmpRelation _relation;
    private CmpRelationRole _target;
    private String _location;
    private String _ejbName;
    private String _fieldName;
    private boolean _cascadeDelete;
    private String _multiplicity;
    private SqlRelation[] _sqlColumns = new SqlRelation[0];
    private String _orderBy;
    private AbstractField _amberField;
    private Class _javaType;
    private boolean _isImplicit;

    public CmpRelationRole(CmpRelation relation) {
        this._relation = relation;
    }

    public void setDescription(String description) {
    }

    public CmpRelation getRelation() {
        return this._relation;
    }

    public CmpRelationRole getTarget() {
        return this._target;
    }

    public void setTarget(CmpRelationRole target) {
        this._target = target;
    }

    public void setConfigLocation(String filename, int line) {
        this._location = filename + ":" + line + ": ";
    }

    public String getLocation() {
        return this._location;
    }

    public void setEjbRelationshipRoleName(String name) {
    }

    public String getEJBName() {
        return this._ejbName;
    }

    public void setEJBName(String ejbName) {
        this._ejbName = ejbName;
    }

    public String getFieldName() {
        return this._fieldName;
    }

    public void setFieldName(String fieldName) {
        this._fieldName = fieldName;
    }

    public boolean getCascadeDelete() {
        return this._cascadeDelete;
    }

    public void setCascadeDelete(boolean cascadeDelete) {
        this._cascadeDelete = cascadeDelete;
    }

    public String getMultiplicity() {
        return this._multiplicity;
    }

    public void setMultiplicity(String multiplicity) throws ConfigException {
        this._multiplicity = multiplicity;
        if (multiplicity == null || !multiplicity.equals("One") && !multiplicity.equals("Many")) {
            throw new ConfigException(L.l("'{0}' is an unknown multiplicity.  'One' and 'Many' are the only allowed values.", (Object)multiplicity));
        }
    }

    public SqlRelation[] getSQLColumns() {
        return this._sqlColumns;
    }

    public void addSQLColumn(String sqlColumn, String references) {
        SqlRelation relation = new SqlRelation(this._fieldName);
        relation.setSQLColumn(sqlColumn);
        relation.setReferences(references);
        if (this._sqlColumns == null) {
            this._sqlColumns = new SqlRelation[]{relation};
        } else {
            SqlRelation[] newColumns = new SqlRelation[this._sqlColumns.length + 1];
            System.arraycopy(this._sqlColumns, 0, newColumns, 0, this._sqlColumns.length);
            newColumns[this._sqlColumns.length] = relation;
            this._sqlColumns = newColumns;
        }
    }

    public SqlColumn createSqlColumn() {
        return new SqlColumn();
    }

    public String getOrderBy() {
        return this._orderBy;
    }

    public void setOrderBy(String orderBy) {
        this._orderBy = orderBy;
    }

    public boolean isImplicit() {
        return this._isImplicit;
    }

    public void setImplicit(boolean isImplicit) {
        this._isImplicit = isImplicit;
    }

    public void setJavaType(Class cl) {
        this._javaType = cl;
    }

    public void setAmberField(AbstractField field) {
        this._amberField = field;
    }

    public AbstractField getAmberField() {
        return this._amberField;
    }

    public boolean isCollection() {
        return this._javaType != null && Collection.class.isAssignableFrom(this._javaType);
    }

    public void merge(CmpRelationRole newRole) {
        if (this._sqlColumns.length == 0) {
            this._sqlColumns = newRole.getSQLColumns();
        }
    }

    public RoleSource createRelationshipRoleSource() {
        return new RoleSource();
    }

    public CmrField createCmrField() {
        return new CmrField();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CmpRelationRole)) {
            return false;
        }
        CmpRelationRole role = (CmpRelationRole)o;
        if (!this._ejbName.equals(role._ejbName)) {
            return false;
        }
        if (this._fieldName == null || role._fieldName == null) {
            return this._fieldName == role._fieldName;
        }
        return this._fieldName.equals(role._fieldName);
    }

    public class SqlColumn {
        private String _value;
        private String _references;

        public void setReferences(String references) {
            this._references = references;
        }

        public void setValue(String value) {
            this._value = value;
        }

        public void addText(String value) {
            this._value = value;
        }

        @PostConstruct
        public void init() {
            CmpRelationRole.this.addSQLColumn(this._value, this._references);
        }
    }

    public class CmrField {
        public void setCmrFieldName(String name) {
            CmpRelationRole.this.setFieldName(name);
        }

        public void setCmrFieldType(String name) {
        }

        public SqlColumn createSqlColumn() {
            return new SqlColumn();
        }
    }

    public class RoleSource {
        public void setEJBName(String name) {
            CmpRelationRole.this.setEJBName(name);
        }
    }
}

