/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg21;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.cfg.EjbMethod;
import com.caucho.ejb.cfg21.EjbEntityBean;
import com.caucho.ejb.cfg21.EjbView;
import com.caucho.ejb.gen21.AmberQueryMethod;
import com.caucho.ejb.gen21.ViewClass;
import com.caucho.ejb.ql.EjbSelectQuery;
import com.caucho.ejb.ql.QLParser;
import com.caucho.java.gen.BaseMethod;
import com.caucho.util.L10N;

public class EjbAmberFindMethod
extends EjbMethod {
    private static final L10N L = new L10N(EjbAmberFindMethod.class);
    private String _query;
    private String _location;
    private boolean _queryLoadsBean = true;

    public EjbAmberFindMethod(EjbView view, ApiMethod apiMethod, String query, String location) throws ConfigException {
        super(view, apiMethod, null);
        if (apiMethod == null) {
            throw new NullPointerException();
        }
        this._query = query;
        this._location = location;
    }

    public void setQueryLoadsBean(boolean queryLoadsBean) {
        this._queryLoadsBean = queryLoadsBean;
    }

    public BaseMethod assemble(ViewClass viewAssembler, String fullClassName) throws ConfigException {
        ApiMethod apiMethod = this.getApiMethod();
        EjbEntityBean bean = (EjbEntityBean)this.getView().getBean();
        QLParser parser = new QLParser(bean, apiMethod.getName(), apiMethod, apiMethod.getReturnType());
        if (this._location != null) {
            parser.setLocation(this._location);
        }
        EjbSelectQuery query = (EjbSelectQuery)parser.parseQuery(this._query);
        String returnEJB = parser.getReturnEJB();
        if (returnEJB == null || !returnEJB.equals(bean.getEJBName())) {
            throw new ConfigException(L.l("{0}: '{1}' query must return collection of '{2}'", (Object)bean.getEJBClass().getName(), (Object)apiMethod.getName(), (Object)bean.getLocal().getName()));
        }
        AmberQueryMethod queryMethod = new AmberQueryMethod(bean, this.getApiMethod(), fullClassName, this.getViewPrefix(), query);
        queryMethod.setQueryLoadsBean(this._queryLoadsBean);
        return queryMethod;
    }
}

