/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg21;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.Type;
import com.caucho.bytecode.JClassWrapper;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.cfg.EjbBaseMethod;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg21.EjbEntityBean;
import com.caucho.ejb.gen21.AbstractQueryMethod;
import com.caucho.ejb.gen21.AmberSelectCollectionMethod;
import com.caucho.ejb.gen21.AmberSelectMethod;
import com.caucho.ejb.gen21.BeanAssembler;
import com.caucho.ejb.manager.EjbContainer;
import com.caucho.ejb.ql.EjbSelectQuery;
import com.caucho.ejb.ql.QLParser;
import com.caucho.java.gen.BaseMethod;
import com.caucho.util.L10N;
import java.util.Collection;
import javax.ejb.EJBLocalObject;

public class EjbAmberSelectMethod
extends EjbBaseMethod {
    private static final L10N L = new L10N(EjbAmberSelectMethod.class);
    private String _query;
    private String _location;
    private boolean _queryLoadsBean;

    public EjbAmberSelectMethod(EjbEntityBean bean, ApiMethod method, String query, String location) throws ConfigException {
        super(bean, method);
        this._query = query;
        this._location = location;
    }

    public void setQueryLoadsBean(boolean queryLoadsBean) {
        this._queryLoadsBean = queryLoadsBean;
    }

    public BaseMethod assemble(BeanAssembler assembler, String fullClassName) throws ConfigException {
        ApiMethod method = this.getMethod();
        QLParser parser = new QLParser((EjbEntityBean)this.getBean(), method.getName(), method, method.getReturnType());
        parser.setLocation(this._location);
        EjbSelectQuery query = (EjbSelectQuery)parser.parseQuery(this._query);
        String returnEJB = parser.getReturnEJB();
        Class retType = method.getReturnType();
        EjbConfig ejbConfig = this.getBean().getConfig();
        EjbContainer ejbManager = ejbConfig.getEjbContainer();
        EjbEntityBean retBean = null;
        if (returnEJB != null) {
            retBean = (EjbEntityBean)ejbConfig.getBeanConfig(returnEJB);
        }
        AmberPersistenceUnit amberPersistenceUnit = ejbManager.createEjbPersistenceUnit();
        Type amberType = null;
        if (returnEJB != null) {
            amberType = amberPersistenceUnit.getEntityType(retBean.getAbstractSchemaName());
            if (amberType == null) {
                throw new NullPointerException("No amber entity for " + returnEJB);
            }
        } else if (EJBLocalObject.class.isAssignableFrom(retType)) {
            EjbEntityBean targetBean = this.getBean().getConfig().findEntityByLocal(retType);
            Class queryRetType = parser.getSelectExpr().getJavaType();
            if (queryRetType != null && !Object.class.equals((Object)queryRetType) && !EJBLocalObject.class.equals((Object)queryRetType)) {
                throw new ConfigException(L.l("Mismatched return type '{0}' in\n{1}", (Object)retType.getName(), (Object)this._query));
            }
            amberType = amberPersistenceUnit.getEntityType(targetBean.getAbstractSchemaName());
        } else if (!Collection.class.isAssignableFrom(retType)) {
            amberType = amberPersistenceUnit.createType(JClassWrapper.create(retType));
        }
        AbstractQueryMethod queryMethod = Collection.class.isAssignableFrom(retType) ? new AmberSelectCollectionMethod((EjbEntityBean)this.getBean(), this.getMethod(), fullClassName, query) : new AmberSelectMethod((EjbEntityBean)this.getBean(), method, fullClassName, query, amberType);
        queryMethod.setQueryLoadsBean(this._queryLoadsBean);
        return queryMethod;
    }
}

