/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg21;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbMethod;
import com.caucho.ejb.cfg21.CmpCollectionSetter;
import com.caucho.ejb.cfg21.CmpField;
import com.caucho.ejb.cfg21.CmpGetter;
import com.caucho.ejb.cfg21.CmpIdGetter;
import com.caucho.ejb.cfg21.CmrManyToMany;
import com.caucho.ejb.cfg21.CmrManyToOne;
import com.caucho.ejb.cfg21.CmrMap;
import com.caucho.ejb.cfg21.CmrOneToMany;
import com.caucho.ejb.cfg21.CmrRelation;
import com.caucho.ejb.cfg21.EjbEntityBean;
import com.caucho.ejb.cfg21.EjbEntityView;
import com.caucho.ejb.cfg21.EjbManyToOneSetMethod;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbCmpView
extends EjbEntityView {
    private static final Logger log = Log.open(EjbCmpView.class);
    private static final L10N L = new L10N(EjbCmpView.class);
    private EjbEntityBean _entityBean;

    public EjbCmpView(EjbEntityBean bean, ArrayList<ApiClass> apiList, String prefix) throws ConfigException {
        super(bean, apiList, prefix);
        this._entityBean = bean;
    }

    @Override
    protected EjbMethod introspectEJBMethod(ApiMethod method) throws ConfigException {
        String methodName = method.getName();
        Class[] paramTypes = method.getParameterTypes();
        if (methodName.startsWith("ejbSelect") && method.isAbstract()) {
            this._entityBean.addStubMethod(method);
            return null;
        }
        return super.introspectEJBMethod(method);
    }

    @Override
    protected EjbMethod createBusinessMethod(ApiMethod apiMethod, ApiMethod implMethod) throws ConfigException {
        String methodName = implMethod.getName();
        Class[] paramTypes = implMethod.getParameterTypes();
        if (methodName.startsWith("get") && methodName.length() > 3 && paramTypes.length == 0) {
            String fieldName = this.toFieldName(methodName.substring(3));
            CmpField field = this._entityBean.getCmpField(fieldName);
            if (field != null) {
                this.validateCmpMethod(implMethod);
                if (this.isLocal() && apiMethod.getExceptionTypes().length != 0) {
                    throw new ConfigException(L.l("{0}: '{1}' must not throw {2}.  Container managed fields and relations must not throw exceptions.", (Object)apiMethod.getDeclaringClass().getName(), (Object)EjbBean.getFullMethodName(apiMethod), (Object)apiMethod.getExceptionTypes()[0].getName()));
                }
                if (field.isId()) {
                    return new CmpIdGetter(this, apiMethod, implMethod);
                }
                return new CmpGetter(this, apiMethod, implMethod);
            }
            CmrRelation rel = this._entityBean.getRelation(fieldName);
            if (rel != null) {
                this.validateCmpMethod(implMethod);
                rel.setHasGetter(true);
                return rel.createGetter(this, apiMethod, implMethod);
            }
            if (!implMethod.isAbstract()) {
                this.validateCmpMethod(implMethod);
                return new EjbMethod(this, apiMethod, implMethod);
            }
        } else if (methodName.startsWith("get") && methodName.length() > 3 && paramTypes.length == 1) {
            String fieldName = this.toFieldName(methodName.substring(3));
            CmrRelation rel = this._entityBean.getRelation(fieldName);
            if (rel instanceof CmrMap) {
                CmrMap map = (CmrMap)rel;
                this.validateCmpMethod(implMethod);
                rel.setHasGetter(true);
                return new CmpGetter(this, apiMethod, implMethod);
            }
        } else if (methodName.startsWith("set") && methodName.length() > 3 && paramTypes.length == 1) {
            String fieldName = this.toFieldName(methodName.substring(3));
            CmpField field = this._entityBean.getCmpField(fieldName);
            if (field != null) {
                this.validateCmpMethod(implMethod);
                if (this.isLocal() && apiMethod.getExceptionTypes().length != 0) {
                    throw new ConfigException(L.l("{0}: '{1}' must not throw {2}.  Container managed fields and relations must not throw exceptions.", (Object)this._entityBean.getEJBClass().getName(), (Object)EjbBean.getFullMethodName(apiMethod), (Object)apiMethod.getExceptionTypes()[0].getName()));
                }
                return new EjbMethod(this, apiMethod, implMethod);
            }
            CmrRelation rel = this._entityBean.getRelation(fieldName);
            if (rel instanceof CmrOneToMany) {
                this.validateCmpMethod(implMethod);
                return new CmpCollectionSetter(this, apiMethod, implMethod);
            }
            if (rel instanceof CmrManyToOne) {
                this.validateCmpMethod(implMethod);
                CmrManyToOne manyToOne = (CmrManyToOne)rel;
                return new EjbManyToOneSetMethod(this, apiMethod, implMethod, manyToOne);
            }
            if (rel instanceof CmrManyToMany) {
                this.validateCmpMethod(implMethod);
                return new CmpCollectionSetter(this, apiMethod, implMethod);
            }
            if (!implMethod.isAbstract()) {
                this.validateCmpMethod(implMethod);
                return new EjbMethod(this, apiMethod, implMethod);
            }
            throw new ConfigException(L.l("{0}: abstract setter {1}.", (Object)implMethod.getDeclaringClass().getName(), (Object)EjbCmpView.getFullMethodName(implMethod)));
        }
        return super.createBusinessMethod(apiMethod, implMethod);
    }

    protected String toFieldName(String name) {
        if (name.length() == 0) {
            return "";
        }
        if (name.length() == 1) {
            return String.valueOf(Character.toLowerCase(name.charAt(0)));
        }
        if (Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    protected void validateCmpMethod(ApiMethod implMethod) throws ConfigException {
        if (!implMethod.isPublic()) {
            throw this.error(L.l("{0}: '{1}' must be public.  CMP method implementations must be public.", (Object)implMethod.getDeclaringClass().getName(), (Object)EjbCmpView.getFullMethodName(implMethod)));
        }
        if (implMethod.isStatic()) {
            throw this.error(L.l("{0}: '{1}' must not be static.  CMP method implementations must not be static.", (Object)implMethod.getDeclaringClass().getName(), (Object)EjbCmpView.getFullMethodName(implMethod)));
        }
    }
}

