/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg21;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.EntityType;
import com.caucho.bytecode.JClassWrapper;
import com.caucho.config.ConfigException;
import com.caucho.config.types.Period;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.amber.AmberConfig;
import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.cfg.EjbBaseMethod;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.EjbMethodPattern;
import com.caucho.ejb.cfg.EjbObjectView;
import com.caucho.ejb.cfg.MethodSignature;
import com.caucho.ejb.cfg21.CmpField;
import com.caucho.ejb.cfg21.CmpFieldProxy;
import com.caucho.ejb.cfg21.CmpProperty;
import com.caucho.ejb.cfg21.CmrMap;
import com.caucho.ejb.cfg21.CmrRelation;
import com.caucho.ejb.cfg21.Ejb21Bean;
import com.caucho.ejb.cfg21.EjbAmberSelectMethod;
import com.caucho.ejb.cfg21.EjbCmpView;
import com.caucho.ejb.cfg21.EjbEntityHomeView;
import com.caucho.ejb.cfg21.EjbEntityView;
import com.caucho.ejb.cfg21.EjbHomeView;
import com.caucho.ejb.cfg21.EntityGenerator;
import com.caucho.ejb.cfg21.Query;
import com.caucho.ejb.entity.EntityServer;
import com.caucho.ejb.gen.BeanGenerator;
import com.caucho.ejb.gen21.AmberAssembler;
import com.caucho.ejb.gen21.BeanAssembler;
import com.caucho.ejb.gen21.EntityAssembler;
import com.caucho.ejb.gen21.EntityCreateMethod;
import com.caucho.ejb.gen21.EntityFindMethod;
import com.caucho.ejb.gen21.EntityHomePoolChain;
import com.caucho.ejb.manager.EjbContainer;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.BaseClass;
import com.caucho.java.gen.BaseMethod;
import com.caucho.java.gen.CallChain;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.java.gen.MethodCallChain;
import com.caucho.util.L10N;
import java.io.IOException;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbEntityBean
extends Ejb21Bean {
    private static final L10N L = new L10N(EjbEntityBean.class);
    private ApiClass _primKeyClass;
    private String _primKeyField;
    private ApiClass _compositeKeyClass;
    private String _cmpVersion = "2.x";
    private boolean _isCMP = false;
    private DataSource _dataSource;
    private EntityGenerator _entityBean;
    private String _abstractSchemaName;
    private String _sqlTable;
    private long _cacheTimeout = 2000L;
    private int _cacheSize = -666;
    private boolean _loadLazyOnTransaction = true;
    private boolean _isReadOnly = false;
    private boolean _isReentrant = true;
    private ArrayList<CmpField> _fields = new ArrayList();
    private ArrayList<CmrRelation> _relations = new ArrayList();
    private ArrayList<ApiMethod> _stubMethods = new ArrayList();
    private EjbHomeView _remoteHomeView;
    private EjbObjectView _remoteView;
    private EjbHomeView _localHomeView;
    private EjbObjectView _localView;

    public EjbEntityBean(EjbConfig ejbConfig, String ejbModuleName) {
        super(ejbConfig, ejbModuleName);
    }

    @Override
    public String getEJBKind() {
        return "entity";
    }

    @Override
    public void setEJBClass(Class ejbClass) throws ConfigException {
        super.setEJBClass(ejbClass);
        if (!EntityBean.class.isAssignableFrom(ejbClass) && !this.isAllowPOJO()) {
            throw this.error(L.l("'{0}' must implement EntityBean.  Entity beans must implement javax.ejb.EntityBean.", (Object)ejbClass.getName()));
        }
        this.validateNonFinalMethod("setEntityContext", new Class[]{EntityContext.class}, this.isAllowPOJO());
        this.validateNonFinalMethod("unsetEntityContext", new Class[0], this.isAllowPOJO());
        this.validateNonFinalMethod("ejbActivate", new Class[0], this.isAllowPOJO());
        this.validateNonFinalMethod("ejbPassivate", new Class[0], this.isAllowPOJO());
        this.validateNonFinalMethod("ejbRemove", new Class[0], this.isAllowPOJO());
        this.validateNonFinalMethod("ejbLoad", new Class[0], this.isAllowPOJO());
        this.validateNonFinalMethod("ejbStore", new Class[0], this.isAllowPOJO());
    }

    public EntityType getEntityType() {
        AmberPersistenceUnit amberPersistenceUnit = this.getEjbContainer().createEjbPersistenceUnit();
        EntityType type = amberPersistenceUnit.createEntity(this.getAbstractSchemaName(), JClassWrapper.create(this.getEJBClassWrapper().getJavaClass()));
        if (this.getLocalList().size() > 0) {
            type.setProxyClass(JClassWrapper.create(this.getLocalList().get(0).getJavaClass()));
        }
        return type;
    }

    public ApiClass getPrimKeyClass() {
        return this._primKeyClass;
    }

    public void setPrimKeyClass(Class cl) {
        this._primKeyClass = new ApiClass(cl);
    }

    public ApiClass getCompositeKeyClass() {
        return this._compositeKeyClass;
    }

    public String getPrimKeyField() {
        return this._primKeyField;
    }

    public void setPrimKeyField(String field) {
        this._primKeyField = field;
    }

    public void setPersistenceType(String type) throws ConfigException {
        if ("Bean".equals(type)) {
            this._isCMP = false;
        } else if ("Container".equals(type)) {
            this._isCMP = true;
        } else {
            throw new ConfigException(L.l("'{0}' is an known persistence-type.  <persistence-type> must either be 'Bean' or 'Container'.", (Object)type));
        }
    }

    @Override
    public boolean isCMP() {
        return this._isCMP && "2.x".equals(this._cmpVersion);
    }

    public void setCMP(boolean isCMP) {
        this._isCMP = isCMP;
    }

    @Override
    public boolean isCMP1() {
        return this._isCMP && "1.x".equals(this._cmpVersion);
    }

    @Override
    public String getFullImplName() {
        if (this.isCMP()) {
            String name = "_ejb." + this.getEJBName() + "." + this.getEJBClassName() + "__Amber";
            return JavaClassGenerator.cleanClassName(name);
        }
        return super.getFullImplName();
    }

    public ApiClass getLocal() {
        return this.getLocalList().get(0);
    }

    public void setCmpVersion(String version) throws ConfigException {
        this._cmpVersion = version;
        if (!version.equals("1.x") && !version.equals("2.x")) {
            throw this.error(L.l("CMP version '{0}' is not currently supported.  Only CMP version 1.x and 2.x are supported.", (Object)version));
        }
    }

    public void setReentrant(boolean reentrant) throws ConfigException {
        this._isReentrant = reentrant;
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public String getAbstractSchemaName() {
        if (this._abstractSchemaName != null) {
            return this._abstractSchemaName;
        }
        String name = this.getEJBName();
        int p = name.lastIndexOf(47);
        if (p < 0) {
            return name;
        }
        return name.substring(p + 1);
    }

    public void setAbstractSchemaName(String abstractSchema) throws ConfigException {
        this._abstractSchemaName = abstractSchema;
        EjbEntityBean bean = this.getConfig().findEntityBySchema(abstractSchema);
        if (bean != null && this != bean) {
            throw new ConfigException(L.l("Entity bean '{0}' already has abstract schema '{1}'.  abstract-schema-name values must be distinct.", (Object)bean.getEJBName(), (Object)abstractSchema));
        }
    }

    public String getSQLTable() {
        return this._sqlTable;
    }

    public void setSQLTable(String sqlTable) {
        this._sqlTable = sqlTable;
    }

    public int getCacheSize() {
        return this._cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this._cacheSize = cacheSize;
    }

    public void setCacheTimeout(Period cacheTimeout) {
        this._cacheTimeout = cacheTimeout.getPeriod();
    }

    public long getCacheTimeout() {
        return this._cacheTimeout;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this._isReadOnly = isReadOnly;
    }

    public CmpFieldProxy createCmpField() {
        return new CmpFieldProxy(this);
    }

    public ArrayList<CmpField> getCmpFields() {
        return this._fields;
    }

    public CmpField getCmpField(String fieldName) {
        for (int i = 0; i < this._fields.size(); ++i) {
            CmpField field = this._fields.get(i);
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public CmpField addField(String fieldName) throws ConfigException {
        CmpField field = this.getCmpField(fieldName);
        if (field == null) {
            field = new CmpField(this);
            field.setFieldName(fieldName);
            field.init();
            this._fields.add(field);
        }
        return field;
    }

    public ApiMethod getFieldGetter(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        String methodName = "get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        try {
            return EjbEntityBean.getMethod(this.getEJBClassWrapper(), methodName, new Class[0]);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public void addRelation(CmrRelation relation) throws ConfigException {
        String fieldName = relation.getName();
        ApiMethod method = this.getMethodField(fieldName);
        if (method == null && !(relation instanceof CmrMap)) {
            throw this.error(L.l("'{0}' is a missing method", (Object)fieldName));
        }
        this._relations.add(relation);
    }

    public CmrRelation getRelation(String relationName) {
        for (int i = 0; i < this._relations.size(); ++i) {
            CmrRelation relation = this._relations.get(i);
            if (!relationName.equals(relation.getName())) continue;
            return relation;
        }
        return null;
    }

    public ArrayList<CmrRelation> getRelations() {
        return this._relations;
    }

    public ArrayList<ApiMethod> getStubMethods() {
        return this._stubMethods;
    }

    public void addStubMethod(ApiMethod method) {
        if (!this._stubMethods.contains(method)) {
            this._stubMethods.add(method);
        }
    }

    public Class getFieldType(String fieldName) {
        ApiMethod method = this.getMethodField(fieldName);
        if (method != null) {
            return method.getReturnType();
        }
        return null;
    }

    public Query createQuery() {
        return new Query(this);
    }

    public void addQuery(Query query) {
        MethodSignature sig = query.getSignature();
        EjbMethodPattern method = this.getMethod(sig);
        if (method == null) {
            method = new EjbMethodPattern(this, sig);
            method.setLocation(query.getConfigLocation());
            this._methodList.add(method);
        }
        method.setQueryLocation(query.getConfigLocation());
        method.setQuery(query.getEjbQl());
    }

    public EjbMethodPattern getMethod(MethodSignature sig) {
        for (int i = 0; i < this._methodList.size(); ++i) {
            EjbMethodPattern method = (EjbMethodPattern)this._methodList.get(i);
            if (!method.getSignature().equals(sig)) continue;
            return method;
        }
        return null;
    }

    public EjbMethodPattern getQuery(ApiMethod method, String intf) {
        return this.getMethodPattern(method, intf);
    }

    public ArrayList<EjbMethodPattern> getQueryList() {
        return this._methodList;
    }

    @Override
    protected BeanGenerator createBeanGenerator() {
        this._entityBean = new EntityGenerator(this);
        return this._entityBean;
    }

    @Override
    @PostConstruct
    public void init() throws ConfigException {
        try {
            if (!this.isCMP() && this.getEJBClassWrapper().isAbstract()) {
                throw this.error(L.l("'{0}' must not be abstract. BMP entity beans may not be abstract.", (Object)this.getEJBClass().getName()));
            }
            super.init();
            if (!(this._primKeyClass != null || this.isAllowPOJO() || this.getRemoteList().size() <= 0 && this.getLocalList().size() <= 0)) {
                throw new ConfigException(L.l("{0}: <entity> has no primary key class.  Entity beans must define a prim-key-class.", (Object)this.getEJBClass().getName()));
            }
            if (this.getRemoteHome() != null) {
                this.validateHome(this.getRemoteHome());
            }
            if (this.getLocalHome() != null) {
                this.validateHome(this.getLocalHome());
            }
            for (ApiClass remote : this.getRemoteList()) {
                this.validateRemote(remote);
            }
            for (ApiClass local : this.getLocalList()) {
                this.validateRemote(local);
            }
            this.validateMethods();
        }
        catch (ConfigException e) {
            throw ConfigException.create((String)this.getLocation(), (Throwable)e);
        }
    }

    @Override
    protected void createViews21() throws ConfigException {
        ArrayList<ApiClass> list;
        if (this._remoteHome != null) {
            this._remoteHomeView = this.createHomeView(this._remoteHome, "RemoteHome");
            this._remoteHomeView.introspect();
        }
        if (this._remoteList.size() > 0) {
            list = new ArrayList<ApiClass>();
            list.addAll(this._remoteList);
            this._remoteView = this.createRemoteObjectView(list, "Remote", "21");
            this._remoteView.introspect();
        }
        if (this._localHome != null) {
            this._localHomeView = this.createHomeView(this._localHome, "LocalHome");
            this._localHomeView.introspect();
        }
        if (this._localList.size() > 0) {
            list = new ArrayList();
            list.addAll(this._localList);
            if (list.size() > 0) {
                this._localView = this.createObjectView(list, "Local", "");
                this._localView.introspect();
            }
        }
    }

    @Override
    protected void assembleViews(BeanAssembler assembler, String fullClassName) throws ConfigException {
        if (this._remoteHomeView != null) {
            this._remoteHomeView.assembleView(assembler, fullClassName);
        }
        if (this._remoteView != null) {
            this._remoteView.assembleView(assembler, fullClassName);
        }
        if (this._localHomeView != null) {
            this._localHomeView.assembleView(assembler, fullClassName);
        }
        if (this._localView != null) {
            this._localView.assembleView(assembler, fullClassName);
        }
    }

    @Override
    public void initIntrospect() throws ConfigException {
        if (this.isCMP()) {
            this.introspectCMPFields();
            this.introspectCMPId();
            this.validateCMPFields();
        }
    }

    protected void introspectCMPFields() throws ConfigException {
        for (ApiMethod method : this.getEJBClassWrapper().getMethods()) {
            String fieldName;
            CmrRelation rel;
            String name;
            if (!method.isAbstract() || !(name = method.getName()).startsWith("get") || name.length() <= 3 || method.getParameterTypes().length != 0 || (rel = this.getRelation(fieldName = EjbEntityBean.getterToFieldName(name))) != null) continue;
            Class type = method.getReturnType();
            if (Collection.class.isAssignableFrom(type)) {
                throw this.error(L.l("'{0}' needs to be a relation", (Object)fieldName));
            }
            if (Map.class.isAssignableFrom(type)) {
                throw this.error(L.l("'{0}' needs to be a relation", (Object)fieldName));
            }
            if (EJBLocalObject.class.isAssignableFrom(type)) {
                throw this.error(L.l("{0}: '{1}' needs to be defined in an ejb-relation for getter method {2}.", (Object)this.getEJBClass().getName(), (Object)fieldName, (Object)method.getFullName()));
            }
            if (EJBObject.class.isAssignableFrom(type)) {
                throw this.error(L.l("'{0}' needs to be a relation", (Object)fieldName));
            }
            CmpField cmpField = this.addField(fieldName);
            cmpField.setJavaType(method.getReturnType());
        }
    }

    protected void validateCMPFields() throws ConfigException {
        for (ApiMethod method : this.getEJBClassWrapper().getMethods()) {
            String fieldName;
            String name;
            if (!method.isAbstract() || (name = method.getName()).startsWith("ejb")) continue;
            if (name.startsWith("get") && name.length() > 3 && method.getParameterTypes().length == 0) {
                fieldName = EjbEntityBean.getterToFieldName(name);
                if (this.getCmpField(fieldName) != null || this.getRelation(fieldName) != null) {
                    continue;
                }
            } else if (name.startsWith("get") && name.length() > 3 && method.getParameterTypes().length == 1) {
                CmrMap map;
                fieldName = EjbEntityBean.getterToFieldName(name);
                CmrRelation rel = this.getRelation(fieldName);
                if (rel instanceof CmrMap && method.equals((map = (CmrMap)rel).getMapMethod())) {
                    continue;
                }
            } else if (name.startsWith("set") && name.length() > 3 && method.getParameterTypes().length == 1) {
                fieldName = EjbEntityBean.getterToFieldName(name);
                CmpField field = this.getCmpField(fieldName);
                if (field != null) {
                    if (method.isMatch(field.getSetter())) continue;
                    throw new ConfigException(L.l("{0}: '{1}' does not match the corresponding cmp-field getter '{2}'.", (Object)this.getEJBClass().getName(), (Object)method.getFullName(), (Object)field.getGetter().getFullName()));
                }
                CmrRelation rel = this.getRelation(fieldName);
                if (rel != null) {
                    if (method.equals(rel.getSetter())) continue;
                    throw new ConfigException(L.l("{0}: '{1}' does not match the corresponding cmp-field getter '{2}'.", (Object)this.getEJBClass().getName(), (Object)method.getFullName(), (Object)rel.getGetter().getFullName()));
                }
            }
            throw this.error(L.l("{0}: '{1}' must not be abstract.  Business methods must be implemented.", (Object)this.getEJBClass().getName(), (Object)method.getFullName()));
        }
    }

    protected void introspectCMPId() throws ConfigException {
        CmpProperty property;
        if (!(this._primKeyClass == null || this._primKeyClass.isPrimitive() || this._primKeyClass.getName().startsWith("java.lang.") || this._primKeyClass.getName().equals("java.util.Date") || this._primKeyClass.getName().equals("java.sql.Date") || this._primKeyClass.getName().equals("java.sql.Time") || this._primKeyClass.getName().equals("java.sql.Timestamp") || EJBLocalObject.class.isAssignableFrom(this._primKeyClass.getJavaClass()))) {
            if (this._primKeyField != null) {
                throw this.error(L.l("{0}: 'primkey-field' must not be defined for a composite primkey-class.", (Object)this.getEJBClass().getName()));
            }
            this._compositeKeyClass = this._primKeyClass;
            this.introspectCMPCompositeId();
            return;
        }
        String id = this._primKeyField;
        if (id == null) {
            id = "id";
        }
        if ((property = this.getCmpField(id)) == null) {
            property = this.getRelation(id);
        }
        if (property == null) {
            throw this.error(L.l("{0}: primary key field '{1}' is an unknown cmp-field", (Object)this.getEJBClass().getName(), (Object)id));
        }
        property.setId(true);
    }

    protected void introspectCMPCompositeId() throws ConfigException {
        try {
            ApiMethod equals = this._primKeyClass.getMethod("equals", new Class[]{Object.class});
            if (equals.getDeclaringClass().equals(Object.class)) {
                throw this.error(L.l("{0}: primary key class '{1}' must override the 'equals' method.", (Object)this.getEJBClass().getName(), (Object)this._primKeyClass.getName()));
            }
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            ApiMethod hashCode = this._primKeyClass.getMethod("hashCode", new Class[0]);
            if (hashCode.getDeclaringClass().getName().equals(Object.class.getName())) {
                throw this.error(L.l("{0}: primary key class '{1}' must override the 'hashCode' method.", (Object)this.getEJBClass().getName(), (Object)this._primKeyClass.getName()));
            }
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (this._primKeyClass.getFields().length == 0) {
            throw this.error(L.l("{0}: compound key '{1}' has no public accessible fields.  Compound key fields must be public.", (Object)this.getEJBClass().getName(), (Object)this._primKeyClass.getName()));
        }
        for (Field field : this._primKeyClass.getFields()) {
            CmpProperty cmpProperty = this.getCmpField(field.getName());
            if (cmpProperty == null) {
                cmpProperty = this.getRelation(field.getName());
            }
            if (cmpProperty == null) {
                throw this.error(L.l("{0}: primary key field '{1}' is an unknown field.", (Object)this.getEJBClass().getName(), (Object)field.getName()));
            }
            cmpProperty.setId(true);
        }
    }

    private static String getterToFieldName(String name) {
        String fieldName = name.substring(3);
        char ch = fieldName.charAt(0);
        if (Character.isUpperCase(ch) && (fieldName.length() == 1 || Character.isLowerCase(fieldName.charAt(1)))) {
            fieldName = Character.toLowerCase(ch) + fieldName.substring(1);
        }
        return fieldName;
    }

    @Override
    public void configureAmber(AmberConfig config) throws ConfigException {
        if (this.isCMP()) {
            try {
                config.addBean(this);
            }
            catch (Exception e) {
                throw ConfigException.create((String)this.getLocation(), (Throwable)e);
            }
        }
    }

    @Override
    protected BeanAssembler createAssembler(String fullClassName) {
        if (this.isCMP()) {
            return new AmberAssembler(this, fullClassName);
        }
        return new EntityAssembler(this, fullClassName);
    }

    @Override
    protected void addImports(BeanAssembler assembler) {
        super.addImports(assembler);
        assembler.addImport("com.caucho.ejb.FinderExceptionWrapper");
        assembler.addImport("com.caucho.ejb.entity.EntityServer");
        assembler.addImport("com.caucho.ejb.entity.QEntityContext");
        assembler.addImport("com.caucho.ejb.entity.EntityHome");
        assembler.addImport("com.caucho.ejb.entity.EntityLocalHome");
        assembler.addImport("com.caucho.ejb.entity.EntityRemoteHome");
        assembler.addImport("com.caucho.ejb.entity.EntityObject");
        assembler.addImport("com.caucho.ejb.entity.QEntity");
    }

    @Override
    protected EjbBaseMethod introspectEJBMethod(ApiMethod method) throws ConfigException {
        String methodName = method.getName();
        Class[] paramTypes = method.getParameterTypes();
        if (methodName.startsWith("ejbSelect") && method.isAbstract()) {
            this.validateSelectMethod(method);
            EjbMethodPattern pattern = this.getMethodPattern(method, "Local");
            if (pattern == null) {
                throw this.error(L.l("{0}: '{1}' expects an ejb-ql query. ejbSelect methods must have an ejb-ql query in the deployment descriptor.", (Object)this.getEJBClass().getName(), (Object)method.getFullName()));
            }
            String query = pattern.getQuery();
            EjbAmberSelectMethod select = new EjbAmberSelectMethod(this, method, query, pattern.getQueryLocation());
            select.setQueryLoadsBean(pattern.getQueryLoadsBean());
            return select;
        }
        return null;
    }

    @Override
    protected void validateImplMethod(ApiMethod method) throws ConfigException {
        String methodName = method.getName();
        Class[] paramTypes = method.getParameterTypes();
        if (!(method.isAbstract() && methodName.startsWith("get") && paramTypes.length == 0 || method.isAbstract() && methodName.startsWith("get") && paramTypes.length == 1 || method.isAbstract() && methodName.startsWith("set") && paramTypes.length == 1 || methodName.startsWith("ejb") || !method.isAbstract())) {
            throw this.error(L.l("{0}: '{1}' must not be abstract.  The bean must implement its business methods.", (Object)this.getEJBClass().getName(), (Object)method.getFullName()));
        }
    }

    private void validateSelectMethod(ApiMethod method) throws ConfigException {
        if (!method.isPublic()) {
            throw this.error(L.l("{0}: '{1}' must be public. ejbSelect methods must be public.", (Object)this.getEJBClass().getName(), (Object)method.getFullName()));
        }
        if (method.isStatic()) {
            throw this.error(L.l("{0}: '{1}' must not be static. ejbSelect methods must not be static.", (Object)this.getEJBClass().getName(), (Object)method.getFullName()));
        }
        if (!method.isAbstract()) {
            throw this.error(L.l("{0}: '{1}' must be abstract. ejbSelect methods must be abstract.", (Object)this.getEJBClass().getName(), (Object)method.getFullName()));
        }
    }

    @Override
    protected EjbHomeView createHomeView(ApiClass homeClass, String prefix) throws ConfigException {
        return new EjbEntityHomeView(this, homeClass, prefix);
    }

    @Override
    protected EjbObjectView createObjectView(ArrayList<ApiClass> apiList, String prefix, String suffix) throws ConfigException {
        if (this.isCMP()) {
            return new EjbCmpView(this, apiList, prefix);
        }
        return new EjbEntityView(this, apiList, prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractServer deployServer(EjbContainer ejbManager, JavaClassGenerator javaGen) throws ClassNotFoundException {
        EntityServer server = new EntityServer(ejbManager);
        server.setModuleName(this.getEJBModuleName());
        server.setEJBName(this.getEJBName());
        server.setMappedName(this.getMappedName());
        server.setId(this.getEJBModuleName() + "#" + this.getEJBName());
        server.setRemoteHomeClass(this.getRemoteHomeClass());
        server.setRemoteObjectClass(this.getRemoteClass());
        AmberPersistenceUnit ejbAmber = ejbManager.createEjbPersistenceUnit();
        if (ejbAmber != null) {
            javaGen.setLoader(ejbAmber.getEnhancedLoader());
        }
        Class contextImplClass = javaGen.loadClass(this.getSkeletonName());
        server.setContextImplClass(contextImplClass);
        server.setCMP(this.isCMP());
        if (this._primKeyClass != null) {
            server.setPrimaryKeyClass(this._primKeyClass.getJavaClass());
        }
        server.setLoadLazyOnTransaction(this._loadLazyOnTransaction);
        server.setInitProgram(this.getInitProgram());
        if (this.isCMP()) {
            server.setAmberEntityHome(this.getEntityType().getHome());
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(server.getClassLoader());
            try {
                if (this.getServerProgram() != null) {
                    this.getServerProgram().configure(server);
                }
            }
            catch (ConfigException e) {
                throw e;
            }
            catch (Exception e) {
                throw ConfigException.create((Throwable)e);
            }
            Object var10_10 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
        return server;
    }

    private void validateMethods() throws ConfigException {
        ApiClass primKeyClass = this.getPrimKeyClass();
        for (ApiMethod method : this.getEJBClassWrapper().getMethods()) {
            String name = method.getName();
            try {
                ApiMethod cleanMethod = this.getEJBClassWrapper().getMethod(name, method.getParameterTypes());
                if (cleanMethod != null) {
                    method = cleanMethod;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (EntityBean.class.isAssignableFrom(method.getReturnType())) {
                throw this.error(L.l("{0}: '{1}' must not return entity bean '{2}'.  Entity bean methods must always return local or remote interfaces.", (Object)this.getEJBClass().getName(), (Object)method.getFullName(), (Object)method.getReturnType().getSimpleName()));
            }
            if (name.startsWith("ejbFind")) {
                if (!this.isCMP()) {
                    this.validateNonFinalMethod(method.getName(), method.getParameterTypes());
                    continue;
                }
                this.validateNonFinalMethod(method.getName(), method.getParameterTypes());
                continue;
            }
            if (name.startsWith("ejbSelect")) {
                if (!method.isAbstract()) {
                    throw this.error(L.l("{0}: '{1}' must be abstract. ejbSelect methods must be abstract.", (Object)method.getDeclaringClass().getName(), (Object)method.getFullName()));
                }
                if (!method.isPublic()) {
                    throw this.error(L.l("{0}: '{1}' must be public.", (Object)method.getDeclaringClass().getName(), (Object)method.getFullName()));
                }
                this.validateException(method, FinderException.class);
                continue;
            }
            if (name.startsWith("ejbCreate")) {
                this.validateNonFinalMethod(method.getName(), method.getParameterTypes());
                if (!this.isPrimaryKeyClass(method.getReturnType())) {
                    throw this.error(L.l("{0}: '{1}' must return '{2}'.  ejbCreate methods must return the primary key.", (Object)method.getDeclaringClass().getName(), (Object)method.getFullName(), (Object)primKeyClass.getName()));
                }
                if (!this.isCMP()) continue;
                this.validateException(method, CreateException.class);
                continue;
            }
            if (name.startsWith("ejbPostCreate")) {
                this.validateNonFinalMethod(method.getName(), method.getParameterTypes());
                if (method.getReturnType().getName().equals("void")) continue;
                throw this.error(L.l("{0}: '{1}' must return void. ejbPostCreate methods must return void.", (Object)method.getDeclaringClass().getName(), (Object)method.getFullName()));
            }
            if (name.startsWith("create") && method.isAbstract()) continue;
            if (name.startsWith("ejbHome")) {
                this.validateNonFinalMethod(method.getName(), method.getParameterTypes());
                continue;
            }
            if (name.equals("ejbRemove")) {
                if (method.getParameterTypes().length == 0) continue;
                throw this.error(L.l("{0}: '{1}' must have no arguments.", (Object)method.getDeclaringClass().getName(), (Object)method.getFullName()));
            }
            if (name.equals("ejbTimeout")) {
                Class[] types = method.getParameterTypes();
                if (types.length == 1 && types[0].getName().equals("javax.ejb.Timer")) continue;
                throw this.error(L.l("{0}: '{1}' must have one javax.ejb.Timer argument.", (Object)method.getDeclaringClass().getName(), (Object)method.getFullName()));
            }
            if (ApiClass.ENTITY_BEAN.getMethod(method) != null) continue;
            if (name.equals("finalize") && method.getParameterTypes().length == 0 && !method.getDeclaringClass().getName().equals("java.lang.Object")) {
                throw this.error(L.l("{0}: Entity beans must not define 'finalize'.", this.getEJBClass().getClass()));
            }
            if (name.startsWith("ejb")) {
                throw this.error(L.l("{0}: '{1}' must not start with 'ejb'.  ejbXXX methods are reserved by the EJB spec.", (Object)method.getDeclaringClass().getName(), (Object)method.getFullName()));
            }
            boolean isAbstract = method.isAbstract();
            Object persist = null;
            if (!isAbstract || !this.isCMP() || method.getName().startsWith("get") || method.getName().startsWith("set") || method.getName().startsWith("ejbSelect")) continue;
            throw this.error(L.l("{0}: '{1}' must not be abstract.  Only CMP methods may be abstract.", (Object)method.getDeclaringClass().getName(), (Object)method.getFullName()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateHome(ApiClass homeClass) throws ConfigException {
        ApiClass beanClass = this.getEJBClassWrapper();
        String beanName = beanClass.getName();
        String homeName = homeClass.getName();
        ApiClass objectClass = EJBHome.class.isAssignableFrom(homeClass.getJavaClass()) ? this.getRemoteList().get(0) : this.getLocal();
        String objectName = objectClass != null ? objectClass.getName() : null;
        boolean hasFindByPrimaryKey = false;
        ApiClass primKeyClass = this.getPrimKeyClass();
        if (!homeClass.isPublic()) {
            throw this.error(L.l("'{0}' must be public. Entity beans must be public.", (Object)homeName));
        }
        if (beanClass.isFinal()) {
            throw this.error(L.l("'{0}' must not be final.  Entity beans must not be final.", (Object)beanName));
        }
        if (!this.isCMP() && beanClass.isAbstract()) {
            throw this.error(L.l("'{0}' must not be abstract. BMP entity beans must not be abstract.", (Object)beanName));
        }
        if (!homeClass.isInterface()) {
            throw this.error(L.l("'{0}' must be an interface.", (Object)homeName));
        }
        for (ApiMethod method : homeClass.getMethods()) {
            ApiMethod implMethod;
            String name = method.getName();
            Class[] param = method.getParameterTypes();
            Class retType = method.getReturnType();
            if (method.getDeclaringClass().isAssignableFrom(EJBHome.class) || method.getDeclaringClass().isAssignableFrom(EJBLocalHome.class)) continue;
            if (EJBHome.class.isAssignableFrom(homeClass.getJavaClass())) {
                this.validateException(method, RemoteException.class);
            }
            if (name.startsWith("create")) {
                this.validateException(method, CreateException.class);
                if (!retType.equals(objectClass.getJavaClass())) {
                    throw this.error(L.l("{0}: '{1}' must return {2}.  Create methods must return the local or remote interface.", (Object)homeName, (Object)method.getFullName(), (Object)objectName));
                }
                String createName = "ejbC" + name.substring(1);
                implMethod = this.validateNonFinalMethod(createName, param, method, homeClass);
                if (!this.isPrimaryKeyClass(implMethod.getReturnType())) {
                    throw this.error(L.l("{0}: '{1}' must return '{2}'.  ejbCreate methods must return the primary key.", (Object)beanName, (Object)EjbEntityBean.getFullMethodName(createName, param), (Object)primKeyClass.getName()));
                }
                if (!this.hasException(implMethod, CreateException.class)) {
                    throw this.error(L.l("{0}: '{1}' must throw {2}.  ejbCreate methods must throw CreateException.", (Object)implMethod.getDeclaringClass().getName(), (Object)implMethod.getFullName(), (Object)"CreateException"));
                }
                this.validateExceptions(method, implMethod);
                createName = "ejbPostC" + name.substring(1);
                implMethod = this.validateNonFinalMethod(createName, param, method, homeClass);
                if (!implMethod.getReturnType().getName().equals("void")) {
                    throw this.error(L.l("{0}: '{1}' must return {2}. ejbPostCreate methods must return void.", (Object)beanName, (Object)EjbEntityBean.getFullMethodName(createName, param), (Object)"void"));
                }
                this.validateExceptions(method, implMethod);
                continue;
            }
            if (name.startsWith("find")) {
                String query;
                if (name.equals("findByPrimaryKey")) {
                    hasFindByPrimaryKey = true;
                    if (!objectClass.getJavaClass().equals(method.getReturnType())) {
                        throw this.error(L.l("{0}: '{1}' must return '{2}'.  Find methods must return the remote or local interface.", (Object)homeName, (Object)method.getFullName(), (Object)objectName));
                    }
                }
                String findName = "ejbF" + name.substring(1);
                if (!this.isCMP() && !this.isCMP1() || EjbEntityBean.getMethod(beanClass, findName, param) != null) {
                    ApiMethod impl = this.validateNonFinalMethod(findName, param, this.isAllowPOJO());
                    if (impl != null) {
                        this.validateExceptions(method, impl);
                    }
                    if (objectClass.getJavaClass().equals(method.getReturnType())) {
                        if (impl != null && !this.isPrimaryKeyClass(impl.getReturnType())) {
                            throw this.error(L.l("{0}: '{1}' must return primary key '{2}'.  ejbFind methods must return the primary key", (Object)beanName, (Object)impl.getFullName(), (Object)primKeyClass.getName()));
                        }
                    } else if (Collection.class.isAssignableFrom(method.getReturnType())) {
                        if (impl != null && !Collection.class.isAssignableFrom(impl.getReturnType())) {
                            throw this.error(L.l("{0}: '{1}' must return collection.", (Object)beanName, (Object)impl.getFullName()));
                        }
                    } else {
                        if (!Enumeration.class.isAssignableFrom(method.getReturnType())) throw this.error(L.l("{0}: '{1}' must return '{2}' or a collection. ejbFind methods must return the primary key or a collection.", (Object)homeName, (Object)method.getFullName(), (Object)objectName));
                        if (!Enumeration.class.isAssignableFrom(impl.getReturnType())) {
                            throw this.error(L.l("{0}: '{1}' must return enumeration.", (Object)beanName, (Object)impl.getFullName()));
                        }
                    }
                } else if (this.isCMP() && !name.equals("findByPrimaryKey") && (query = this.findQuery(method)) == null) {
                    throw this.error(L.l("{0}: '{1}' expects an ejb-ql query.  All find methods need queries defined in the EJB deployment descriptor.", (Object)homeName, (Object)method.getFullName()));
                }
                this.validateException(method, FinderException.class);
                if (retType.equals(objectClass.getJavaClass()) || (Collection.class.isAssignableFrom(retType) || Enumeration.class.equals((Object)retType)) && !name.equals("findByPrimaryKey")) continue;
                throw this.error(L.l("{0}: '{1}' must return {2} or a collection. ejbFind methods must return the primary key or a collection.", (Object)homeName, (Object)method.getFullName(), (Object)objectName));
            }
            if (name.startsWith("ejbSelect")) {
                throw this.error(L.l("{0}: '{1}' forbidden.  ejbSelect methods may not be exposed in the remote or local interface.", (Object)homeName, (Object)method.getFullName()));
            }
            if (name.startsWith("ejb")) {
                throw this.error(L.l("{0}: '{1}' forbidden.  Only ejbXXX methods defined by the spec are allowed.", (Object)homeName, (Object)method.getFullName()));
            }
            if (name.startsWith("remove")) {
                throw this.error(L.l("{0}: '{1}' forbidden.  removeXXX methods are reserved by the spec.", (Object)homeName, (Object)method.getFullName()));
            }
            retType = method.getReturnType();
            if (EJBHome.class.isAssignableFrom(homeClass.getJavaClass()) && (EJBLocalObject.class.isAssignableFrom(retType) || EJBLocalHome.class.isAssignableFrom(retType))) {
                throw this.error(L.l("{1}: '{0}' must not return local interface.", (Object)homeClass.getName(), (Object)method.getFullName()));
            }
            String homeMethodName = "ejbHome" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            implMethod = this.validateMethod(homeMethodName, param, method, homeClass);
            if (!retType.equals(implMethod.getReturnType())) {
                throw this.error(L.l("{0}: '{1}' must return {2}.", (Object)beanName, (Object)implMethod.getFullName(), (Object)method.getReturnType().getName()));
            }
            this.validateExceptions(method, implMethod.getExceptionTypes());
        }
        if (hasFindByPrimaryKey || this.isAllowPOJO() || objectClass == null) return;
        throw this.error(L.l("{0}: expected '{1}'. All entity homes must define findByPrimaryKey.", (Object)homeName, (Object)EjbEntityBean.getFullMethodName("findByPrimaryKey", new Class[]{primKeyClass.getJavaClass()})));
    }

    @Override
    protected void assembleHomeMethods(BeanAssembler assembler, BaseClass baseClass, String contextClassName, ApiClass homeClass, String prefix) throws NoSuchMethodException {
        for (ApiMethod method : homeClass.getMethods()) {
            String name;
            ApiMethod beanMethod;
            String className = method.getDeclaringClass().getName();
            String methodName = method.getName();
            if (className.startsWith("javax.ejb.")) continue;
            if (methodName.startsWith("create")) {
                this.assembleCreateMethod(method, baseClass, contextClassName, prefix);
                continue;
            }
            if (methodName.startsWith("find")) {
                beanMethod = null;
                name = "ejb" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
                try {
                    beanMethod = this.getEJBClassWrapper().getMethod(name, method.getParameterTypes());
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (beanMethod == null) continue;
                EntityFindMethod findMethod = new EntityFindMethod(method, beanMethod, contextClassName, prefix);
                CallChain call = findMethod.getCall();
                call = new EntityHomePoolChain(call);
                findMethod.setCall(call);
                baseClass.addMethod(findMethod);
                continue;
            }
            beanMethod = null;
            name = "ejbHome" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
            try {
                beanMethod = this.getEJBClassWrapper().getMethod(name, method.getParameterTypes());
            }
            catch (Exception e) {
                throw new NoSuchMethodException("can't find method " + name);
            }
            CallChain call = new MethodCallChain(beanMethod.getMethod());
            call = this.getTransactionChain(call, beanMethod, method, prefix);
            baseClass.addMethod(new BaseMethod(method.getMethod(), call));
        }
    }

    protected void assembleCreateMethod(ApiMethod method, BaseClass baseClass, String contextClassName, String prefix) {
        String methodName = method.getName();
        ApiMethod beanCreateMethod = null;
        ApiMethod beanPostCreateMethod = null;
        String name = "ejb" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
        try {
            beanCreateMethod = this.getEJBClassWrapper().getMethod(name, method.getParameterTypes());
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (beanCreateMethod == null) {
            throw new IllegalStateException(name);
        }
        name = "ejbPost" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
        try {
            beanPostCreateMethod = this.getEJBClassWrapper().getMethod(name, method.getParameterTypes());
        }
        catch (Throwable e) {
            // empty catch block
        }
        EntityCreateMethod createMethod = new EntityCreateMethod(this, method, beanCreateMethod, beanPostCreateMethod, contextClassName);
        createMethod.setCall(this.getTransactionChain(createMethod.getCall(), method, method, prefix));
        baseClass.addMethod(createMethod);
    }

    private boolean isPrimaryKeyClass(Class type) {
        return type.equals(this.getPrimKeyClass().getJavaClass());
    }

    private ApiMethod getMethodField(String fieldName) {
        String getter = "get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        return this.getEJBClassWrapper().getMethod(getter, new Class[0]);
    }

    private String findQuery(ApiMethod method) throws ConfigException {
        EjbMethodPattern ejbMethod = this.getMethodPattern(method, null);
        if (ejbMethod != null && ejbMethod.getQuery() != null) {
            return ejbMethod.getQuery();
        }
        EjbMethodPattern ejbQuery = this.getQuery(method, null);
        if (ejbQuery != null) {
            return ejbQuery.getQuery();
        }
        return null;
    }

    public boolean dependsOn(EjbEntityBean target) {
        for (CmrRelation rel : this._relations) {
            EjbEntityBean targetBean;
            if (!rel.isId() || target != (targetBean = rel.getTargetBean()) && (targetBean == null || !targetBean.dependsOn(target))) continue;
            return true;
        }
        return false;
    }

    public void generateBeanPrologue(JavaWriter out) throws IOException {
    }

    public void generateAfterCommit(JavaWriter out) throws IOException {
        for (CmrRelation rel : this._relations) {
            rel.generateAfterCommit(out);
        }
    }

    public void generateDestroy(JavaWriter out) throws IOException {
        for (CmrRelation rel : this._relations) {
            rel.generateDestroy(out);
        }
    }

    @Override
    public String toString() {
        return "EjbEntityBean[" + this.getEJBName() + "]";
    }
}

