/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg21;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbMethod;
import com.caucho.ejb.cfg.EjbMethodPattern;
import com.caucho.ejb.cfg21.EjbAmberFindMethod;
import com.caucho.ejb.cfg21.EjbEntityBean;
import com.caucho.ejb.cfg21.EjbEntityCreateMethod;
import com.caucho.ejb.cfg21.EjbEntityFindMethod;
import com.caucho.ejb.cfg21.EjbHomeView;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.util.logging.Logger;

public class EjbEntityHomeView
extends EjbHomeView {
    private static final Logger log = Log.open(EjbEntityHomeView.class);
    private static final L10N L = new L10N(EjbEntityHomeView.class);
    private boolean _hasFindByPrimaryKey;

    public EjbEntityHomeView(EjbBean bean, ApiClass apiClass, String prefix) throws ConfigException {
        super(bean, apiClass, prefix);
    }

    protected boolean isCMP() {
        return ((EjbEntityBean)this.getBean()).isCMP();
    }

    protected void introspect() throws ConfigException {
        super.introspect();
        if (!this._hasFindByPrimaryKey) {
            throw new ConfigException(L.l("{0}: expected 'findByPrimaryKey'.  All entity homes must define findByPrimaryKey.", (Object)this.getApiClass().getName()));
        }
    }

    protected EjbMethod introspectEJBMethod(ApiMethod method) throws ConfigException {
        String methodName = method.getName();
        Class[] paramTypes = method.getParameterTypes();
        if (methodName.startsWith("ejbCreate")) {
            String apiMethodName = "c" + methodName.substring(4);
            ApiMethod apiMethod = this.getApiClass().getMethod(apiMethodName, paramTypes);
            if (apiMethod == null) {
                log.config(this.errorMissingMethod(this.getApiClass(), apiMethodName, method).getMessage());
                return null;
            }
            String postMethodName = "ejbPost" + methodName.substring(3);
            ApiMethod postCreateMethod = this.getImplClass().getMethod(postMethodName, method.getParameterTypes());
            return new EjbEntityCreateMethod(this, apiMethod, method, postCreateMethod);
        }
        if (methodName.startsWith("ejbFind")) {
            if (methodName.equals("ejbFindByPrimaryKey")) {
                this._hasFindByPrimaryKey = true;
                ApiClass primKeyClass = ((EjbEntityBean)this.getBean()).getPrimKeyClass();
                if (paramTypes.length != 1 || !paramTypes[0].equals(primKeyClass.getJavaClass())) {
                    throw this.error(L.l("{0}: '{1}' expected as only argument of {2}. ejbFindByPrimaryKey must take the primary key as its only argument.", (Object)method.getDeclaringClass().getName(), (Object)primKeyClass.getName(), (Object)methodName));
                }
            }
            String apiMethodName = "f" + methodName.substring(4);
            ApiMethod apiMethod = EjbBean.getMethod(this.getApiClass(), apiMethodName, paramTypes);
            if (apiMethod != null) {
                return new EjbEntityFindMethod(this, apiMethod, method);
            }
        } else if (methodName.startsWith("ejbHome")) {
            String apiMethodName = Character.toLowerCase(methodName.charAt(7)) + methodName.substring(8);
            ApiMethod apiMethod = EjbBean.getMethod(this.getApiClass(), apiMethodName, paramTypes);
            if (apiMethod == null) {
                log.config(this.errorMissingMethod(this.getApiClass(), apiMethodName, method).getMessage());
                return null;
            }
            this.validateImplMethod(method);
            return new EjbMethod(this, apiMethod, method);
        }
        return null;
    }

    protected EjbMethod introspectApiMethod(ApiMethod apiMethod) throws ConfigException {
        String methodName = apiMethod.getName();
        Class[] paramTypes = apiMethod.getParameterTypes();
        if (methodName.equals("findByPrimaryKey")) {
            this._hasFindByPrimaryKey = true;
            ApiClass primKeyClass = ((EjbEntityBean)this.getBean()).getPrimKeyClass();
            if (paramTypes.length != 1 || !paramTypes[0].equals(primKeyClass.getJavaClass())) {
                throw this.error(L.l("{0}: '{1}' expected as only argument of {2}. findByPrimaryKey must take the primary key as its only argument.", (Object)apiMethod.getDeclaringClass().getName(), (Object)primKeyClass.getName(), (Object)methodName));
            }
            return new EjbEntityFindMethod(this, apiMethod);
        }
        if (methodName.startsWith("find")) {
            if (this.isCMP()) {
                EjbMethodPattern pattern = this.findMethodPattern(apiMethod, this.getPrefix());
                if (pattern == null) {
                    throw this.error(L.l("{0}: '{1}' expects an ejb-ql query.  All find methods need queries defined in the EJB deployment descriptor.", (Object)apiMethod.getDeclaringClass().getName(), (Object)EjbEntityHomeView.getFullMethodName(apiMethod)));
                }
                String query = pattern.getQuery();
                EjbAmberFindMethod findMethod = new EjbAmberFindMethod(this, apiMethod, query, pattern.getQueryLocation());
                findMethod.setQueryLoadsBean(pattern.getQueryLoadsBean());
                return findMethod;
            }
            String name = methodName;
            name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
            throw this.errorMissingMethod(this.getImplClass(), "ejb" + name, apiMethod);
        }
        if (methodName.startsWith("create")) {
            String name = apiMethod.getName();
            name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
            throw this.errorMissingMethod(this.getImplClass(), "ejb" + name, apiMethod);
        }
        if (methodName.startsWith("ejb")) {
            throw new ConfigException(L.l("{0}: '{1}' forbidden.  ejbXXX methods are reserved by the EJB specification.", (Object)apiMethod.getDeclaringClass().getName(), (Object)EjbEntityHomeView.getFullMethodName(apiMethod)));
        }
        if (methodName.startsWith("remove")) {
            throw new ConfigException(L.l("{0}: '{1}' forbidden.  removeXXX methods are reserved by the EJB specification.", (Object)apiMethod.getDeclaringClass().getName(), (Object)EjbEntityHomeView.getFullMethodName(apiMethod)));
        }
        String name = apiMethod.getName();
        name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        throw this.errorMissingMethod(this.getImplClass(), "ejbHome" + name, apiMethod);
    }
}

