/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg21;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbMethod;
import com.caucho.ejb.cfg.EjbMethodPattern;
import com.caucho.ejb.gen21.BeanAssembler;
import com.caucho.ejb.gen21.ViewClass;
import com.caucho.java.gen.CallChain;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbView {
    private static final Logger log = Log.open(EjbView.class);
    private static final L10N L = new L10N(EjbView.class);
    private EjbBean _bean;
    private ArrayList<ApiClass> _apiList;
    private String _prefix;
    private String _suffix;
    private HashMap<String, EjbMethod> _methodMap = new HashMap();

    public EjbView(EjbBean bean, ApiClass apiClass, String prefix, String suffix) throws ConfigException {
        this._bean = bean;
        this._apiList = new ArrayList();
        this._apiList.add(apiClass);
        this._prefix = prefix;
        this._suffix = suffix;
    }

    public EjbView(EjbBean bean, ArrayList<ApiClass> apiList, String prefix, String suffix) throws ConfigException {
        this._bean = bean;
        this._apiList = apiList;
        this._prefix = prefix;
        this._suffix = suffix;
    }

    public EjbBean getBean() {
        return this._bean;
    }

    protected ApiClass getApiClass() {
        return this._apiList.get(0);
    }

    protected ArrayList<ApiClass> getApiList() {
        return this._apiList;
    }

    public ApiClass getImplClass() {
        return this._bean.getEJBClassWrapper();
    }

    public String getPrefix() {
        return this._prefix;
    }

    protected String getSuffix() {
        return this._suffix;
    }

    protected boolean isLocal() {
        return "Local".equals(this._prefix);
    }

    public ArrayList<EjbMethod> getMethods() {
        ArrayList<EjbMethod> methods = new ArrayList<EjbMethod>();
        methods.addAll(this._methodMap.values());
        return methods;
    }

    protected void introspect() throws ConfigException {
        EjbMethod ejbMethod;
        for (ApiMethod method : this.getImplClass().getMethods()) {
            ejbMethod = null;
            String name = method.getName();
            if (ApiClass.OBJECT.getMethod(name, method.getParameterTypes()) == null || name.equals("toString")) {
                ejbMethod = name.startsWith("ejb") ? this.introspectEJBMethod(method) : this.introspectBusinessMethod(method);
            }
            if (ejbMethod == null) continue;
            this._methodMap.put(EjbView.getFullMethodName(ejbMethod.getApiMethod()), ejbMethod);
        }
        for (ApiMethod method : EjbBean.getMethods(this._apiList)) {
            if (method.getDeclaringClass().getName().startsWith("javax.ejb") || ApiClass.OBJECT.getMethod(method.getName(), method.getParameterTypes()) != null || (ejbMethod = this._methodMap.get(EjbView.getFullMethodName(method))) != null || (ejbMethod = this.introspectApiMethod(method)) == null) continue;
            this._methodMap.put(EjbView.getFullMethodName(ejbMethod.getApiMethod()), ejbMethod);
            this.validateApiMethod(ejbMethod.getApiMethod());
        }
    }

    protected EjbMethod introspectEJBMethod(ApiMethod method) throws ConfigException {
        return null;
    }

    protected EjbMethod introspectBusinessMethod(ApiMethod implMethod) throws ConfigException {
        ApiMethod apiMethod = EjbBean.getMethod(this._apiList, implMethod.getName(), implMethod.getParameterTypes());
        if (apiMethod == null) {
            return null;
        }
        return this.createBusinessMethod(apiMethod, implMethod);
    }

    protected EjbMethod createBusinessMethod(ApiMethod apiMethod, ApiMethod implMethod) throws ConfigException {
        this.validateImplMethod(implMethod);
        return new EjbMethod(this, apiMethod, implMethod);
    }

    protected void validateImplMethod(ApiMethod implMethod) throws ConfigException {
        if (!implMethod.isPublic()) {
            throw this.error(L.l("{0}: '{1}' must be public.  Business method implementations must be public.", (Object)implMethod.getDeclaringClass().getName(), (Object)EjbView.getFullMethodName(implMethod)));
        }
        if (implMethod.isStatic()) {
            throw this.error(L.l("{0}: '{1}' must not be static.  Business method implementations must not be static.", (Object)implMethod.getDeclaringClass().getName(), (Object)EjbView.getFullMethodName(implMethod)));
        }
    }

    protected EjbMethod introspectApiMethod(ApiMethod apiMethod) throws ConfigException {
        if (apiMethod.getName().startsWith("ejb")) {
            throw this.error(L.l("{0}: '{1}' must not start with 'ejb'. The EJB spec reserves all methods starting with ejb.", (Object)apiMethod.getDeclaringClass().getName(), (Object)EjbView.getFullMethodName(apiMethod)));
        }
        throw this.errorMissingMethod(this.getImplClass(), apiMethod.getName(), apiMethod);
    }

    protected void validateApiMethod(ApiMethod apiMethod) throws ConfigException {
        if ("Remote".equals(this._prefix)) {
            this.validateException(apiMethod, RemoteException.class);
        }
    }

    protected ConfigException errorMissingMethod(ApiClass expectedClass, String expectedName, ApiMethod matchMethod) {
        return this.error(L.l("{0}: missing '{1}' method needed to match {2}.{3}", (Object)expectedClass.getName(), (Object)EjbView.getFullMethodName(expectedName, matchMethod.getParameterTypes()), (Object)matchMethod.getDeclaringClass().getSimpleName(), (Object)EjbView.getFullMethodName(matchMethod)));
    }

    protected void assembleView(BeanAssembler assembler, String fullClassName) throws ConfigException {
    }

    protected void assembleMethods(BeanAssembler assembler, ViewClass viewClass, String fullClassName) throws ConfigException {
        ArrayList<EjbMethod> methods = this.getMethods();
        for (int i = 0; i < methods.size(); ++i) {
            EjbMethod method = methods.get(i);
            method.assembleBean(assembler, fullClassName);
            viewClass.addMethod(method.assemble(viewClass, fullClassName));
        }
    }

    protected EjbMethodPattern findMethodPattern(ApiMethod apiMethod, String prefix) {
        return this._bean.getMethodPattern(apiMethod, prefix);
    }

    public CallChain getTransactionChain(CallChain callChain, ApiMethod apiMethod, ApiMethod implMethod, String prefix) {
        return this._bean.getTransactionChain(callChain, apiMethod, implMethod, prefix);
    }

    public CallChain getSecurityChain(CallChain callChain, ApiMethod apiMethod, String prefix) {
        return this._bean.getSecurityChain(callChain, apiMethod, prefix);
    }

    protected void validateException(ApiMethod method, Class exn) throws ConfigException {
        this._bean.validateException(method, exn);
    }

    protected void validateExceptions(ApiMethod method, Class[] exn) throws ConfigException {
        this._bean.validateExceptions(method, exn);
    }

    public static String getClassName(Class cl) {
        if (cl != null) {
            return cl.getName();
        }
        return null;
    }

    public static String getFullMethodName(ApiMethod method) {
        return EjbBean.getFullMethodName(method);
    }

    public static String getFullMethodName(String methodName, Class[] paramTypes) {
        return EjbBean.getFullMethodName(methodName, paramTypes);
    }

    public static String getShortClassName(ApiClass cl) {
        return cl.getJavaClass().getSimpleName();
    }

    public ConfigException error(String msg) {
        return new ConfigException(msg);
    }
}

