/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.entity;

import com.caucho.ejb.entity.EntityKey;
import com.caucho.ejb.entity.EntityServer;
import com.caucho.ejb.entity.QEntityContext;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityCache {
    private static final L10N L = new L10N(EntityCache.class);
    protected static final Logger log = Logger.getLogger(EntityCache.class.getName());
    private int _entityCacheSize = 32768;
    private long _entityCacheTimeout = 5000L;
    private LruCache<EntityKey, QEntityContext> _entityCache;
    private EntityKey _entityKey = new EntityKey();

    public long getCacheTimeout() {
        return this._entityCacheTimeout;
    }

    public void setCacheTimeout(long cacheTimeout) {
        this._entityCacheTimeout = cacheTimeout;
    }

    public int getCacheSize() {
        return this._entityCacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this._entityCacheSize = cacheSize;
    }

    public void start() {
        if (this._entityCache == null) {
            this._entityCache = new LruCache(this._entityCacheSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QEntityContext getEntity(EntityServer server, Object key) {
        EntityKey entityKey = this._entityKey;
        synchronized (entityKey) {
            this._entityKey.init(server, key);
            return (QEntityContext)this._entityCache.get((Object)this._entityKey);
        }
    }

    public QEntityContext putEntityIfNew(EntityServer server, Object key, QEntityContext context) {
        return (QEntityContext)this._entityCache.putIfNew((Object)new EntityKey(server, key), (Object)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntity(EntityServer server, Object key) {
        if (this._entityCache == null) {
            return;
        }
        EntityKey entityKey = this._entityKey;
        synchronized (entityKey) {
            this._entityKey.init(server, key);
            this._entityCache.remove((Object)this._entityKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBeans(ArrayList<QEntityContext> beans, EntityServer server) {
        if (this._entityCache == null) {
            return;
        }
        LruCache<EntityKey, QEntityContext> lruCache = this._entityCache;
        synchronized (lruCache) {
            Iterator iter = this._entityCache.iterator();
            while (iter.hasNext()) {
                LruCache.Entry entry = (LruCache.Entry)iter.next();
                beans.add((QEntityContext)entry.getValue());
                iter.remove();
            }
        }
    }

    public void invalidateCache() {
    }
}

