/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.gen.View;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.DependencyComponent;
import com.caucho.java.gen.GenClass;
import com.caucho.make.ClassDependency;
import com.caucho.util.L10N;
import com.caucho.vfs.PersistentDependency;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanGenerator
extends GenClass {
    private static final L10N L = new L10N(BeanGenerator.class);
    protected final ApiClass _ejbClass;
    protected DependencyComponent _dependency = new DependencyComponent();
    private Method _aroundInvokeMethod;
    private ArrayList<Class> _defaultInterceptors = new ArrayList();

    protected BeanGenerator(String fullClassName, ApiClass ejbClass) {
        super(fullClassName);
        this._ejbClass = ejbClass;
        this.addDependency(ejbClass.getJavaClass());
    }

    protected ApiClass getEjbClass() {
        return this._ejbClass;
    }

    public void setRemoteHome(ApiClass homeClass) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setLocalHome(ApiClass homeClass) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void addRemote(ApiClass remoteApi) {
    }

    public void addLocal(ApiClass localApi) {
    }

    protected void addDependency(PersistentDependency depend) {
        this._dependency.addDependency(depend);
    }

    protected void addDependency(Class cl) {
        this._dependency.addDependency(new ClassDependency(cl));
    }

    public void introspect() {
        this._aroundInvokeMethod = BeanGenerator.findAroundInvokeMethod(this._ejbClass.getJavaClass());
    }

    private static Method findAroundInvokeMethod(Class cl) {
        if (cl == null) {
            return null;
        }
        for (Method method : cl.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(AroundInvoke.class) || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(InvocationContext.class)) continue;
            return method;
        }
        return BeanGenerator.findAroundInvokeMethod(cl.getSuperclass());
    }

    public Method getAroundInvokeMethod() {
        return this._aroundInvokeMethod;
    }

    public void setAroundInvokeMethod(Method method) {
        this._aroundInvokeMethod = method;
    }

    public void addInterceptor(Class cl) {
        this._defaultInterceptors.add(cl);
    }

    public ArrayList<Class> getDefaultInterceptors() {
        return this._defaultInterceptors;
    }

    public ArrayList<View> getViews() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void createViews() {
    }

    public void generateViews(JavaWriter out) throws IOException {
        for (View view : this.getViews()) {
            out.println();
            view.generate(out);
        }
    }

    public void generateDestroyViews(JavaWriter out) throws IOException {
        for (View view : this.getViews()) {
            out.println();
            view.generateDestroy(out);
        }
    }

    protected void generateDependency(JavaWriter out) throws IOException {
        this._dependency.generate(out);
    }

    protected boolean hasMethod(String methodName, Class[] paramTypes) {
        return this._ejbClass.hasMethod(methodName, paramTypes);
    }

    private String generateTypeCasting(String value, Class cl, boolean isEscapeString) {
        if (cl.equals(String.class)) {
            if (isEscapeString) {
                value = "\"" + value + "\"";
            }
        } else if (cl.equals(Character.class)) {
            value = "'" + value + "'";
        } else if (cl.equals(Byte.class)) {
            value = "(byte) " + value;
        } else if (cl.equals(Short.class)) {
            value = "(short) " + value;
        } else if (cl.equals(Integer.class)) {
            value = "(int) " + value;
        } else if (cl.equals(Long.class)) {
            value = "(long) " + value;
        } else if (cl.equals(Float.class)) {
            value = "(float) " + value;
        } else if (cl.equals(Double.class)) {
            value = "(double) " + value;
        }
        return value;
    }
}

