/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.gen.EjbCallChain;
import com.caucho.ejb.gen.InterceptorCallChain;
import com.caucho.ejb.gen.SecurityCallChain;
import com.caucho.ejb.gen.View;
import com.caucho.ejb.gen.XaCallChain;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class BusinessMethodGenerator
implements EjbCallChain {
    private static final L10N L = new L10N(BusinessMethodGenerator.class);
    private final View _view;
    private final ApiMethod _apiMethod;
    private final Method _implMethod;
    private String _uniqueName;
    private boolean _isEnhanced = true;
    private String[] _roles;
    private String _roleVar;
    private String _runAs;
    private XaCallChain _xa;
    private SecurityCallChain _security;
    private InterceptorCallChain _interceptor;

    public BusinessMethodGenerator(View view, ApiMethod apiMethod, Method implMethod, int index) {
        this._view = view;
        this._apiMethod = apiMethod;
        this._implMethod = implMethod;
        this._uniqueName = "_" + this._apiMethod.getName() + "_" + index;
        this._interceptor = new InterceptorCallChain(this, view);
        this._xa = this.createXa(this._interceptor);
        this._security = new SecurityCallChain(this, this._xa);
    }

    protected XaCallChain createXa(EjbCallChain next) {
        return new XaCallChain(this, next);
    }

    public View getView() {
        return this._view;
    }

    protected ApiClass getEjbClass() {
        return this._view.getEjbClass();
    }

    public Method getApiMethod() {
        return this._apiMethod.getMethod();
    }

    public Method getImplMethod() {
        return this._implMethod;
    }

    public boolean hasXA() {
        return this._xa.isEnhanced();
    }

    public void setRemove(boolean isRemove) {
    }

    public void setRemoveRetainIfException(boolean isRemoveRetainIfException) {
    }

    public XaCallChain getXa() {
        return this._xa;
    }

    public SecurityCallChain getSecurity() {
        return this._security;
    }

    public InterceptorCallChain getInterceptor() {
        return this._interceptor;
    }

    public boolean isEnhanced() {
        if (this._security.isEnhanced()) {
            return true;
        }
        if (this._xa.isEnhanced()) {
            return true;
        }
        return this._interceptor.isEnhanced();
    }

    public void introspect(Method apiMethod, Method implMethod) {
        this._security.introspect(apiMethod, implMethod);
        this._xa.introspect(apiMethod, implMethod);
        this._interceptor.introspect(apiMethod, implMethod);
    }

    public final void generatePrologueTop(JavaWriter out, HashMap prologueMap) throws IOException {
        if (!this.isEnhanced()) {
            return;
        }
        this._security.generatePrologue(out, prologueMap);
        this.generateInterceptorTarget(out);
    }

    public final void generateConstructorTop(JavaWriter out, HashMap prologueMap) throws IOException {
        if (!this.isEnhanced()) {
            return;
        }
        this._security.generateConstructor(out, prologueMap);
    }

    public final void generate(JavaWriter out, HashMap prologueMap) throws IOException {
        if (!this.isEnhanced()) {
            return;
        }
        this.generateHeader(out);
        out.println("{");
        out.pushDepth();
        this.generateContent(out);
        out.popDepth();
        out.println("}");
    }

    protected void generateInterceptorTarget(JavaWriter out) throws IOException {
        if (this._interceptor.isEnhanced()) {
            out.println();
            out.print("private ");
            out.printClass(this._implMethod.getReturnType());
            out.print(" __caucho_");
            out.print(this._apiMethod.getName());
            out.print("(");
            Class<?>[] types = this._implMethod.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                Class<?> type = types[i];
                if (i != 0) {
                    out.print(", ");
                }
                out.printClass(type);
                out.print(" a" + i);
            }
            out.println(")");
            this.generateThrows(out, this._implMethod.getExceptionTypes());
            out.println();
            out.println("{");
            out.pushDepth();
            this.generateCall(out, "super");
            out.popDepth();
            out.println("}");
        }
    }

    public void generateHeader(JavaWriter out) throws IOException {
        out.println();
        if (this._apiMethod.isPublic()) {
            out.print("public ");
        } else if (this._apiMethod.isProtected()) {
            out.print("protected ");
        } else {
            throw new IllegalStateException(this._apiMethod.toString() + " must be public or protected");
        }
        out.printClass(this._apiMethod.getReturnType());
        out.print(" ");
        out.print(this._apiMethod.getName());
        out.print("(");
        Class[] types = this._apiMethod.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            Class type = types[i];
            if (i != 0) {
                out.print(", ");
            }
            if (i == types.length - 1 && type.isArray() && this._apiMethod.isVarArgs()) {
                out.printClass(type.getComponentType());
                out.print("...");
            } else {
                out.printClass(type);
            }
            out.print(" a" + i);
        }
        out.println(")");
        if (this._implMethod != null) {
            this.generateThrows(out, this._implMethod.getExceptionTypes());
        } else {
            this.generateThrows(out, this._apiMethod.getExceptionTypes());
        }
    }

    protected void generateContent(JavaWriter out) throws IOException {
        this.generatePreCall(out);
        this._security.generateCall(out);
        this.generatePostCall(out);
    }

    public void generateConstructor(JavaWriter out, HashMap map) throws IOException {
    }

    public void generatePrologue(JavaWriter out, HashMap map) throws IOException {
    }

    protected void generateThrows(JavaWriter out, Class[] exnCls) throws IOException {
        if (exnCls.length == 0) {
            return;
        }
        out.print(" throws ");
        for (int i = 0; i < exnCls.length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.printClass(exnCls[i]);
        }
        out.println();
    }

    public void generateCall(JavaWriter out) throws IOException {
        this.generateCall(out, this.getSuper());
    }

    public void generateCall(JavaWriter out, String superVar) throws IOException {
        if (!Void.TYPE.equals(this._apiMethod.getReturnType())) {
            out.printClass(this._apiMethod.getReturnType());
            out.println(" result;");
        }
        if (!Void.TYPE.equals(this._implMethod.getReturnType())) {
            out.print("result = ");
        }
        out.print(superVar + "." + this._implMethod.getName() + "(");
        Class<?>[] types = this._implMethod.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.print(" a" + i);
        }
        out.println(");");
        if (!"super".equals(superVar)) {
            this.generatePreReturn(out);
        }
        if (!Void.TYPE.equals(this._implMethod.getReturnType())) {
            out.println("return result;");
        }
    }

    protected void generatePreCall(JavaWriter out) throws IOException {
    }

    protected String getSuper() throws IOException {
        return "super";
    }

    protected void generateThis(JavaWriter out) throws IOException {
        out.print("this");
    }

    protected void generatePreReturn(JavaWriter out) throws IOException {
    }

    protected void generatePostCall(JavaWriter out) throws IOException {
    }

    protected boolean hasException(Class exn) {
        for (Class<?> apiExn : this._implMethod.getExceptionTypes()) {
            if (!apiExn.isAssignableFrom(exn)) continue;
            return true;
        }
        return false;
    }

    boolean matches(String name, Class[] parameterTypes) {
        if (!this._apiMethod.getName().equals(name)) {
            return false;
        }
        Class[] methodTypes = this._apiMethod.getParameterTypes();
        if (methodTypes.length != parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (methodTypes[i].equals(parameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._apiMethod + "]";
    }
}

