/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.ejb.gen.AbstractCallChain;
import com.caucho.ejb.gen.BusinessMethodGenerator;
import com.caucho.ejb.gen.View;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import javax.interceptor.AroundInvoke;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.interceptor.Interceptors;
import javax.webbeans.ComponentFactory;
import javax.webbeans.InterceptorBindingType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorCallChain
extends AbstractCallChain {
    private static final L10N L = new L10N(InterceptorCallChain.class);
    private View _view;
    private BusinessMethodGenerator _next;
    private String _uniqueName;
    private Method _implMethod;
    private ArrayList<Class> _defaultInterceptors = new ArrayList();
    private ArrayList<Class> _classInterceptors = new ArrayList();
    private ArrayList<Class> _methodInterceptors = new ArrayList();
    private boolean _isExcludeDefaultInterceptors;
    private boolean _isExcludeClassInterceptors;
    private ArrayList<Class> _interceptors = new ArrayList();
    private HashMap<Class, String> _interceptorVarMap = new HashMap();
    private ArrayList<Class> _ownInterceptors = new ArrayList();

    public InterceptorCallChain(BusinessMethodGenerator next, View view) {
        super(next);
        this._next = next;
        this._view = view;
    }

    @Override
    public boolean isEnhanced() {
        return this._defaultInterceptors.size() > 0 || !this._isExcludeDefaultInterceptors && this._view.getBean().getDefaultInterceptors().size() > 0 || this._classInterceptors.size() > 0 || this._methodInterceptors.size() > 0 || this.getAroundInvokeMethod() != null;
    }

    public ArrayList<Class> getInterceptors() {
        return this._interceptors;
    }

    public Method getAroundInvokeMethod() {
        return this._view.getAroundInvokeMethod();
    }

    @Override
    public void introspect(Method apiMethod, Method implMethod) {
        ArrayList<Class> interceptors;
        if (implMethod == null) {
            return;
        }
        Class<?> apiClass = apiMethod.getDeclaringClass();
        Class<?> implClass = implMethod.getDeclaringClass();
        this._implMethod = implMethod;
        Interceptors iAnn = apiClass.getAnnotation(Interceptors.class);
        if (iAnn != null) {
            for (Class iClass : iAnn.value()) {
                this._classInterceptors.add(iClass);
            }
        }
        if (implClass != null) {
            iAnn = implClass.getAnnotation(Interceptors.class);
            if (apiMethod != implMethod && iAnn != null) {
                for (Class iClass : iAnn.value()) {
                    this._classInterceptors.add(iClass);
                }
            }
        }
        if ((iAnn = apiMethod.getAnnotation(Interceptors.class)) != null) {
            for (Class iClass : iAnn.value()) {
                this._methodInterceptors.add(iClass);
            }
        }
        if (implMethod != null) {
            iAnn = implMethod.getAnnotation(Interceptors.class);
            if (apiMethod != implMethod && iAnn != null) {
                for (Class iClass : iAnn.value()) {
                    this._methodInterceptors.add(iClass);
                }
            }
        }
        if (apiMethod.isAnnotationPresent(ExcludeClassInterceptors.class)) {
            this._isExcludeClassInterceptors = true;
        }
        if (implMethod.isAnnotationPresent(ExcludeClassInterceptors.class)) {
            this._isExcludeClassInterceptors = true;
        }
        if (apiMethod.isAnnotationPresent(ExcludeDefaultInterceptors.class)) {
            this._isExcludeDefaultInterceptors = true;
        }
        if (implMethod.isAnnotationPresent(ExcludeDefaultInterceptors.class)) {
            this._isExcludeDefaultInterceptors = true;
        }
        WebBeansContainer webBeans = WebBeansContainer.create();
        ArrayList<Annotation> interceptorTypes = new ArrayList<Annotation>();
        for (Annotation ann : implMethod.getAnnotations()) {
            Class<? extends Annotation> annType = ann.annotationType();
            if (!annType.isAnnotationPresent(InterceptorBindingType.class)) continue;
            interceptorTypes.add(ann);
        }
        if (interceptorTypes.size() > 0 && (interceptors = webBeans.findInterceptors(interceptorTypes)) != null) {
            this._methodInterceptors.addAll(interceptors);
        }
    }

    @Override
    public void generatePrologue(JavaWriter out, HashMap map) throws IOException {
        if (!this.isEnhanced()) {
            this._next.generatePrologue(out, map);
            return;
        }
        if (!this._isExcludeDefaultInterceptors) {
            this._interceptors.addAll(this._view.getBean().getDefaultInterceptors());
        }
        if (!this._isExcludeClassInterceptors && this._interceptors.size() == 0) {
            this._interceptors.addAll(this._classInterceptors);
        }
        this._interceptors.addAll(this._methodInterceptors);
        if (this._interceptors.size() == 0 && this.getAroundInvokeMethod() == null) {
            return;
        }
        this._uniqueName = "_v" + out.generateId();
        out.println();
        out.println("private static java.lang.reflect.Method " + this._uniqueName + "_method;");
        out.println("private static java.lang.reflect.Method " + this._uniqueName + "_implMethod;");
        boolean isAroundInvokePrologue = false;
        if (this.getAroundInvokeMethod() != null && map.get("ejb.around-invoke") == null) {
            isAroundInvokePrologue = true;
            map.put("ejb.around-invoke", "_caucho_aroundInvokeMethod");
            out.println("private static java.lang.reflect.Method __caucho_aroundInvokeMethod;");
        }
        out.println("private static java.lang.reflect.Method []" + this._uniqueName + "_methodChain;");
        out.println("private transient Object []" + this._uniqueName + "_objectChain;");
        Class<?> cl = this._implMethod.getDeclaringClass();
        out.println();
        out.println("static {");
        out.pushDepth();
        out.println("try {");
        out.pushDepth();
        out.print(this._uniqueName + "_method = ");
        this.generateGetMethod(out, this._implMethod.getDeclaringClass().getName(), this._implMethod.getName(), this._implMethod.getParameterTypes());
        out.println(";");
        out.println(this._uniqueName + "_method.setAccessible(true);");
        out.print(this._uniqueName + "_implMethod = ");
        this.generateGetMethod(out, this._next.getView().getBeanClassName(), "__caucho_" + this._implMethod.getName(), this._implMethod.getParameterTypes());
        out.println(";");
        out.println(this._uniqueName + "_implMethod.setAccessible(true);");
        if (isAroundInvokePrologue) {
            Method aroundInvoke = this.getAroundInvokeMethod();
            out.print("__caucho_aroundInvokeMethod = ");
            this.generateGetMethod(out, aroundInvoke.getDeclaringClass().getName(), aroundInvoke.getName(), aroundInvoke.getParameterTypes());
            out.println(";");
            out.println("__caucho_aroundInvokeMethod.setAccessible(true);");
        }
        this.generateMethodChain(out);
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  throw new RuntimeException(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
        for (Class iClass : this._interceptors) {
            String var = (String)map.get("interceptor-" + iClass.getName());
            if (var == null) {
                var = "__caucho_i" + out.generateId();
                out.println();
                out.print("private static ");
                out.printClass(ComponentFactory.class);
                out.println(" " + var + "_f;");
                out.print("private transient ");
                out.printClass(iClass);
                out.println(" " + var + ";");
                map.put("interceptor-" + iClass.getName(), var);
                this._ownInterceptors.add(iClass);
            }
            this._interceptorVarMap.put(iClass, var);
        }
        this._next.generatePrologue(out, map);
    }

    @Override
    public void generateConstructor(JavaWriter out, HashMap map) throws IOException {
        for (Class iClass : this._ownInterceptors) {
            String var = this._interceptorVarMap.get(iClass);
            out.println("if (" + var + "_f == null)");
            out.println("  " + var + "_f = com.caucho.webbeans.manager.WebBeansContainer.create().createTransient(" + iClass.getName() + ".class);");
            out.print(var + " = (");
            out.printClass(iClass);
            out.println(")" + var + "_f.get();");
        }
        this._next.generateConstructor(out, map);
    }

    @Override
    public void generateCall(JavaWriter out) throws IOException {
        Class[] exnList;
        if (this._interceptors.size() == 0 && this.getAroundInvokeMethod() == null) {
            this._next.generateCall(out);
            return;
        }
        out.println("try {");
        out.pushDepth();
        out.print("if (");
        this.generateThis(out);
        out.println("." + this._uniqueName + "_objectChain == null) {");
        out.pushDepth();
        this.generateObjectChain(out);
        out.popDepth();
        out.println("}");
        if (!Void.TYPE.equals(this._implMethod.getReturnType())) {
            out.printClass(this._implMethod.getReturnType());
            out.println(" result;");
        }
        if (!Void.TYPE.equals(this._implMethod.getReturnType())) {
            out.print("result = (");
            this.printCastClass(out, this._implMethod.getReturnType());
            out.print(") ");
        }
        out.print("new com.caucho.ejb3.gen.InvocationContextImpl(");
        this.generateThis(out);
        out.print(", ");
        this.generateThis(out);
        out.print("." + this._uniqueName + "_method, ");
        this.generateThis(out);
        out.print("." + this._uniqueName + "_implMethod, ");
        this.generateThis(out);
        out.print("." + this._uniqueName + "_methodChain, ");
        this.generateThis(out);
        out.print("." + this._uniqueName + "_objectChain, ");
        out.print("new Object[] { ");
        for (int i = 0; i < this._implMethod.getParameterTypes().length; ++i) {
            out.print("a" + i + ", ");
        }
        out.println("}).proceed();");
        this._next.generatePreReturn(out);
        if (!Void.TYPE.equals(this._implMethod.getReturnType())) {
            out.println("return result;");
        }
        out.popDepth();
        out.println("} catch (RuntimeException e) {");
        out.println("  throw e;");
        boolean isException = false;
        for (Class<Exception> clazz : exnList = this._implMethod.getExceptionTypes()) {
            if (RuntimeException.class.isAssignableFrom(clazz) || !this.isMostGeneralException(exnList, clazz)) continue;
            if (clazz.isAssignableFrom(Exception.class)) {
                isException = true;
            }
            out.println("} catch (" + clazz.getName() + " e) {");
            out.println("  throw e;");
        }
        if (!isException) {
            out.println("} catch (Exception e) {");
            out.println("  throw new RuntimeException(e);");
        }
        out.println("}");
    }

    protected void generateThis(JavaWriter out) throws IOException {
        this._next.generateThis(out);
    }

    private boolean isMostGeneralException(Class[] exnList, Class cl) {
        for (Class exn : exnList) {
            if (exn == cl || !exn.isAssignableFrom(cl)) continue;
            return false;
        }
        return true;
    }

    protected Method findInterceptorMethod(Class cl) {
        if (cl == null) {
            return null;
        }
        for (Method method : cl.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(AroundInvoke.class)) continue;
            return method;
        }
        return this.findInterceptorMethod(cl.getSuperclass());
    }

    protected void generateMethodChain(JavaWriter out) throws IOException {
        out.println(this._uniqueName + "_methodChain = new java.lang.reflect.Method[] {");
        out.pushDepth();
        for (Class iClass : this._interceptors) {
            Method method = this.findInterceptorMethod(iClass);
            if (method == null) {
                throw new IllegalStateException(L.l("Can't find @AroundInvoke in '{0}'", (Object)iClass.getName()));
            }
            this.generateGetMethod(out, method);
            out.println(", ");
        }
        if (this.getAroundInvokeMethod() != null) {
            out.println("__caucho_aroundInvokeMethod, ");
        }
        out.popDepth();
        out.println("};");
    }

    protected void generateObjectChain(JavaWriter out) throws IOException {
        this.generateThis(out);
        out.print("." + this._uniqueName + "_objectChain = new Object[] { ");
        for (Class iClass : this._interceptors) {
            this.generateThis(out);
            out.print("." + this._interceptorVarMap.get(iClass) + ", ");
        }
        if (this.getAroundInvokeMethod() != null) {
            this.generateThis(out);
            out.print(", ");
        }
        out.println("};");
    }

    protected void generateGetMethod(JavaWriter out, Method method) throws IOException {
        this.generateGetMethod(out, method.getDeclaringClass().getName(), method.getName(), method.getParameterTypes());
    }

    protected void generateGetMethod(JavaWriter out, String className, String methodName, Class[] paramTypes) throws IOException {
        out.print("com.caucho.ejb.util.EjbUtil.getMethod(");
        out.print(className + ".class");
        out.print(", \"" + methodName + "\", new Class[] { ");
        for (Class type : paramTypes) {
            out.printClass(type);
            out.print(".class, ");
        }
        out.print("})");
    }

    protected void printCastClass(JavaWriter out, Class type) throws IOException {
        if (!type.isPrimitive()) {
            out.printClass(type);
        } else if (Boolean.TYPE.equals(type)) {
            out.print("Boolean");
        } else if (Character.TYPE.equals(type)) {
            out.print("Character");
        } else if (Byte.TYPE.equals(type)) {
            out.print("Byte");
        } else if (Short.TYPE.equals(type)) {
            out.print("Short");
        } else if (Integer.TYPE.equals(type)) {
            out.print("Integer");
        } else if (Long.TYPE.equals(type)) {
            out.print("Long");
        } else if (Float.TYPE.equals(type)) {
            out.print("Float");
        } else if (Double.TYPE.equals(type)) {
            out.print("Double");
        } else {
            throw new IllegalStateException(type.getName());
        }
    }
}

