/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.gen.BeanGenerator;
import com.caucho.ejb.gen.BusinessMethodGenerator;
import com.caucho.ejb.gen.MessageView;
import com.caucho.ejb.gen.View;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ejb.MessageDrivenBean;
import javax.ejb.TransactionAttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageGenerator
extends BeanGenerator {
    private static final L10N L = new L10N(BeanGenerator.class);
    private MessageView _view;
    private ArrayList<View> _views = new ArrayList();

    public MessageGenerator(String ejbName, ApiClass ejbClass) {
        super(MessageGenerator.toFullClassName(ejbName, ejbClass.getSimpleName()), ejbClass);
    }

    private static String toFullClassName(String ejbName, String className) {
        StringBuilder sb = new StringBuilder();
        sb.append("_ejb.");
        if (!Character.isJavaIdentifierStart(ejbName.charAt(0))) {
            sb.append('_');
        }
        for (int i = 0; i < ejbName.length(); ++i) {
            char ch = ejbName.charAt(i);
            if (ch == '/') {
                sb.append('.');
                continue;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                sb.append(ch);
                continue;
            }
            sb.append('_');
        }
        sb.append(".");
        sb.append(className);
        sb.append("__EJB");
        return sb.toString();
    }

    public void setApi(ApiClass api) {
        this._view = new MessageView(this, api);
        this._views.add(this._view);
    }

    @Override
    public ArrayList<View> getViews() {
        return this._views;
    }

    @Override
    public void introspect() {
        super.introspect();
        for (View view : this.getViews()) {
            view.introspect();
        }
    }

    @Override
    public void generate(JavaWriter out) throws IOException {
        this.generateTopComment(out);
        out.println();
        out.println("package " + this.getPackageName() + ";");
        out.println();
        out.println("import com.caucho.config.*;");
        out.println("import com.caucho.ejb.*;");
        out.println("import com.caucho.ejb.message.*;");
        out.println();
        out.println("import java.util.*;");
        out.println("import java.lang.reflect.*;");
        out.println("import javax.ejb.*;");
        out.println("import javax.transaction.*;");
        out.println("import javax.transaction.xa.*;");
        out.println("import javax.resource.spi.endpoint.*;");
        out.println();
        out.println("public class " + this.getClassName() + " extends " + this.getEjbClass().getName() + " implements MessageEndpoint, CauchoMessageEndpoint");
        out.println("{");
        out.pushDepth();
        out.println();
        out.println("private static final com.caucho.ejb3.xa.XAManager _xa");
        out.println("  = new com.caucho.ejb3.xa.XAManager();");
        out.println("private static HashSet<Method> _xaMethods = new HashSet<Method>();");
        out.println();
        out.println("private MessageServer _server;");
        out.println("private XAResource _xaResource;");
        out.println("private boolean _isXa;");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("caucho.ejb.xa", "true");
        for (View view : this.getViews()) {
            view.generateBusinessPrologue(out, map);
        }
        out.println();
        out.println("public " + this.getClassName() + "(MessageServer server)");
        out.println("{");
        out.pushDepth();
        out.println("_server = server;");
        if (MessageDrivenBean.class.isAssignableFrom(this.getEjbClass().getJavaClass())) {
            out.println("setMessageDrivenContext(server.getMessageContext());");
        }
        this._view.generateBusinessConstructor(out);
        out.popDepth();
        out.println("}");
        out.println();
        out.println("static {");
        out.pushDepth();
        out.println("try {");
        out.pushDepth();
        for (BusinessMethodGenerator businessMethodGenerator : this._view.getMethods()) {
            if (!TransactionAttributeType.REQUIRED.equals((Object)businessMethodGenerator.getXa().getTransactionType())) continue;
            Method api = businessMethodGenerator.getApiMethod();
            out.print("_xaMethods.add(");
            out.printClass(api.getDeclaringClass());
            out.print(".class.getMethod(\"");
            out.print(api.getName());
            out.print("\", new Class[] { ");
            for (Class<?> cl : api.getParameterTypes()) {
                out.printClass(cl);
                out.print(".class, ");
            }
            out.println("}));");
        }
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  throw new RuntimeException(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public void __caucho_setXAResource(XAResource xaResource)");
        out.println("{");
        out.println("  _xaResource = xaResource;");
        out.println("}");
        out.println();
        out.println("public void beforeDelivery(java.lang.reflect.Method method)");
        out.println("{");
        out.println("  if (_xaMethods.contains(method)) {");
        out.println("    _isXa = (_xa.beginRequired() == null);");
        out.println("  }");
        out.println("}");
        out.println("public void afterDelivery()");
        out.println("{");
        out.println("  if (_isXa) {");
        out.println("    _isXa = false;");
        out.println("    _xa.commit();");
        out.println("  }");
        out.println("}");
        out.println();
        out.println("public void release()");
        out.println("{");
        out.pushDepth();
        if (this.getEjbClass().hasMethod("ejbRemove", new Class[0])) {
            out.println("ejbRemove();");
        }
        out.popDepth();
        out.println("}");
        this.generateViews(out);
        this.generateDependency(out);
        out.popDepth();
        out.println("}");
    }
}

