/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.gen.BusinessMethodGenerator;
import com.caucho.ejb.gen.MessageGenerator;
import com.caucho.ejb.gen.MessageMethod;
import com.caucho.ejb.gen.View;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageView
extends View {
    private static final L10N L = new L10N(MessageView.class);
    private MessageGenerator _messageBean;
    private ArrayList<BusinessMethodGenerator> _businessMethods = new ArrayList();

    public MessageView(MessageGenerator bean, ApiClass api) {
        super(bean, api);
        this._messageBean = bean;
    }

    public MessageGenerator getMessageBean() {
        return this._messageBean;
    }

    public String getContextClassName() {
        return this.getMessageBean().getClassName();
    }

    @Override
    public String getViewClassName() {
        return this.getMessageBean().getClassName();
    }

    @Override
    public ArrayList<? extends BusinessMethodGenerator> getMethods() {
        return this._businessMethods;
    }

    @Override
    public void introspect() {
        ApiClass implClass = this.getEjbClass();
        ApiClass apiClass = this.getApi();
        for (ApiMethod apiMethod : apiClass.getMethods()) {
            int index;
            BusinessMethodGenerator bizMethod;
            if (apiMethod.getDeclaringClass().equals(Object.class) || apiMethod.getDeclaringClass().getName().startsWith("javax.ejb.") && !apiMethod.getName().equals("remove") || (bizMethod = this.createMethod(apiMethod, index = this._businessMethods.size())) == null) continue;
            bizMethod.introspect(bizMethod.getApiMethod(), bizMethod.getImplMethod());
            this._businessMethods.add(bizMethod);
        }
    }

    @Override
    public void generate(JavaWriter out) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("caucho.ejb.xa", "done");
        for (BusinessMethodGenerator bizMethod : this._businessMethods) {
            bizMethod.generate(out, map);
        }
    }

    protected BusinessMethodGenerator createMethod(ApiMethod apiMethod, int index) {
        ApiMethod implMethod = this.findImplMethod(apiMethod);
        if (implMethod == null) {
            return null;
        }
        MessageMethod bizMethod = new MessageMethod(this, apiMethod, implMethod.getMethod(), index);
        return bizMethod;
    }

    protected ApiMethod findImplMethod(ApiMethod apiMethod) {
        ApiMethod implMethod = this.getEjbClass().getMethod(apiMethod);
        if (implMethod != null) {
            return implMethod;
        }
        throw ConfigException.create((Method)apiMethod.getMethod(), (String)L.l("api method has no corresponding implementation in '{0}'", (Object)this.getEjbClass().getName()));
    }
}

