/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.ejb.gen.AbstractCallChain;
import com.caucho.ejb.gen.BusinessMethodGenerator;
import com.caucho.ejb.gen.EjbCallChain;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.annotation.security.RunAs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityCallChain
extends AbstractCallChain {
    private static final L10N L = new L10N(SecurityCallChain.class);
    private BusinessMethodGenerator _bizMethod;
    private EjbCallChain _next;
    private String[] _roles;
    private String _roleVar;
    private String _runAs;

    public SecurityCallChain(BusinessMethodGenerator bizMethod, EjbCallChain next) {
        super(next);
        this._bizMethod = bizMethod;
        this._next = next;
    }

    @Override
    public boolean isEnhanced() {
        if (this._roles != null) {
            return true;
        }
        return this._runAs != null;
    }

    public void setRoles(ArrayList<String> roles) {
        this._roles = new String[roles.size()];
        roles.toArray(this._roles);
    }

    @Override
    public void introspect(Method apiMethod, Method implMethod) {
        DenyAll denyAll;
        PermitAll permitAll;
        RolesAllowed rolesAllowed;
        Class<?> cl = apiMethod.getDeclaringClass();
        RunAs runAs = cl.getAnnotation(RunAs.class);
        if (runAs != null) {
            this._runAs = runAs.value();
        }
        if ((rolesAllowed = cl.getAnnotation(RolesAllowed.class)) != null) {
            this._roles = rolesAllowed.value();
        }
        if ((permitAll = cl.getAnnotation(PermitAll.class)) != null) {
            this._roles = null;
        }
        if ((denyAll = cl.getAnnotation(DenyAll.class)) != null) {
            this._roles = new String[0];
        }
        if ((rolesAllowed = apiMethod.getAnnotation(RolesAllowed.class)) != null) {
            this._roles = rolesAllowed.value();
        }
        if ((permitAll = apiMethod.getAnnotation(PermitAll.class)) != null) {
            this._roles = null;
        }
        if ((denyAll = apiMethod.getAnnotation(DenyAll.class)) != null) {
            this._roles = new String[0];
        }
    }

    @Override
    public void generatePrologue(JavaWriter out, HashMap map) throws IOException {
        if (this._roles != null) {
            this._roleVar = "_role_" + out.generateId();
            out.print("private static String []" + this._roleVar + " = new String[] {");
            for (int i = 0; i < this._roles.length; ++i) {
                if (i != 0) {
                    out.print(", ");
                }
                out.print("\"");
                out.printJavaString(this._roles[i]);
                out.print("\"");
            }
            out.println("};");
        }
        this._next.generatePrologue(out, map);
    }

    @Override
    public void generateCall(JavaWriter out) throws IOException {
        if (this._roleVar != null) {
            out.println("com.caucho.security.SecurityContext.checkUserInRole(" + this._roleVar + ");");
            out.println();
        }
        if (this._runAs != null) {
            out.print("String oldRunAs = com.caucho.security.SecurityContext.runAs(\"");
            out.printJavaString(this._runAs);
            out.println("\");");
            out.println("try {");
            out.pushDepth();
        }
        this._next.generateCall(out);
        if (this._runAs != null) {
            out.popDepth();
            out.println("} finally {");
            out.println("  com.caucho.security.SecurityContext.runAs(oldRunAs);");
            out.println("}");
        }
    }
}

