/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.config.ConfigException;
import com.caucho.config.types.InjectionTarget;
import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.gen.BeanGenerator;
import com.caucho.ejb.gen.View;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SessionGenerator
extends BeanGenerator {
    private static final L10N L = new L10N(SessionGenerator.class);
    private ApiClass _localHome;
    private ApiClass _remoteHome;
    private ApiClass _localObject;
    private ApiClass _remoteObject;
    private ArrayList<ApiClass> _localApi = new ArrayList();
    private ArrayList<ApiClass> _remoteApi = new ArrayList();
    private ArrayList<View> _views = new ArrayList();
    protected String _contextClassName = "dummy";

    public SessionGenerator(String ejbName, ApiClass ejbClass) {
        super(SessionGenerator.toFullClassName(ejbName, ejbClass.getSimpleName()), ejbClass);
    }

    private static String toFullClassName(String ejbName, String className) {
        StringBuilder sb = new StringBuilder();
        sb.append("_ejb.");
        if (!Character.isJavaIdentifierStart(ejbName.charAt(0))) {
            sb.append('_');
        }
        for (int i = 0; i < ejbName.length(); ++i) {
            char ch = ejbName.charAt(i);
            if (ch == '/') {
                sb.append('.');
                continue;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                sb.append(ch);
                continue;
            }
            sb.append('_');
        }
        sb.append(".");
        sb.append(className);
        sb.append("__EJB");
        return sb.toString();
    }

    public boolean isStateless() {
        return false;
    }

    @Override
    public void setLocalHome(ApiClass homeApi) {
        this._localHome = homeApi;
    }

    @Override
    public void setRemoteHome(ApiClass homeApi) {
        this._remoteHome = homeApi;
    }

    public void setLocalObject(ApiClass objectApi) {
        this._localObject = objectApi;
    }

    public ApiClass getLocalObject() {
        return this._localObject;
    }

    public void setRemoteObject(ApiClass objectApi) {
        this._remoteObject = objectApi;
    }

    public ApiClass getRemoteObject() {
        return this._remoteObject;
    }

    @Override
    public void addLocal(ApiClass localApi) {
        this._localApi.add(localApi);
    }

    public ArrayList<ApiClass> getLocalApi() {
        return this._localApi;
    }

    @Override
    public void addRemote(ApiClass remoteApi) {
        this._remoteApi.add(remoteApi);
    }

    public ArrayList<ApiClass> getRemoteApi() {
        return this._remoteApi;
    }

    @Override
    public ArrayList<View> getViews() {
        return this._views;
    }

    public View getView(Class api) {
        for (View view : this._views) {
            if (!view.getApi().getName().equals(api.getName())) continue;
            return view;
        }
        return null;
    }

    @Override
    public void introspect() {
        super.introspect();
        if (this._localHome == null && this._localApi.size() == 0) {
            this._localApi = this.introspectLocalApi();
        }
        if (this._remoteHome == null && this._remoteApi.size() == 0) {
            this._remoteApi = this.introspectRemoteApi();
        }
    }

    @Override
    public void createViews() {
        View view;
        View view2;
        if (this._localHome != null) {
            view2 = this.createLocalHomeView(this._localHome);
            this._views.add(view2);
        }
        for (ApiClass api : this._localApi) {
            view = this.createLocalView(api);
            this._views.add(view);
        }
        if (this._remoteHome != null) {
            view2 = this.createRemoteHomeView(this._remoteHome);
            this._views.add(view2);
        }
        for (ApiClass api : this._remoteApi) {
            view = this.createRemoteView(api);
            this._views.add(view);
        }
        for (View view3 : this._views) {
            view3.introspect();
        }
    }

    protected View createLocalHomeView(ApiClass api) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    protected View createRemoteHomeView(ApiClass api) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    protected View createLocalView(ApiClass api) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    protected View createRemoteView(ApiClass api) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    private ArrayList<ApiClass> introspectLocalApi() {
        ArrayList<ApiClass> apiList = new ArrayList<ApiClass>();
        Local local = this.getEjbClass().getAnnotation(Local.class);
        Remote remote = this.getEjbClass().getAnnotation(Remote.class);
        if (local != null && local.value().length > 0) {
            for (Class api : local.value()) {
                apiList.add(new ApiClass(api));
            }
            return apiList;
        }
        boolean hasRemote = remote != null;
        for (ApiClass api : this.getEjbClass().getInterfaces()) {
            if (api.getJavaClass().isAnnotationPresent(Local.class)) {
                apiList.add(api);
            }
            if (!api.getJavaClass().isAnnotationPresent(Remote.class)) continue;
            hasRemote = true;
        }
        if (apiList.size() > 0 || hasRemote) {
            return apiList;
        }
        ApiClass singleApi = null;
        for (ApiClass api : this.getEjbClass().getInterfaces()) {
            Class javaApi = api.getJavaClass();
            if (javaApi.equals(Serializable.class) || javaApi.equals(Externalizable.class) || javaApi.equals(SessionBean.class) || javaApi.getName().startsWith("javax.ejb.") || javaApi.isAnnotationPresent(Remote.class)) continue;
            if (singleApi != null) {
                throw new ConfigException(L.l("{0}: does not have a unique local API.  Both '{1}' and '{2}' are local.", (Object)this.getEjbClass().getName(), (Object)singleApi.getName(), (Object)api.getName()));
            }
            singleApi = api;
        }
        if (singleApi != null) {
            apiList.add(singleApi);
            return apiList;
        }
        return apiList;
    }

    private ArrayList<ApiClass> introspectRemoteApi() {
        ArrayList<ApiClass> apiList = new ArrayList<ApiClass>();
        Remote remote = this.getEjbClass().getAnnotation(Remote.class);
        if (remote != null && remote.value().length > 0) {
            for (Class api : remote.value()) {
                apiList.add(new ApiClass(api));
            }
            return apiList;
        }
        for (ApiClass api : this.getEjbClass().getInterfaces()) {
            Class javaApi = api.getJavaClass();
            if (Serializable.class.equals((Object)javaApi) || Externalizable.class.equals((Object)javaApi) || javaApi.getName().startsWith("javax.ejb") || !javaApi.isAnnotationPresent(Remote.class) && remote == null) continue;
            apiList.add(api);
        }
        if (apiList.size() > 0) {
            return apiList;
        }
        return apiList;
    }

    protected abstract void generateContext(JavaWriter var1) throws IOException;

    protected void generateNewInstance(JavaWriter out, String suffix) throws IOException {
    }

    protected void generateNewRemoteInstance(JavaWriter out, String suffix) throws IOException {
        out.println();
        out.println("protected Object _caucho_newRemoteInstance" + suffix + "()");
        out.println("{");
        out.pushDepth();
        out.println(this._contextClassName + " cxt = new " + this._contextClassName + "(_server);");
        if (this.isStateless()) {
            out.println("Bean bean = new Bean(cxt);");
        } else {
            out.println("Bean bean = new Bean(cxt, null);");
        }
        out.println("cxt._ejb_free(bean);");
        out.println();
        out.println("return cxt.createRemoteView" + suffix + "();");
        out.popDepth();
        out.println("}");
    }

    private void generateBean(JavaWriter out) throws IOException {
        out.println();
        out.println("public static class Bean extends " + this._ejbClass.getName() + " {");
        out.pushDepth();
        out.println();
        out.println("protected final static java.util.logging.Logger __caucho_log");
        out.println("  = java.util.logging.Logger.getLogger(\"" + this._ejbClass.getName() + "\");");
        out.println("private static int __caucho_dbg_id;");
        out.println("private String __caucho_id;");
        out.println(this._contextClassName + " _ejb_context;");
        out.println("boolean _ejb_isActive;");
        boolean i = false;
        out.println();
        if (this.isStateless()) {
            out.println("Bean(" + this._contextClassName + " context)");
        } else {
            out.println("Bean(" + this._contextClassName + " context, com.caucho.config.ConfigContext env)");
        }
        out.println("{");
        out.pushDepth();
        out.println("if (__caucho_isFiner) {");
        out.pushDepth();
        out.println("synchronized (" + this._ejbClass.getName() + ".class) {");
        out.println("  __caucho_id = \"" + this._ejbClass.getName() + "[\" + __caucho_dbg_id++ + \"]\";");
        out.println("}");
        out.println("__caucho_log.fine(__caucho_id + \":new()\");");
        out.popDepth();
        out.println("}");
        out.println("try {");
        out.pushDepth();
        out.println("_ejb_context = context;");
        if (this.hasMethod("setSessionContext", new Class[]{SessionContext.class})) {
            out.println("invokeMethod(this, \"setSessionContext\", new Class[] { javax.ejb.SessionContext.class }, new Object[] { context });");
        }
        out.println();
        if (this.isStateless()) {
            out.println("context.getServer().initInstance(this, null);");
        } else {
            out.println("context.getServer().initInstance(this, env);");
        }
        out.println();
        out.println("__caucho_callInterceptorsPostConstruct();");
        out.popDepth();
        out.println("} catch (RuntimeException e) {");
        out.println("  throw e;");
        out.println("} catch (Exception e) {");
        out.println("  __caucho_log.log(java.util.logging.Level.FINE, e.toString(), e);");
        out.println("  throw com.caucho.ejb.EJBExceptionWrapper.create(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public Object __caucho_callInterceptors(Object target, Object []args, String methodName, Class paramTypes[])");
        out.println("  throws java.lang.reflect.InvocationTargetException");
        out.println("{");
        out.pushDepth();
        out.println("try {");
        out.pushDepth();
        out.println("Class cl;");
        out.println("Class methodParamTypes[] = new Class[] { javax.interceptor.InvocationContext.class };");
        out.println();
        StringBuilder interceptors = new StringBuilder();
        StringBuilder interceptorMethods = new StringBuilder();
        boolean hasAroundInvoke = false;
        i = false;
        out.println("} catch (java.lang.reflect.InvocationTargetException e) {");
        out.println("  throw e;");
        out.println("} catch (RuntimeException e) {");
        out.println("  throw e;");
        out.println("} catch (Throwable e) {");
        out.println("  __caucho_log.log(java.util.logging.Level.FINE, e.toString(), e);");
        out.println("  throw com.caucho.ejb.EJBExceptionWrapper.create(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("private void __caucho_callInterceptorsPostConstruct()");
        out.println("{");
        out.pushDepth();
        out.println("try {");
        out.pushDepth();
        out.println("Class methodParamTypes[] = new Class[] { javax.interceptor.InvocationContext.class };");
        i = false;
        this.generateReflectionGetMethod(out);
        out.popDepth();
        out.println("}");
    }

    protected void generateInitInjection(JavaWriter out) throws IOException {
    }

    protected void generateInjection(JavaWriter out, InjectionTarget injectionTarget, String value, Class cl, boolean isEscapeString) throws IOException {
        value = this.generateTypeCasting(value, cl, isEscapeString);
        String s = injectionTarget.getInjectionTargetName();
        out.println("try {");
        out.pushDepth();
        String methodName = "set" + Character.toUpperCase(s.charAt(0));
        if (s.length() > 1) {
            methodName = methodName + s.substring(1);
        }
        this.generateCallReflectionGetMethod(out, "method", methodName, "new Class[] { " + cl.getName() + ".class }", "getClass().getSuperclass()");
        out.println("method.setAccessible(true);");
        out.print("method.invoke(this, ");
        out.print(value);
        out.println(");");
        out.popDepth();
        out.println("} catch (NoSuchMethodException e1) {");
        out.pushDepth();
        Field field = null;
        try {
            field = cl.getDeclaredField("TYPE");
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
        boolean isPrimitiveWrapper = false;
        if (field != null && Class.class.isAssignableFrom(field.getType())) {
            isPrimitiveWrapper = true;
        }
        if (isPrimitiveWrapper) {
            out.println("try {");
            out.pushDepth();
            this.generateCallReflectionGetMethod(out, "method", methodName, "new Class[] { " + cl.getName() + ".TYPE }", "getClass().getSuperclass()");
            out.println("method.setAccessible(true);");
            out.print("method.invoke(this, ");
            out.print(value);
            out.println(");");
            out.popDepth();
            out.println("} catch (NoSuchMethodException e2) {");
            out.pushDepth();
        }
        out.print("field  = getClass().getSuperclass().getDeclaredField(\"");
        out.print(s);
        out.println("\");");
        out.println("field.setAccessible(true);");
        out.print("field.set(this, ");
        out.print(value);
        out.println(");");
        if (isPrimitiveWrapper) {
            out.popDepth();
            out.println("}");
        }
        out.popDepth();
        out.println("}");
    }

    protected void generateCallReflectionGetMethod(JavaWriter out, String methodVar, String methodName, String paramVar, String classVar) throws IOException {
        out.print("java.lang.reflect.Method ");
        out.print(methodVar);
        out.print(" = com.caucho.ejb.util.EjbUtil.getMethod(");
        out.print(classVar);
        out.print(", \"");
        out.print(methodName);
        out.print("\", ");
        out.print(paramVar);
        out.println(");");
    }

    protected void generateReflectionGetMethod(JavaWriter out) throws IOException {
    }

    protected void generateInvokeMethod(JavaWriter out) throws IOException {
        out.println();
        out.println("private static void invokeMethod(Bean bean, String methodName, Class paramTypes[], Object paramValues[])");
        out.println("{");
        out.pushDepth();
        out.println("try {");
        out.pushDepth();
        out.println("java.lang.reflect.Method m = com.caucho.ejb.util.EjbUtil.getMethod(bean.getClass(), methodName, paramTypes);");
        out.println("m.setAccessible(true);");
        out.println("m.invoke(bean, paramValues);");
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.pushDepth();
        out.println("__caucho_log.log(java.util.logging.Level.FINE, e.toString(), e);");
        out.println("throw com.caucho.ejb.EJBExceptionWrapper.create(e);");
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    @Override
    protected boolean hasMethod(String methodName, Class[] paramTypes) {
        return this._ejbClass.hasMethod(methodName, paramTypes);
    }

    private String generateTypeCasting(String value, Class cl, boolean isEscapeString) {
        if (cl.equals(String.class)) {
            if (isEscapeString) {
                value = "\"" + value + "\"";
            }
        } else if (cl.equals(Character.class)) {
            value = "'" + value + "'";
        } else if (cl.equals(Byte.class)) {
            value = "(byte) " + value;
        } else if (cl.equals(Short.class)) {
            value = "(short) " + value;
        } else if (cl.equals(Integer.class)) {
            value = "(int) " + value;
        } else if (cl.equals(Long.class)) {
            value = "(long) " + value;
        } else if (cl.equals(Float.class)) {
            value = "(float) " + value;
        } else if (cl.equals(Double.class)) {
            value = "(double) " + value;
        }
        return value;
    }
}

