/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.gen.BusinessMethodGenerator;
import com.caucho.ejb.gen.StatefulGenerator;
import com.caucho.ejb.gen.StatefulView;
import com.caucho.ejb.gen.View;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.ejb.SessionBean;
import javax.ejb.TransactionAttributeType;

public class StatefulCreateMethod
extends BusinessMethodGenerator {
    private StatefulGenerator _bean;
    private View _objectView;

    public StatefulCreateMethod(StatefulGenerator bean, StatefulView homeView, View objectView, ApiMethod apiMethod, Method implMethod, int index) {
        super(homeView, apiMethod, implMethod, index);
        this._bean = bean;
        this._objectView = objectView;
        if (this._objectView == null) {
            throw new NullPointerException();
        }
    }

    public void introspect(Method apiMethod, Method implMethod) {
        this.getXa().setContainerManaged(false);
        super.introspect(apiMethod, implMethod);
    }

    protected TransactionAttributeType getDefaultTransactionType() {
        return TransactionAttributeType.REQUIRED;
    }

    public boolean isEnhanced() {
        return true;
    }

    protected void generatePreCall(JavaWriter out) throws IOException {
        out.println("Thread thread = Thread.currentThread();");
        out.println("ClassLoader oldLoader = thread.getContextClassLoader();");
        out.println("try {");
        out.pushDepth();
        out.println("thread.setContextClassLoader(getStatefulServer().getClassLoader());");
        out.println(this._objectView.getViewClassName() + " remote =" + " new " + this._objectView.getViewClassName() + "(getStatefulServer(), (ConfigContext) null);");
        out.print(this._objectView.getBeanClassName());
        out.print(" bean = remote._bean;");
        out.println("StatefulContext context = new " + this._bean.getFullClassName() + "(_context, remote);");
        out.println("remote.__caucho_setContext(context);");
        if (SessionBean.class.isAssignableFrom(this._bean.getEjbClass().getJavaClass())) {
            out.println("bean.setSessionContext(context);");
        }
    }

    protected void generateThis(JavaWriter out) throws IOException {
        out.print("bean");
    }

    protected void generateSuper(JavaWriter out) throws IOException {
        out.print("bean");
    }

    protected String getSuper() {
        return "bean";
    }

    protected void generatePostCall(JavaWriter out) throws IOException {
        out.println("return remote;");
        out.popDepth();
        out.println("} finally {");
        out.println("  thread.setContextClassLoader(oldLoader);");
        out.println("}");
    }
}

