/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.gen.SessionGenerator;
import com.caucho.ejb.gen.StatefulLocalHomeView;
import com.caucho.ejb.gen.StatefulLocalView;
import com.caucho.ejb.gen.StatefulRemoteHomeView;
import com.caucho.ejb.gen.StatefulRemoteView;
import com.caucho.ejb.gen.StatefulView;
import com.caucho.ejb.gen.View;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;

public class StatefulGenerator
extends SessionGenerator {
    private static final L10N L = new L10N(StatefulGenerator.class);

    public StatefulGenerator(String ejbName, ApiClass ejbClass) {
        super(ejbName, ejbClass);
    }

    public boolean isStateless() {
        return false;
    }

    protected View createLocalView(ApiClass api) {
        return new StatefulLocalView(this, api);
    }

    protected View createLocalHomeView(ApiClass api) {
        return new StatefulLocalHomeView(this, api);
    }

    protected View createRemoteHomeView(ApiClass api) {
        return new StatefulRemoteHomeView(this, api);
    }

    protected View createRemoteView(ApiClass api) {
        return new StatefulRemoteView(this, api);
    }

    public void generate(JavaWriter out) throws IOException {
        this.generateTopComment(out);
        out.println();
        out.println("package " + this.getPackageName() + ";");
        out.println();
        out.println("import com.caucho.config.*;");
        out.println("import com.caucho.ejb.*;");
        out.println("import com.caucho.ejb.session.*;");
        out.println();
        out.println("import javax.ejb.*;");
        out.println("import javax.transaction.*;");
        out.println();
        out.println("public class " + this.getClassName());
        out.println("  extends StatefulContext");
        out.println("{");
        out.pushDepth();
        out.println();
        out.println("public " + this.getClassName() + "(StatefulServer server)");
        out.println("{");
        out.pushDepth();
        out.println("super(server);");
        for (View view : this.getViews()) {
            view.generateContextHomeConstructor(out);
        }
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public " + this.getClassName() + "(" + this.getClassName() + " context)");
        out.println("{");
        out.pushDepth();
        out.println("super(context.getStatefulServer());");
        this.generateContextObjectConstructor(out);
        out.popDepth();
        out.println("}");
        for (View view : this.getViews()) {
            view.generateContextPrologue(out);
        }
        this.generateCreateProvider(out);
        this.generateViews(out);
        this.generateDependency(out);
        out.popDepth();
        out.println("}");
    }

    protected void generateCreateProvider(JavaWriter out) throws IOException {
        out.println();
        out.println("@Override");
        out.println("public StatefulProvider getProvider(Class api)");
        out.println("{");
        out.pushDepth();
        for (View view : this.getViews()) {
            StatefulView sView = (StatefulView)view;
            sView.generateCreateProvider(out, "api");
        }
        out.println();
        out.println("return super.getProvider(api);");
        out.popDepth();
        out.println("}");
    }

    public void generateContextObjectConstructor(JavaWriter out) throws IOException {
        for (View view : this.getViews()) {
            view.generateContextObjectConstructor(out);
        }
    }

    protected void generateContext(JavaWriter out) {
    }
}

