/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.gen.BusinessMethodGenerator;
import com.caucho.ejb.gen.StatefulCreateMethod;
import com.caucho.ejb.gen.StatefulGenerator;
import com.caucho.ejb.gen.StatefulView;
import com.caucho.ejb.gen.View;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.lang.reflect.Method;

public abstract class StatefulHomeView
extends StatefulView {
    private static final L10N L = new L10N(StatefulHomeView.class);

    public StatefulHomeView(StatefulGenerator bean, ApiClass api) {
        super(bean, api);
    }

    protected abstract String getViewClassName();

    public void generateCreateProvider(JavaWriter out, String var) throws IOException {
        out.println();
        out.println("if (" + var + " == " + this.getApi().getName() + ".class)");
        out.println("  return _localHome;");
    }

    protected void generateClassContent(JavaWriter out) throws IOException {
        out.println("private " + this.getContextClassName() + " _context;");
        out.println("private StatefulServer _server;");
        this.generateBusinessPrologue(out);
        out.println();
        out.println(this.getViewClassName() + "(" + this.getContextClassName() + " context)");
        out.println("{");
        out.pushDepth();
        this.generateSuper(out, "context.getStatefulServer()");
        out.println("_context = context;");
        out.println("_server = context.getStatefulServer();");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public Object __caucho_createNew(ConfigContext env)");
        out.println("{");
        out.println("  return this;");
        out.println("}");
        out.println();
        out.println("public StatefulServer getStatefulServer()");
        out.println("{");
        out.println("  return _server;");
        out.println("}");
        out.println();
        this.generateCreate(out);
        this.generateBusinessMethods(out);
    }

    protected void generateCreate(JavaWriter out) throws IOException {
    }

    protected BusinessMethodGenerator createMethod(ApiMethod apiMethod, int index) {
        if (apiMethod.getName().startsWith("create")) {
            String implName = "ejbC" + apiMethod.getName().substring(1);
            ApiMethod implMethod = this.getEjbClass().getMethod(implName, apiMethod.getParameterTypes());
            if (implMethod == null) {
                throw ConfigException.create((Method)apiMethod.getMethod(), (String)L.l("api has no matching '{0}' method in '{1}'", (Object)implName, (Object)this.getEjbClass().getName()));
            }
            View localView = this.getSessionBean().getView(apiMethod.getReturnType());
            if (localView == null) {
                throw ConfigException.create((Method)apiMethod.getMethod(), (String)L.l("'{0}' is an unknown object interface", (Object)apiMethod.getReturnType()));
            }
            StatefulCreateMethod method = new StatefulCreateMethod(this.getSessionBean(), this, localView, apiMethod, implMethod.getMethod(), index);
            method.getXa().setContainerManaged(false);
            return method;
        }
        return super.createMethod(apiMethod, index);
    }

    protected ApiMethod findImplMethod(ApiMethod apiMethod) {
        if (apiMethod.getName().equals("create")) {
            return this.getEjbClass().getMethod("ejbCreate", apiMethod.getParameterTypes());
        }
        if (apiMethod.getName().equals("remove") && apiMethod.getDeclaringClass().getName().startsWith("javax.ejb")) {
            return null;
        }
        return super.findImplMethod(apiMethod);
    }

    protected void generateSuper(JavaWriter out, String serverVar) throws IOException {
        out.println("super(" + serverVar + ");");
    }

    protected void generateExtends(JavaWriter out) throws IOException {
        out.println("  extends StatefulHome");
    }
}

