/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.gen.BusinessMethodGenerator;
import com.caucho.ejb.gen.StatefulCreateMethod;
import com.caucho.ejb.gen.StatefulGenerator;
import com.caucho.ejb.gen.StatefulHomeView;
import com.caucho.ejb.gen.View;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.ejb.EJBLocalHome;

public class StatefulLocalHomeView
extends StatefulHomeView {
    private static final L10N L = new L10N(StatefulLocalHomeView.class);

    public StatefulLocalHomeView(StatefulGenerator bean, ApiClass api) {
        super(bean, api);
    }

    protected String getViewClassName() {
        return this.getApi().getSimpleName() + "__EJBLocalHome";
    }

    public void generateContextPrologue(JavaWriter out) throws IOException {
        out.println();
        out.println("private " + this.getViewClassName() + " _localHome;");
        if (EJBLocalHome.class.isAssignableFrom(this.getApi().getJavaClass())) {
            out.println();
            out.println("@Override");
            out.println("public EJBLocalHome getEJBLocalHome()");
            out.println("{");
            out.println("  return _localHome;");
            out.println("}");
        }
    }

    public void generateContextHomeConstructor(JavaWriter out) throws IOException {
        out.println("_localHome = new " + this.getViewClassName() + "(this);");
    }

    public void generateCreateProvider(JavaWriter out, String var) throws IOException {
        out.println();
        out.println("if (" + var + " == " + this.getApi().getName() + ".class)");
        out.println("  return _localHome;");
    }

    public void generateContextObjectConstructor(JavaWriter out) throws IOException {
        out.println("_localHome = context._localHome;");
    }

    protected BusinessMethodGenerator createMethod(ApiMethod apiMethod, int index) {
        if (apiMethod.getName().equals("create")) {
            ApiMethod implMethod = this.getEjbClass().getMethod("ejbCreate", apiMethod.getParameterTypes());
            if (implMethod == null) {
                throw ConfigException.create((Method)apiMethod.getMethod(), (String)L.l("can't find ejbCreate"));
            }
            View localView = this.getSessionBean().getView(apiMethod.getReturnType());
            if (localView == null) {
                throw ConfigException.create((Method)apiMethod.getMethod(), (String)L.l("'{0}' is an unknown object interface", (Object)apiMethod.getReturnType()));
            }
            return new StatefulCreateMethod(this.getSessionBean(), this, localView, apiMethod, implMethod.getMethod(), index);
        }
        return super.createMethod(apiMethod, index);
    }

    protected ApiMethod findImplMethod(ApiMethod apiMethod) {
        if (apiMethod.getName().equals("create")) {
            return this.getEjbClass().getMethod("ejbCreate", apiMethod.getParameterTypes());
        }
        return super.findImplMethod(apiMethod);
    }

    protected void generateSuper(JavaWriter out, String serverVar) throws IOException {
        out.println("super(" + serverVar + ");");
    }

    protected void generateExtends(JavaWriter out) throws IOException {
        out.println("  extends StatefulHome");
    }
}

