/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.gen.StatefulGenerator;
import com.caucho.ejb.gen.StatefulObjectView;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import javax.ejb.EJBLocalObject;

public class StatefulLocalView
extends StatefulObjectView {
    private static final L10N L = new L10N(StatefulLocalView.class);

    public StatefulLocalView(StatefulGenerator bean, ApiClass api) {
        super(bean, api);
    }

    protected void generateExtends(JavaWriter out) throws IOException {
        if (EJBLocalObject.class.isAssignableFrom(this.getApi().getJavaClass())) {
            out.println("  extends StatefulObject");
        }
    }

    protected String getViewClassName() {
        return this.getApi().getSimpleName() + "__EJBLocal";
    }

    public void generateContextPrologue(JavaWriter out) throws IOException {
        out.println();
        out.println("private " + this.getViewClassName() + " _localObject;");
        if (EJBLocalObject.class.isAssignableFrom(this.getApi().getJavaClass())) {
            out.println();
            out.println("@Override");
            out.println("public EJBLocalObject getEJBLocalObject()");
            out.println("{");
            out.println("  if (_localObject != null)");
            out.println("    return _localObject;");
            out.println("  else");
            out.println("    return super.getEJBLocalObject();");
            out.println("}");
        }
        out.println();
        out.println("public " + this.getSessionBean().getClassName() + "(" + this.getContextClassName() + " context, " + this.getViewClassName() + " localObject)");
        out.println("{");
        out.println("  this(context);");
        out.println();
        out.println("  _localObject = localObject;");
        out.println("}");
    }
}

