/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.gen.BusinessMethodGenerator;
import com.caucho.ejb.gen.StatefulView;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import javax.ejb.Remove;
import javax.ejb.TransactionAttributeType;

public class StatefulMethod
extends BusinessMethodGenerator {
    private boolean _isRemove;
    private boolean _isRemoveRetainIfException;

    public StatefulMethod(StatefulView view, ApiMethod apiMethod, Method implMethod, int index) {
        super(view, apiMethod, implMethod, index);
    }

    public void setRemove(boolean isRemove) {
        this._isRemove = isRemove;
    }

    public void setRemoveRetainIfException(boolean isRetain) {
        this._isRemoveRetainIfException = isRetain;
    }

    public void introspect(Method apiMethod, Method implMethod) {
        this.getXa().setTransactionType(this.getDefaultTransactionType());
        super.introspect(apiMethod, implMethod);
        Remove remove = implMethod.getAnnotation(Remove.class);
        if (remove != null) {
            this._isRemove = true;
            this._isRemoveRetainIfException = remove.retainIfException();
        }
    }

    protected TransactionAttributeType getDefaultTransactionType() {
        return TransactionAttributeType.REQUIRED;
    }

    public boolean isEnhanced() {
        return true;
    }

    protected void generateContent(JavaWriter out) throws IOException {
        if (this.getView().isRemote() && this.hasException(NoSuchObjectException.class)) {
            out.println("if (_bean == null)");
            out.println("  throw new java.rmi.NoSuchObjectException(\"stateful instance " + this.getEjbClass().getSimpleName() + " is no longer valid\");");
        } else {
            out.println("if (_bean == null)");
            out.println("  throw new javax.ejb.NoSuchEJBException(\"stateful instance " + this.getEjbClass().getSimpleName() + " is no longer valid\");");
        }
        if (this._isRemove) {
            out.println("boolean isRemove = false;");
            out.println("try {");
            out.pushDepth();
        }
        super.generateContent(out);
        if (this._isRemove) {
            out.println("isRemove = true;");
            out.popDepth();
            if (this._isRemoveRetainIfException) {
                out.println("} catch (RuntimeException e) {");
                out.println("  isRemove = true;");
                out.println("  throw e;");
            }
            out.println("} finally {");
            if (this._isRemoveRetainIfException) {
                out.println("if (isRemove) {");
                out.pushDepth();
            }
            out.println("  Object bean = _bean;");
            out.println("  _bean = null;");
            out.println("  _server.destroyInstance(bean);");
            if (this._isRemoveRetainIfException) {
                out.popDepth();
                out.println("}");
            }
            out.println("}");
        }
    }

    protected void generatePreCall(JavaWriter out) throws IOException {
        out.println("if (_isActive)");
        out.println("  throw new EJBException(\"session bean is not reentrant\");");
        out.println();
        out.println("Thread thread = Thread.currentThread();");
        out.println("ClassLoader oldLoader = thread.getContextClassLoader();");
        out.println("try {");
        out.pushDepth();
        out.println("thread.setContextClassLoader(_server.getClassLoader());");
        out.println("_isActive = true;");
    }

    protected void generateThis(JavaWriter out) throws IOException {
        out.print("_bean");
    }

    protected void generateSuper(JavaWriter out) throws IOException {
        out.print("_bean");
    }

    protected String getSuper() throws IOException {
        return "_bean";
    }

    protected void generatePostCall(JavaWriter out) throws IOException {
        out.popDepth();
        out.println("} finally {");
        out.println("  thread.setContextClassLoader(oldLoader);");
        out.println("  _isActive = false;");
        out.println("}");
    }
}

