/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.gen.BusinessMethodGenerator;
import com.caucho.ejb.gen.StatefulGenerator;
import com.caucho.ejb.gen.StatefulRemoveMethod;
import com.caucho.ejb.gen.StatefulView;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.HashMap;
import javax.ejb.SessionSynchronization;

public abstract class StatefulObjectView
extends StatefulView {
    private static final L10N L = new L10N(StatefulObjectView.class);

    public StatefulObjectView(StatefulGenerator bean, ApiClass api) {
        super(bean, api);
    }

    public void generateBean(JavaWriter out) throws IOException {
        out.println();
        out.println("public static class " + this.getBeanClassName());
        out.println("  extends " + this.getEjbClass().getName());
        out.println("{");
        out.pushDepth();
        out.println("private transient " + this.getViewClassName() + " _context;");
        HashMap map = new HashMap();
        this.generateBusinessPrologue(out, map);
        out.println();
        out.println(this.getBeanClassName() + "(" + this.getViewClassName() + " context)");
        out.println("{");
        out.pushDepth();
        out.println("_context = context;");
        map = new HashMap();
        this.generateBusinessConstructor(out, map);
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    protected BusinessMethodGenerator createMethod(ApiMethod apiMethod, int index) {
        if (apiMethod.getName().equals("remove") && apiMethod.getDeclaringClass().getName().startsWith("javax.ejb.")) {
            ApiMethod implMethod = this.findImplMethod(apiMethod);
            if (implMethod == null) {
                return null;
            }
            StatefulRemoveMethod method = new StatefulRemoveMethod(this, apiMethod, implMethod.getMethod(), index);
            method.getXa().setContainerManaged(false);
            return method;
        }
        BusinessMethodGenerator method = super.createMethod(apiMethod, index);
        Class beanClass = this.getEjbClass().getJavaClass();
        if (SessionSynchronization.class.isAssignableFrom(beanClass)) {
            method.getXa().setSynchronization(true);
        }
        return method;
    }

    protected ApiMethod findImplMethod(ApiMethod apiMethod) {
        if (apiMethod.getName().equals("remove") && apiMethod.getDeclaringClass().getName().startsWith("javax.ejb")) {
            if (apiMethod.getParameterTypes().length != 0) {
                return null;
            }
            return this.getEjbClass().getMethod("ejbRemove", new Class[0]);
        }
        return super.findImplMethod(apiMethod);
    }
}

