/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.gen.StatefulGenerator;
import com.caucho.ejb.gen.StatefulObjectView;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import javax.ejb.EJBObject;

public class StatefulRemoteView
extends StatefulObjectView {
    private static final L10N L = new L10N(StatefulRemoteView.class);

    public StatefulRemoteView(StatefulGenerator bean, ApiClass api) {
        super(bean, api);
    }

    protected String getViewClassName() {
        return this.getApi().getSimpleName() + "__EJBRemote";
    }

    public boolean isRemote() {
        return true;
    }

    protected void generateExtends(JavaWriter out) throws IOException {
        out.println("  extends StatefulObject");
    }

    public void generateContextPrologue(JavaWriter out) throws IOException {
        out.println();
        out.println("private " + this.getViewClassName() + " _remoteObject;");
        if (EJBObject.class.isAssignableFrom(this.getApi().getJavaClass())) {
            out.println();
            out.println("@Override");
            out.println("public EJBObject getEJBObject()");
            out.println("{");
            out.println("  if (_remoteObject != null)");
            out.println("    return _remoteObject;");
            out.println("  else");
            out.println("    return super.getEJBObject();");
            out.println("}");
        }
        out.println();
        out.println("public " + this.getSessionBean().getClassName() + "(" + this.getContextClassName() + " context, " + this.getViewClassName() + " remoteObject)");
        out.println("{");
        out.println("  this(context);");
        out.println();
        out.println("  _remoteObject = remoteObject;");
        out.println("}");
    }

    public void generateClassContent(JavaWriter out) throws IOException {
        super.generateClassContent(out);
    }
}

