/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.gen.BusinessMethodGenerator;
import com.caucho.ejb.gen.StatefulGenerator;
import com.caucho.ejb.gen.StatefulMethod;
import com.caucho.ejb.gen.View;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StatefulView
extends View {
    private static final L10N L = new L10N(StatefulView.class);
    private StatefulGenerator _sessionBean;
    private ArrayList<BusinessMethodGenerator> _businessMethods = new ArrayList();

    public StatefulView(StatefulGenerator bean, ApiClass api) {
        super(bean, api);
        this._sessionBean = bean;
    }

    public StatefulGenerator getSessionBean() {
        return this._sessionBean;
    }

    public String getContextClassName() {
        return this.getSessionBean().getClassName();
    }

    @Override
    protected abstract String getViewClassName();

    @Override
    protected String getBeanClassName() {
        return this.getApi().getSimpleName() + "__Bean";
    }

    @Override
    public ArrayList<? extends BusinessMethodGenerator> getMethods() {
        return this._businessMethods;
    }

    @Override
    public void introspect() {
        ApiClass implClass = this.getEjbClass();
        ApiClass apiClass = this.getApi();
        for (ApiMethod apiMethod : apiClass.getMethods()) {
            if (apiMethod.getDeclaringClass().equals(Object.class) || apiMethod.getDeclaringClass().getName().startsWith("javax.ejb.") && !apiMethod.getName().equals("remove")) continue;
            if (apiMethod.getName().startsWith("ejb")) {
                throw new ConfigException(L.l("{0}: '{1}' must not start with 'ejb'.  The EJB spec reserves all methods starting with ejb.", (Object)apiMethod.getDeclaringClass(), (Object)apiMethod.getName()));
            }
            int index = this._businessMethods.size();
            BusinessMethodGenerator bizMethod = this.createMethod(apiMethod, index);
            if (bizMethod == null) continue;
            bizMethod.introspect(bizMethod.getApiMethod(), bizMethod.getImplMethod());
            this._businessMethods.add(bizMethod);
        }
    }

    public void generateCreateProvider(JavaWriter out, String var) throws IOException {
        out.println();
        out.println("if (" + var + " == " + this.getApi().getName() + ".class)");
        out.println("  return new " + this.getViewClassName() + "(getStatefulServer());");
    }

    @Override
    public void generate(JavaWriter out) throws IOException {
        this.generateBean(out);
        out.println();
        out.println("public static class " + this.getViewClassName());
        this.generateExtends(out);
        out.print("  implements " + this.getApi().getDeclarationName());
        out.println(", StatefulProvider");
        out.println("{");
        out.pushDepth();
        this.generateClassContent(out);
        out.popDepth();
        out.println("}");
    }

    protected void generateBean(JavaWriter out) throws IOException {
    }

    protected void generateClassContent(JavaWriter out) throws IOException {
        out.println("private StatefulContext _context;");
        out.println("private StatefulServer _server;");
        out.println("private " + this.getBeanClassName() + " _bean;");
        out.println("private boolean _isActive;");
        out.println();
        out.println("private static final com.caucho.ejb3.xa.XAManager _xa");
        out.println("  = new com.caucho.ejb3.xa.XAManager();");
        out.println();
        out.println(this.getViewClassName() + "(StatefulServer server)");
        out.println("{");
        out.pushDepth();
        this.generateSuper(out, "server");
        out.println("_server = server;");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public " + this.getViewClassName() + "(StatefulServer server, ConfigContext env)");
        out.println("{");
        out.pushDepth();
        this.generateSuper(out, "server");
        out.println("_server = server;");
        out.println("_bean = new " + this.getBeanClassName() + "(this);");
        out.popDepth();
        out.println("}");
        this.generateSessionProvider(out);
        out.println();
        out.println("public " + this.getViewClassName() + "(StatefulServer server, " + this.getBeanClassName() + " bean)");
        out.println("{");
        this.generateSuper(out, "server");
        out.println("  _server = server;");
        out.println("  _bean = bean;");
        out.println("}");
        out.println();
        out.println("public StatefulServer getStatefulServer()");
        out.println("{");
        out.println("  return _server;");
        out.println("}");
        out.println();
        out.println();
        out.println("void __caucho_setContext(StatefulContext context)");
        out.println("{");
        out.println("  _context = context;");
        out.println("}");
        this.generateBusinessMethods(out);
    }

    protected void generateSessionProvider(JavaWriter out) throws IOException {
        out.println();
        out.println("public Object __caucho_createNew(ConfigContext env)");
        out.println("{");
        out.println("  " + this.getViewClassName() + " bean" + " = new " + this.getViewClassName() + "(_server, env);");
        out.println("  _server.initInstance(bean._bean, env);");
        out.println("  return bean;");
        out.println("}");
    }

    protected BusinessMethodGenerator createMethod(ApiMethod apiMethod, int index) {
        ApiMethod implMethod = this.findImplMethod(apiMethod);
        if (implMethod == null) {
            return null;
        }
        StatefulMethod bizMethod = new StatefulMethod(this, apiMethod, implMethod.getMethod(), index);
        return bizMethod;
    }

    protected void generateSuper(JavaWriter out, String serverVar) throws IOException {
    }

    protected void generateExtends(JavaWriter out) throws IOException {
    }

    protected ApiMethod findImplMethod(ApiMethod apiMethod) {
        ApiMethod implMethod = this.getEjbClass().getMethod(apiMethod);
        if (implMethod != null) {
            return implMethod;
        }
        throw new ConfigException(L.l("'{0}' method '{1}' has no corresponding implementation in '{2}'", (Object)apiMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)StatefulView.getFullMethodName(apiMethod), (Object)this.getEjbClass().getName()));
    }
}

