/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.gen.SessionGenerator;
import com.caucho.ejb.gen.StatelessLocalHomeView;
import com.caucho.ejb.gen.StatelessLocalView;
import com.caucho.ejb.gen.StatelessRemoteHomeView;
import com.caucho.ejb.gen.StatelessRemoteView;
import com.caucho.ejb.gen.StatelessView;
import com.caucho.ejb.gen.View;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;

public class StatelessGenerator
extends SessionGenerator {
    private static final L10N L = new L10N(StatelessGenerator.class);

    public StatelessGenerator(String ejbName, ApiClass ejbClass) {
        super(ejbName, ejbClass);
    }

    public boolean isStateless() {
        return true;
    }

    protected View createLocalView(ApiClass api) {
        return new StatelessLocalView(this, api);
    }

    protected View createLocalHomeView(ApiClass api) {
        return new StatelessLocalHomeView(this, api);
    }

    protected View createRemoteView(ApiClass api) {
        return new StatelessRemoteView(this, api);
    }

    protected View createRemoteHomeView(ApiClass api) {
        return new StatelessRemoteHomeView(this, api);
    }

    public void generate(JavaWriter out) throws IOException {
        this.generateTopComment(out);
        out.println();
        out.println("package " + this.getPackageName() + ";");
        out.println();
        out.println("import com.caucho.config.*;");
        out.println("import com.caucho.ejb.session.*;");
        out.println();
        out.println("import javax.ejb.*;");
        out.println("import javax.transaction.*;");
        out.println();
        out.println("public class " + this.getClassName());
        out.println("  extends StatelessContext");
        out.println("{");
        out.pushDepth();
        this.generateContext(out);
        this.generateCreateProvider(out);
        this.generateViews(out);
        this.generateDependency(out);
        out.popDepth();
        out.println("}");
    }

    protected void generateCreateProvider(JavaWriter out) throws IOException {
        out.println();
        out.println("public StatelessProvider getProvider(Class api)");
        out.println("{");
        out.pushDepth();
        for (View view : this.getViews()) {
            StatelessView sView = (StatelessView)view;
            sView.generateCreateProvider(out, "api");
        }
        out.println();
        out.println("return super.getProvider(api);");
        out.popDepth();
        out.println("}");
    }

    protected void generateContext(JavaWriter out) throws IOException {
        String shortContextName = this.getEjbClass().getSimpleName();
        int freeStackMax = 16;
        out.println("protected static final java.util.logging.Logger __caucho_log = java.util.logging.Logger.getLogger(\"" + this.getFullClassName() + "\");");
        out.println("protected static final boolean __caucho_isFiner = __caucho_log.isLoggable(java.util.logging.Level.FINER);");
        String beanClass = this.getEjbClass().getName();
        out.println();
        out.println("private " + beanClass + " []_freeBeanStack = new " + beanClass + "[" + freeStackMax + "];");
        out.println("private int _freeBeanTop;");
        out.println();
        out.println("public " + this.getClassName() + "(StatelessServer server)");
        out.println("{");
        out.pushDepth();
        out.println("super(server);");
        for (View view : this.getViews()) {
            view.generateContextHomeConstructor(out);
        }
        out.popDepth();
        out.println("}");
        for (View view : this.getViews()) {
            view.generateContextPrologue(out);
        }
        out.println();
        out.println("public void __caucho_timeout_callback(javax.ejb.Timer timer)");
        out.println("{");
        out.pushDepth();
        for (View view : this.getViews()) {
            view.generateTimer(out);
        }
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public void destroy()");
        out.println("{");
        out.pushDepth();
        this.generateDestroyViews(out);
        out.popDepth();
        out.println("}");
    }

    public void generateViews(JavaWriter out) throws IOException {
        for (View view : this.getViews()) {
            out.println();
            view.generate(out);
        }
    }

    protected void generateNewInstance(JavaWriter out) throws IOException {
    }
}

